/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.KeyWrapperFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PTFDeserializer;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class PTFOperator
extends Operator<PTFDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    PTFPartition inputPart;
    boolean isMapOperator;
    transient KeyWrapperFactory keyWrapperFactory;
    protected transient KeyWrapper currentKeys;
    protected transient KeyWrapper newKeys;
    transient HiveConf hiveConf;

    @Override
    protected void initializeOp(Configuration jobConf) throws HiveException {
        this.hiveConf = new HiveConf(jobConf, PTFOperator.class);
        Operator<OperatorDesc> parentOp = this.getParentOperators().get(0);
        this.isMapOperator = ((PTFDesc)this.conf).isMapSide();
        this.reconstructQueryDef(this.hiveConf);
        this.inputPart = this.createFirstPartitionForChain(this.inputObjInspectors[0], this.hiveConf, this.isMapOperator);
        if (this.isMapOperator) {
            PartitionedTableFunctionDef tDef = ((PTFDesc)this.conf).getStartOfChain();
            this.outputObjInspector = tDef.getRawInputShape().getOI();
        } else {
            this.outputObjInspector = ((PTFDesc)this.conf).getFuncDef().getOutputShape().getOI();
        }
        this.setupKeysWrapper(this.inputObjInspectors[0]);
        super.initializeOp(jobConf);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        if (this.inputPart.size() != 0) {
            if (this.isMapOperator) {
                this.processMapFunction();
            } else {
                this.processInputPartition();
            }
        }
        this.inputPart.close();
        this.inputPart = null;
        for (PTFInputDef iDef = ((PTFDesc)this.conf).getFuncDef(); iDef != null; iDef = ((PTFInputDef)iDef).getInput()) {
            if (!(iDef instanceof PartitionedTableFunctionDef)) continue;
            iDef.getTFunction().close();
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (!this.isMapOperator) {
            boolean keysAreEqual;
            this.newKeys.getNewKey(row, (ObjectInspector)this.inputPart.getInputOI());
            boolean bl = keysAreEqual = this.currentKeys != null && this.newKeys != null ? this.newKeys.equals(this.currentKeys) : false;
            if (this.currentKeys != null && !keysAreEqual) {
                this.processInputPartition();
                this.inputPart.reset();
            }
            if (this.currentKeys == null || !keysAreEqual) {
                if (this.currentKeys == null) {
                    this.currentKeys = this.newKeys.copyKey();
                } else {
                    this.currentKeys.copyKey(this.newKeys);
                }
            }
        }
        this.inputPart.append(row);
    }

    protected void reconstructQueryDef(HiveConf hiveConf) throws HiveException {
        PTFDeserializer dS = new PTFDeserializer((PTFDesc)this.conf, (StructObjectInspector)this.inputObjInspectors[0], hiveConf);
        dS.initializePTFChain(((PTFDesc)this.conf).getFuncDef());
    }

    protected void setupKeysWrapper(ObjectInspector inputOI) throws HiveException {
        PartitionDef pDef = ((PTFDesc)this.conf).getStartOfChain().getPartition();
        List<PTFExpressionDef> exprs = pDef.getExpressions();
        int numExprs = exprs.size();
        ExprNodeEvaluator[] keyFields = new ExprNodeEvaluator[numExprs];
        ObjectInspector[] keyOIs = new ObjectInspector[numExprs];
        ObjectInspector[] currentKeyOIs = new ObjectInspector[numExprs];
        for (int i = 0; i < numExprs; ++i) {
            PTFExpressionDef exprDef = exprs.get(i);
            keyFields[i] = ExprNodeEvaluatorFactory.get(exprDef.getExprNode());
            keyOIs[i] = keyFields[i].initialize(inputOI);
            currentKeyOIs[i] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)keyOIs[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        this.keyWrapperFactory = new KeyWrapperFactory(keyFields, keyOIs, currentKeyOIs);
        this.newKeys = this.keyWrapperFactory.getKeyWrapper();
    }

    protected void processInputPartition() throws HiveException {
        PTFPartition outPart = this.executeChain(this.inputPart);
        PTFPartition.PTFPartitionIterator<Object> pItr = outPart.iterator();
        while (pItr.hasNext()) {
            Object oRow = pItr.next();
            this.forward(oRow, this.outputObjInspector);
        }
    }

    protected void processMapFunction() throws HiveException {
        PartitionedTableFunctionDef tDef = ((PTFDesc)this.conf).getStartOfChain();
        PTFPartition outPart = tDef.getTFunction().transformRawInput(this.inputPart);
        PTFPartition.PTFPartitionIterator<Object> pItr = outPart.iterator();
        while (pItr.hasNext()) {
            Object oRow = pItr.next();
            this.forward(oRow, this.outputObjInspector);
        }
    }

    @Override
    public String getName() {
        return PTFOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "PTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.PTF;
    }

    private PTFPartition executeChain(PTFPartition part) throws HiveException {
        ArrayDeque<PartitionedTableFunctionDef> fnDefs = new ArrayDeque<PartitionedTableFunctionDef>();
        PTFInputDef iDef = ((PTFDesc)this.conf).getFuncDef();
        while (iDef instanceof PartitionedTableFunctionDef) {
            fnDefs.push((PartitionedTableFunctionDef)iDef);
            iDef = iDef.getInput();
        }
        while (!fnDefs.isEmpty()) {
            PartitionedTableFunctionDef currFnDef = (PartitionedTableFunctionDef)fnDefs.pop();
            part = currFnDef.getTFunction().execute(part);
        }
        return part;
    }

    public PTFPartition createFirstPartitionForChain(ObjectInspector oi, HiveConf hiveConf, boolean isMapSide) throws HiveException {
        PartitionedTableFunctionDef tabDef = ((PTFDesc)this.conf).getStartOfChain();
        TableFunctionEvaluator tEval = tabDef.getTFunction();
        PTFPartition part = null;
        SerDe serde = isMapSide ? tabDef.getInput().getOutputShape().getSerde() : tabDef.getRawInputShape().getSerde();
        StructObjectInspector outputOI = isMapSide ? tabDef.getInput().getOutputShape().getOI() : tabDef.getRawInputShape().getOI();
        part = PTFPartition.create(((PTFDesc)this.conf).getCfg(), serde, (StructObjectInspector)oi, outputOI);
        return part;
    }

    public static void connectLeadLagFunctionsToPartition(PTFDesc ptfDesc, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
        List<ExprNodeGenericFuncDesc> llFnDescs = ptfDesc.getLlInfo().getLeadLagExprs();
        if (llFnDescs == null) {
            return;
        }
        for (ExprNodeGenericFuncDesc llFnDesc : llFnDescs) {
            GenericUDFLeadLag llFn = (GenericUDFLeadLag)llFnDesc.getGenericUDF();
            llFn.setpItr(pItr);
        }
    }
}

