/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyBytes;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;

public abstract class MapJoinKey {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final HashSet<PrimitiveObjectInspector.PrimitiveCategory> SUPPORTED_PRIMITIVES = new HashSet();

    public static MapJoinKey read(ByteStream.Output output, MapJoinKey key, MapJoinObjectSerDeContext context, Writable writable, boolean mayReuseKey) throws SerDeException {
        SerDe serde = context.getSerDe();
        Object obj = serde.deserialize(writable);
        boolean useOptimized = MapJoinKey.useOptimizedKeyBasedOnPrev(key);
        if (useOptimized || key == null) {
            byte[] structBytes = MapJoinKey.serializeKey(output, obj, serde.getObjectInspector(), !useOptimized);
            if (structBytes != null) {
                return MapJoinKeyBytes.fromBytes(key, mayReuseKey, structBytes);
            }
            if (useOptimized) {
                throw new SerDeException("Failed to serialize " + obj + " even though optimized keys are used");
            }
        }
        MapJoinKeyObject result = mayReuseKey ? (MapJoinKeyObject)key : new MapJoinKeyObject();
        result.read(serde.getObjectInspector(), obj);
        return result;
    }

    private static byte[] serializeKey(ByteStream.Output byteStream, Object obj, ObjectInspector oi, boolean checkTypes) throws SerDeException {
        if (null == obj || !(oi instanceof StructObjectInspector)) {
            return null;
        }
        StructObjectInspector soi = (StructObjectInspector)oi;
        List fields = soi.getAllStructFieldRefs();
        int size = fields.size();
        if (size > 8) {
            return null;
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        Object[] fieldData = new Object[size];
        ArrayList<ObjectInspector> fieldOis = new ArrayList<ObjectInspector>(size);
        for (int i = 0; i < size; ++i) {
            StructField field = (StructField)fields.get(i);
            ObjectInspector foi = field.getFieldObjectInspector();
            if (checkTypes) {
                if (foi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    return null;
                }
                PrimitiveObjectInspector.PrimitiveCategory pc = ((PrimitiveObjectInspector)foi).getPrimitiveCategory();
                if (!SUPPORTED_PRIMITIVES.contains(pc)) {
                    return null;
                }
            }
            fieldData[i] = soi.getStructFieldData(obj, field);
            fieldOis.add(foi);
        }
        return MapJoinKey.serializeRowCommon(byteStream, fieldData, fieldOis);
    }

    public static MapJoinKey readFromVector(ByteStream.Output output, MapJoinKey key, VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch, boolean mayReuseKey) throws HiveException {
        boolean useOptimized = MapJoinKey.useOptimizedKeyBasedOnPrev(key);
        if (useOptimized || key == null) {
            byte[] structBytes = null;
            try {
                structBytes = MapJoinKey.serializeVector(output, kw, keyOutputWriters, keyWrapperBatch);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
            if (structBytes != null) {
                return MapJoinKeyBytes.fromBytes(key, mayReuseKey, structBytes);
            }
            if (useOptimized) {
                throw new HiveException("Failed to serialize " + kw + " even though optimized keys are used");
            }
        }
        MapJoinKeyObject result = mayReuseKey ? (MapJoinKeyObject)key : new MapJoinKeyObject();
        result.readFromVector(kw, keyOutputWriters, keyWrapperBatch);
        return result;
    }

    private static byte[] serializeVector(ByteStream.Output byteStream, VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch) throws HiveException, SerDeException {
        Object[] fieldData = new Object[keyOutputWriters.length];
        ArrayList<ObjectInspector> fieldOis = new ArrayList<ObjectInspector>();
        for (int i = 0; i < keyOutputWriters.length; ++i) {
            VectorExpressionWriter writer = keyOutputWriters[i];
            fieldOis.add(writer.getObjectInspector());
            fieldData[i] = keyWrapperBatch.getWritableKeyValue(kw, i, writer);
        }
        return MapJoinKey.serializeRowCommon(byteStream, fieldData, fieldOis);
    }

    public static MapJoinKey readFromRow(ByteStream.Output output, MapJoinKey key, Object row, List<ExprNodeEvaluator> fields, List<ObjectInspector> keyFieldsOI, boolean mayReuseKey) throws HiveException {
        Object[] fieldObjs = new Object[fields.size()];
        for (int keyIndex = 0; keyIndex < fields.size(); ++keyIndex) {
            fieldObjs[keyIndex] = fields.get(keyIndex).evaluate(row);
        }
        boolean useOptimized = MapJoinKey.useOptimizedKeyBasedOnPrev(key);
        if (useOptimized || key == null) {
            try {
                byte[] structBytes = MapJoinKey.serializeRow(output, fieldObjs, keyFieldsOI);
                if (structBytes != null) {
                    return MapJoinKeyBytes.fromBytes(key, mayReuseKey, structBytes);
                }
                if (useOptimized) {
                    throw new HiveException("Failed to serialize " + row + " even though optimized keys are used");
                }
            }
            catch (SerDeException ex) {
                throw new HiveException("Serialization error", ex);
            }
        }
        MapJoinKeyObject result = mayReuseKey ? (MapJoinKeyObject)key : new MapJoinKeyObject();
        result.readFromRow(fieldObjs, keyFieldsOI);
        return result;
    }

    private static byte[] serializeRow(ByteStream.Output byteStream, Object[] fieldData, List<ObjectInspector> fieldOis) throws SerDeException {
        if (fieldData.length > 8) {
            return null;
        }
        if (fieldData.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        assert (fieldData.length == fieldOis.size());
        return MapJoinKey.serializeRowCommon(byteStream, fieldData, fieldOis);
    }

    private static byte[] serializeRowCommon(ByteStream.Output byteStream, Object[] fieldData, List<ObjectInspector> fieldOis) throws SerDeException {
        if (byteStream == null) {
            byteStream = new ByteStream.Output();
        } else {
            byteStream.reset();
        }
        LazyBinarySerDe.serializeStruct((ByteStream.Output)byteStream, (Object[])fieldData, fieldOis);
        return Arrays.copyOf(byteStream.getData(), byteStream.getCount());
    }

    private static boolean useOptimizedKeyBasedOnPrev(MapJoinKey key) {
        return key != null && key instanceof MapJoinKeyBytes;
    }

    public abstract void write(MapJoinObjectSerDeContext var1, ObjectOutputStream var2) throws IOException, SerDeException;

    public abstract boolean hasAnyNulls(int var1, boolean[] var2);

    static {
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.VOID);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BYTE);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.SHORT);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.INT);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.LONG);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.DATE);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.CHAR);
    }
}

