/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecReducer;
import org.apache.hadoop.hive.ql.exec.tez.CustomEdgeConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionEdge;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionVertex;
import org.apache.hadoop.hive.ql.exec.tez.HivePreWarmProcessor;
import org.apache.hadoop.hive.ql.exec.tez.MapTezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceTezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.tools.TezMergedLogicalInput;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.client.PreWarmContext;
import org.apache.tez.client.TezSessionConfiguration;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.mapreduce.common.MRInputAMSplitGenerator;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoDisk;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValueInput;
import org.apache.tez.runtime.library.input.ShuffledMergedInputLegacy;
import org.apache.tez.runtime.library.input.ShuffledUnorderedKVInput;
import org.apache.tez.runtime.library.output.OnFileSortedOutput;
import org.apache.tez.runtime.library.output.OnFileUnorderedKVOutput;
import org.apache.tez.runtime.library.output.OnFileUnorderedPartitionedKVOutput;

public class DagUtils {
    private static final Log LOG = LogFactory.getLog((String)DagUtils.class.getName());
    private static final String TEZ_DIR = "_tez_scratch_dir";
    private static DagUtils instance;

    private void addCredentials(MapWork mapWork, DAG dag) {
        Set<String> paths = mapWork.getPathToAliases().keySet();
        if (paths != null && !paths.isEmpty()) {
            Iterator pathIterator = Iterators.transform(paths.iterator(), (Function)new Function<String, URI>(){

                public URI apply(String input) {
                    return new Path(input).toUri();
                }
            });
            HashSet uris = new HashSet();
            Iterators.addAll(uris, (Iterator)pathIterator);
            if (LOG.isDebugEnabled()) {
                for (URI uri : uris) {
                    LOG.debug((Object)("Marking URI as needing credentials: " + uri));
                }
            }
            dag.addURIsForCredentials(uris);
        }
    }

    private void addCredentials(ReduceWork reduceWork, DAG dag) {
    }

    private JobConf initializeVertexConf(JobConf baseConf, MapWork mapWork) {
        JobConf conf = new JobConf((Configuration)baseConf);
        if (mapWork.getNumMapTasks() != null) {
            conf.setInt("mapreduce.job.maps", mapWork.getNumMapTasks().intValue());
        }
        if (mapWork.getMaxSplitSize() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)mapWork.getMaxSplitSize());
        }
        if (mapWork.getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)mapWork.getMinSplitSize());
        }
        if (mapWork.getMinSplitSizePerNode() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZEPERNODE, (long)mapWork.getMinSplitSizePerNode());
        }
        if (mapWork.getMinSplitSizePerRack() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZEPERRACK, (long)mapWork.getMinSplitSizePerRack());
        }
        Utilities.setInputAttributes((Configuration)conf, mapWork);
        String inpFormat = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZINPUTFORMAT);
        if (inpFormat == null || !StringUtils.isNotBlank((String)inpFormat)) {
            inpFormat = ShimLoader.getHadoopShims().getInputFormatClassName();
        }
        if (mapWork.isUseBucketizedHiveInputFormat()) {
            inpFormat = BucketizedHiveInputFormat.class.getName();
        }
        conf.set("mapred.mapper.class", ExecMapper.class.getName());
        conf.set("mapred.input.format.class", inpFormat);
        return conf;
    }

    public GroupInputEdge createEdge(VertexGroup group, JobConf wConf, Vertex w, TezEdgeProperty edgeProp) throws IOException {
        Class mergeInputClass;
        LOG.info((Object)("Creating Edge between " + group.getGroupName() + " and " + w.getVertexName()));
        w.getProcessorDescriptor().setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)wConf));
        TezEdgeProperty.EdgeType edgeType = edgeProp.getEdgeType();
        switch (edgeType) {
            case BROADCAST_EDGE: {
                mergeInputClass = ConcatenatedMergedKeyValueInput.class;
                break;
            }
            case CUSTOM_EDGE: {
                mergeInputClass = ConcatenatedMergedKeyValueInput.class;
                int numBuckets = edgeProp.getNumBuckets();
                VertexManagerPluginDescriptor desc = new VertexManagerPluginDescriptor(CustomPartitionVertex.class.getName());
                byte[] userPayload = ByteBuffer.allocate(4).putInt(numBuckets).array();
                desc.setUserPayload(userPayload);
                w.setVertexManagerPlugin(desc);
                break;
            }
            case CUSTOM_SIMPLE_EDGE: {
                mergeInputClass = ConcatenatedMergedKeyValueInput.class;
                break;
            }
            default: {
                mergeInputClass = TezMergedLogicalInput.class;
            }
        }
        return new GroupInputEdge(group, w, this.createEdgeProperty(edgeProp), new InputDescriptor(mergeInputClass.getName()));
    }

    public void updateConfigurationForEdge(JobConf vConf, Vertex v, JobConf wConf, Vertex w) throws IOException {
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)wConf, (Configuration)vConf);
        v.getProcessorDescriptor().setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)vConf));
        w.getProcessorDescriptor().setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)wConf));
    }

    public Edge createEdge(JobConf vConf, Vertex v, JobConf wConf, Vertex w, TezEdgeProperty edgeProp) throws IOException {
        this.updateConfigurationForEdge(vConf, v, wConf, w);
        if (edgeProp.getEdgeType() == TezEdgeProperty.EdgeType.CUSTOM_EDGE) {
            int numBuckets = edgeProp.getNumBuckets();
            byte[] userPayload = ByteBuffer.allocate(4).putInt(numBuckets).array();
            VertexManagerPluginDescriptor desc = new VertexManagerPluginDescriptor(CustomPartitionVertex.class.getName());
            desc.setUserPayload(userPayload);
            w.setVertexManagerPlugin(desc);
        }
        return new Edge(v, w, this.createEdgeProperty(edgeProp));
    }

    private EdgeProperty createEdgeProperty(TezEdgeProperty edgeProp) throws IOException {
        Class<ShuffledUnorderedKVInput> logicalInputClass;
        Class<OnFileUnorderedKVOutput> logicalOutputClass;
        EdgeProperty.DataMovementType dataMovementType;
        EdgeProperty edgeProperty = null;
        TezEdgeProperty.EdgeType edgeType = edgeProp.getEdgeType();
        switch (edgeType) {
            case BROADCAST_EDGE: {
                dataMovementType = EdgeProperty.DataMovementType.BROADCAST;
                logicalOutputClass = OnFileUnorderedKVOutput.class;
                logicalInputClass = ShuffledUnorderedKVInput.class;
                break;
            }
            case CUSTOM_EDGE: {
                dataMovementType = EdgeProperty.DataMovementType.CUSTOM;
                logicalOutputClass = OnFileUnorderedPartitionedKVOutput.class;
                logicalInputClass = ShuffledUnorderedKVInput.class;
                EdgeManagerDescriptor edgeDesc = new EdgeManagerDescriptor(CustomPartitionEdge.class.getName());
                CustomEdgeConfiguration edgeConf = new CustomEdgeConfiguration(edgeProp.getNumBuckets(), null);
                DataOutputBuffer dob = new DataOutputBuffer();
                edgeConf.write((DataOutput)dob);
                byte[] userPayload = dob.getData();
                edgeDesc.setUserPayload(userPayload);
                edgeProperty = new EdgeProperty(edgeDesc, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(logicalOutputClass.getName()), new InputDescriptor(logicalInputClass.getName()));
                break;
            }
            case CUSTOM_SIMPLE_EDGE: {
                dataMovementType = EdgeProperty.DataMovementType.SCATTER_GATHER;
                logicalOutputClass = OnFileUnorderedPartitionedKVOutput.class;
                logicalInputClass = ShuffledUnorderedKVInput.class;
                break;
            }
            default: {
                dataMovementType = EdgeProperty.DataMovementType.SCATTER_GATHER;
                logicalOutputClass = OnFileSortedOutput.class;
                logicalInputClass = ShuffledMergedInputLegacy.class;
            }
        }
        if (edgeProperty == null) {
            edgeProperty = new EdgeProperty(dataMovementType, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(logicalOutputClass.getName()), new InputDescriptor(logicalInputClass.getName()));
        }
        return edgeProperty;
    }

    private Resource getContainerResource(Configuration conf) {
        int memory = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) > 0 ? HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) : conf.getInt("mapreduce.map.memory.mb", 1024);
        int cpus = conf.getInt("mapreduce.map.cpu.vcores", 1);
        return Resource.newInstance((int)memory, (int)cpus);
    }

    private String getContainerJavaOpts(Configuration conf) {
        String javaOpts = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZJAVAOPTS);
        if (javaOpts != null && !javaOpts.isEmpty()) {
            String logLevel = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZLOGLEVEL);
            ArrayList logProps = Lists.newArrayList();
            MRHelpers.addLog4jSystemProperties((String)logLevel, (List)logProps);
            StringBuilder sb = new StringBuilder();
            for (String str : logProps) {
                sb.append(str).append(" ");
            }
            return javaOpts + " " + sb.toString();
        }
        return MRHelpers.getMapJavaOpts((Configuration)conf);
    }

    private Vertex createVertex(JobConf conf, MapWork mapWork, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fs, Path mrScratchDir, Context ctx, TezWork tezWork) throws Exception {
        Path tezDir = this.getTezDir(mrScratchDir);
        Utilities.setMapWork((Configuration)conf, mapWork, mrScratchDir, false);
        Utilities.createTmpDirs((Configuration)conf, mapWork);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)conf, null);
        Vertex map = null;
        boolean useTezGroupedSplits = true;
        int numTasks = -1;
        Class<MRInputAMSplitGenerator> amSplitGeneratorClass = null;
        InputSplitInfoDisk inputSplitInfo = null;
        Class<HiveInputFormat> inputFormatClass = conf.getClass("mapred.input.format.class", InputFormat.class);
        boolean vertexHasCustomInput = false;
        if (tezWork != null) {
            for (BaseWork baseWork : tezWork.getParents(mapWork)) {
                if (tezWork.getEdgeType(baseWork, mapWork) != TezEdgeProperty.EdgeType.CUSTOM_EDGE) continue;
                vertexHasCustomInput = true;
            }
        }
        Class<? extends InputFormat> previousInputFormatClass = null;
        Class<?> previousDeserializerClass = null;
        for (String path : mapWork.getPathToPartitionInfo().keySet()) {
            PartitionDesc pd = mapWork.getPathToPartitionInfo().get(path);
            Class<?> currentDeserializerClass = pd.getDeserializer((Configuration)conf).getClass();
            Class<? extends InputFormat> currentInputFormatClass = pd.getInputFileFormatClass();
            if (previousInputFormatClass == null) {
                previousInputFormatClass = currentInputFormatClass;
            }
            if (previousDeserializerClass == null) {
                previousDeserializerClass = currentDeserializerClass;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Current input format class = " + currentInputFormatClass + ", previous input format class = " + previousInputFormatClass + ", verifying " + " current deserializer class = " + currentDeserializerClass + " previous deserializer class = " + previousDeserializerClass));
            }
            if (currentInputFormatClass == previousInputFormatClass && currentDeserializerClass == previousDeserializerClass) continue;
            useTezGroupedSplits = false;
            break;
        }
        if (vertexHasCustomInput) {
            if (!useTezGroupedSplits) {
                conf.setBoolean("hive.enable.custom.grouped.splits", false);
            } else {
                conf.setBoolean("hive.enable.custom.grouped.splits", true);
            }
            inputFormatClass = HiveInputFormat.class;
            conf.setClass("mapred.input.format.class", HiveInputFormat.class, InputFormat.class);
            conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", false);
        } else if (useTezGroupedSplits) {
            if (inputFormatClass == HiveInputFormat.class) {
                conf.setClass("mapred.input.format.class", TezGroupedSplitsInputFormat.class, InputFormat.class);
            } else {
                conf.setClass("mapred.input.format.class", CombineHiveInputFormat.class, InputFormat.class);
                useTezGroupedSplits = false;
            }
        } else {
            conf.setClass("mapred.input.format.class", CombineHiveInputFormat.class, InputFormat.class);
        }
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION)) {
            amSplitGeneratorClass = MRInputAMSplitGenerator.class;
        } else {
            inputSplitInfo = MRHelpers.generateInputSplits((Configuration)conf, (Path)new Path(tezDir, "split_" + mapWork.getName().replaceAll(" ", "_")));
            numTasks = inputSplitInfo.getNumTasks();
        }
        byte[] serializedConf = MRHelpers.createUserPayloadFromConf((Configuration)conf);
        map = new Vertex(mapWork.getName(), new ProcessorDescriptor(MapTezProcessor.class.getName()).setUserPayload(serializedConf), numTasks, this.getContainerResource((Configuration)conf));
        HashMap environment = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)conf, environment, (boolean)true);
        map.setTaskEnvironment(environment);
        map.setJavaOpts(this.getContainerJavaOpts((Configuration)conf));
        assert (mapWork.getAliasToWork().keySet().size() == 1);
        String alias = mapWork.getAliasToWork().keySet().iterator().next();
        byte[] mrInput = null;
        mrInput = useTezGroupedSplits ? MRHelpers.createMRInputPayloadWithGrouping((byte[])serializedConf, (String)HiveInputFormat.class.getName()) : MRHelpers.createMRInputPayload((byte[])serializedConf, null);
        map.addInput(alias, new InputDescriptor(MRInputLegacy.class.getName()).setUserPayload(mrInput), amSplitGeneratorClass);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        localResources.put(this.getBaseName(appJarLr), appJarLr);
        for (LocalResource lr : additionalLr) {
            localResources.put(this.getBaseName(lr), lr);
        }
        if (inputSplitInfo != null) {
            map.setTaskLocationsHint(inputSplitInfo.getTaskLocationHints());
            MRHelpers.updateLocalResourcesForInputSplits((FileSystem)FileSystem.get((Configuration)conf), (InputSplitInfo)inputSplitInfo, localResources);
        }
        map.setTaskLocalResources(localResources);
        return map;
    }

    private JobConf initializeVertexConf(JobConf baseConf, ReduceWork reduceWork) {
        JobConf conf = new JobConf((Configuration)baseConf);
        conf.set("mapred.reducer.class", ExecReducer.class.getName());
        boolean useSpeculativeExecReducers = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESPECULATIVEEXECREDUCERS);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HADOOPSPECULATIVEEXECREDUCERS, (boolean)useSpeculativeExecReducers);
        return conf;
    }

    private Vertex createVertex(JobConf conf, ReduceWork reduceWork, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fs, Path mrScratchDir, Context ctx) throws Exception {
        Utilities.setReduceWork((Configuration)conf, reduceWork, mrScratchDir, false);
        Utilities.createTmpDirs((Configuration)conf, reduceWork);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)conf, null);
        Vertex reducer = new Vertex(reduceWork.getName(), new ProcessorDescriptor(ReduceTezProcessor.class.getName()).setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)conf)), reduceWork.getNumReduceTasks().intValue(), this.getContainerResource((Configuration)conf));
        HashMap environment = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)conf, environment, (boolean)false);
        reducer.setTaskEnvironment(environment);
        reducer.setJavaOpts(this.getContainerJavaOpts((Configuration)conf));
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        localResources.put(this.getBaseName(appJarLr), appJarLr);
        for (LocalResource lr : additionalLr) {
            localResources.put(this.getBaseName(lr), lr);
        }
        reducer.setTaskLocalResources(localResources);
        return reducer;
    }

    private LocalResource createLocalResource(FileSystem remoteFs, Path file, LocalResourceType type, LocalResourceVisibility visibility) {
        FileStatus fstat = null;
        try {
            fstat = remoteFs.getFileStatus(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URL resourceURL = ConverterUtils.getYarnUrlFromPath((Path)file);
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        LOG.info((Object)("Resource modification time: " + resourceModificationTime));
        LocalResource lr = (LocalResource)Records.newRecord(LocalResource.class);
        lr.setResource(resourceURL);
        lr.setType(type);
        lr.setSize(resourceSize);
        lr.setVisibility(visibility);
        lr.setTimestamp(resourceModificationTime);
        return lr;
    }

    public PreWarmContext createPreWarmContext(TezSessionConfiguration sessionConfig, int numContainers, Map<String, LocalResource> localResources) throws IOException, TezException {
        TezConfiguration conf = sessionConfig.getTezConfiguration();
        ProcessorDescriptor prewarmProcDescriptor = new ProcessorDescriptor(HivePreWarmProcessor.class.getName());
        prewarmProcDescriptor.setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)conf));
        PreWarmContext context = new PreWarmContext(prewarmProcDescriptor, this.getContainerResource((Configuration)conf), numContainers, new VertexLocationHint(null));
        HashMap<String, LocalResource> combinedResources = new HashMap<String, LocalResource>();
        combinedResources.putAll(sessionConfig.getSessionResources());
        if (localResources != null) {
            combinedResources.putAll(localResources);
        }
        context.setLocalResources(combinedResources);
        HashMap environment = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)conf, environment, (boolean)true);
        context.setEnvironment(environment);
        context.setJavaOpts(this.getContainerJavaOpts((Configuration)conf));
        return context;
    }

    public Path getDefaultDestDir(Configuration conf) throws LoginException, IOException {
        UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf(conf);
        String userName = ShimLoader.getHadoopShims().getShortUserName(ugi);
        String userPathStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_USER_INSTALL_DIR);
        Path userPath = new Path(userPathStr);
        FileSystem fs = userPath.getFileSystem(conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException(ErrorMsg.INVALID_HDFS_URI.format(userPathStr));
        }
        String jarPathStr = userPathStr + "/" + userName;
        String hdfsDirPathStr = jarPathStr;
        Path hdfsDirPath = new Path(hdfsDirPathStr);
        FileStatus fstatus = fs.getFileStatus(hdfsDirPath);
        if (!fstatus.isDir()) {
            throw new IOException(ErrorMsg.INVALID_DIR.format(hdfsDirPath.toString()));
        }
        Path retPath = new Path(hdfsDirPath.toString() + "/.hiveJars");
        fs.mkdirs(retPath);
        return retPath;
    }

    public List<LocalResource> localizeTempFilesFromConf(String hdfsDirPathStr, Configuration conf) throws IOException, LoginException {
        ArrayList<LocalResource> tmpResources = new ArrayList<LocalResource>();
        this.addTempFiles(conf, tmpResources, hdfsDirPathStr, DagUtils.getTempFilesFromConf(conf));
        return tmpResources;
    }

    public static String[] getTempFilesFromConf(Configuration conf) {
        String addedArchives;
        String addedJars;
        String addedFiles = Utilities.getResourceFiles(conf, SessionState.ResourceType.FILE);
        if (StringUtils.isNotBlank((String)addedFiles)) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDFILES, (String)addedFiles);
        }
        if (StringUtils.isNotBlank((String)(addedJars = Utilities.getResourceFiles(conf, SessionState.ResourceType.JAR)))) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDJARS, (String)addedJars);
        }
        if (StringUtils.isNotBlank((String)(addedArchives = Utilities.getResourceFiles(conf, SessionState.ResourceType.ARCHIVE)))) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDARCHIVES, (String)addedArchives);
        }
        String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
        String allFiles = auxJars + "," + addedJars + "," + addedFiles + "," + addedArchives;
        return allFiles.split(",");
    }

    public List<LocalResource> localizeTempFiles(String hdfsDirPathStr, Configuration conf, String[] inputOutputJars) throws IOException, LoginException {
        if (inputOutputJars == null) {
            return null;
        }
        ArrayList<LocalResource> tmpResources = new ArrayList<LocalResource>();
        this.addTempFiles(conf, tmpResources, hdfsDirPathStr, inputOutputJars);
        return tmpResources;
    }

    private void addTempFiles(Configuration conf, List<LocalResource> tmpResources, String hdfsDirPathStr, String[] files) throws IOException {
        for (String file : files) {
            if (!StringUtils.isNotBlank((String)file)) continue;
            Path hdfsFilePath = new Path(hdfsDirPathStr, this.getResourceBaseName(new Path(file)));
            LocalResource localResource = this.localizeResource(new Path(file), hdfsFilePath, conf);
            tmpResources.add(localResource);
        }
    }

    public FileStatus getHiveJarDirectory(Configuration conf) throws IOException, LoginException {
        FileStatus fstatus = null;
        String hdfsDirPathStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_JAR_DIRECTORY, null);
        if (hdfsDirPathStr != null) {
            LOG.info((Object)("Hive jar directory is " + hdfsDirPathStr));
            fstatus = DagUtils.validateTargetDir(new Path(hdfsDirPathStr), conf);
        }
        if (fstatus == null) {
            Path destDir = this.getDefaultDestDir(conf);
            LOG.info((Object)("Jar dir is null/directory doesn't exist. Choosing HIVE_INSTALL_DIR - " + destDir));
            fstatus = DagUtils.validateTargetDir(destDir, conf);
        }
        if (fstatus == null) {
            throw new IOException(ErrorMsg.NO_VALID_LOCATIONS.getMsg());
        }
        return fstatus;
    }

    public static FileStatus validateTargetDir(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException(ErrorMsg.INVALID_HDFS_URI.format(path.toString()));
        }
        FileStatus fstatus = null;
        try {
            fstatus = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fe) {
            // empty catch block
        }
        return fstatus != null && fstatus.isDir() ? fstatus : null;
    }

    public String getExecJarPathLocal() throws URISyntaxException {
        return DagUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
    }

    public String getBaseName(LocalResource lr) {
        return FilenameUtils.getName((String)lr.getResource().getFile());
    }

    public String getResourceBaseName(Path path) {
        return path.getName();
    }

    private boolean checkPreExisting(Path src, Path dest, Configuration conf) throws IOException {
        FileSystem destFS = dest.getFileSystem(conf);
        FileSystem sourceFS = src.getFileSystem(conf);
        if (destFS.exists(dest)) {
            return sourceFS.getFileStatus(src).getLen() == destFS.getFileStatus(dest).getLen();
        }
        return false;
    }

    public LocalResource localizeResource(Path src, Path dest, Configuration conf) throws IOException {
        FileSystem destFS;
        block8: {
            destFS = dest.getFileSystem(conf);
            if (!(destFS instanceof DistributedFileSystem)) {
                throw new IOException(ErrorMsg.INVALID_HDFS_URI.format(dest.toString()));
            }
            if (src != null) {
                LOG.info((Object)("Localizing resource because it does not exist: " + src + " to dest: " + dest));
                try {
                    destFS.copyFromLocalFile(false, false, src, dest);
                }
                catch (IOException e) {
                    LOG.info((Object)"Looks like another thread is writing the same file will wait.");
                    int waitAttempts = conf.getInt(HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_NUM_WAIT_ATTEMPTS.varname, HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_NUM_WAIT_ATTEMPTS.defaultIntVal);
                    long sleepInterval = conf.getLong(HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL.varname, HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL.defaultLongVal);
                    LOG.info((Object)("Number of wait attempts: " + waitAttempts + ". Wait interval: " + sleepInterval));
                    boolean found = false;
                    for (int i = 0; i < waitAttempts; ++i) {
                        if (!this.checkPreExisting(src, dest, conf)) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(sleepInterval);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                throw new IOException(interruptedException);
                            }
                        }
                        found = true;
                        break;
                    }
                    if (found) break block8;
                    LOG.error((Object)"Could not find the jar that was being uploaded");
                    throw new IOException("Previous writer likely failed to write " + dest + ". Failing because I am unlikely to write too.");
                }
            }
        }
        return this.createLocalResource(destFS, dest, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION);
    }

    public JobConf createConfiguration(HiveConf hiveConf) throws IOException {
        hiveConf.setBoolean("mapred.mapper.new-api", false);
        JobConf conf = (JobConf)MRHelpers.getBaseMRConfiguration((Configuration)hiveConf);
        conf.set("mapred.output.committer.class", HadoopShimsSecure.NullOutputCommitter.class.getName());
        conf.setBoolean("mapred.committer.job.setup.cleanup.needed", false);
        conf.setBoolean("mapred.committer.job.task.cleanup.needed", false);
        conf.setClass("mapred.output.format.class", HiveOutputFormatImpl.class, OutputFormat.class);
        conf.set("mapreduce.job.output.key.class", HiveKey.class.getName());
        conf.set("mapreduce.job.output.value.class", BytesWritable.class.getName());
        conf.set("mapred.partitioner.class", HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPARTITIONER));
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        return conf;
    }

    public JobConf initializeVertexConf(JobConf conf, BaseWork work) {
        if (work instanceof MapWork) {
            return this.initializeVertexConf(conf, (MapWork)work);
        }
        if (work instanceof ReduceWork) {
            return this.initializeVertexConf(conf, (ReduceWork)work);
        }
        assert (false);
        return null;
    }

    public Vertex createVertex(JobConf conf, BaseWork work, Path scratchDir, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fileSystem, Context ctx, boolean hasChildren, TezWork tezWork) throws Exception {
        StatsPublisher statsPublisher;
        StatsFactory factory;
        Vertex v = null;
        if (work instanceof MapWork) {
            v = this.createVertex(conf, (MapWork)work, appJarLr, additionalLr, fileSystem, scratchDir, ctx, tezWork);
        } else if (work instanceof ReduceWork) {
            v = this.createVertex(conf, (ReduceWork)work, appJarLr, additionalLr, fileSystem, scratchDir, ctx);
        } else {
            throw new HiveException(ErrorMsg.GENERIC_ERROR.getErrorCodedMsg());
        }
        if (work.isGatheringStats() && (factory = StatsFactory.newFactory((Configuration)conf)) != null && !(statsPublisher = factory.getStatsPublisher()).init((Configuration)conf) && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
        }
        if (!hasChildren) {
            v.addOutput("out_" + work.getName(), new OutputDescriptor(MROutput.class.getName()).setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)conf)));
        }
        return v;
    }

    public void addCredentials(BaseWork work, DAG dag) {
        if (work instanceof MapWork) {
            this.addCredentials((MapWork)work, dag);
        } else if (work instanceof ReduceWork) {
            this.addCredentials((ReduceWork)work, dag);
        }
    }

    public Path createTezDir(Path scratchDir, Configuration conf) throws IOException {
        String userName = System.getProperty("user.name");
        try {
            UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf(conf);
            userName = ShimLoader.getHadoopShims().getShortUserName(ugi);
        }
        catch (LoginException e) {
            throw new IOException(e);
        }
        scratchDir = new Path(scratchDir, userName);
        Path tezDir = this.getTezDir(scratchDir);
        FileSystem fs = tezDir.getFileSystem(conf);
        LOG.debug((Object)("TezDir path set " + tezDir + " for user: " + userName));
        fs.mkdirs(tezDir);
        return tezDir;
    }

    public Path getTezDir(Path scratchDir) {
        return new Path(scratchDir, TEZ_DIR);
    }

    public static DagUtils getInstance() {
        if (instance == null) {
            instance = new DagUtils();
        }
        return instance;
    }

    private DagUtils() {
    }
}

