/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.LazyFlatRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.tez.TezCacheAccess;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Log LOG = LogFactory.getLog((String)HashTableLoader.class.getName());
    private ExecMapperContext context;
    private Configuration hconf;
    private MapJoinDesc desc;
    private MapJoinKey lastKey = null;

    @Override
    public void init(ExecMapperContext context, Configuration hconf, MapJoinOperator joinOp) {
        this.context = context;
        this.hconf = hconf;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        TezContext tezContext = (TezContext)MapredContext.get();
        Map<Integer, String> parentToInput = this.desc.getParentToInput();
        int hashTableThreshold = HiveConf.getIntVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD);
        float hashTableLoadFactor = HiveConf.getFloatVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR);
        boolean useLazyRows = HiveConf.getBoolVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPJOINLAZYHASHTABLE);
        TezCacheAccess tezCacheAccess = TezCacheAccess.createInstance(this.hconf);
        if (!HiveConf.getBoolVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDKEYS)) {
            this.lastKey = new MapJoinKeyObject();
        }
        ByteStream.Output output = new ByteStream.Output();
        for (int pos = 0; pos < mapJoinTables.length; ++pos) {
            if (pos == this.desc.getPosBigTable()) continue;
            String inputName = parentToInput.get(pos);
            LogicalInput input = tezContext.getInput(inputName);
            try {
                KeyValueReader kvReader = (KeyValueReader)input.getReader();
                HashMapWrapper tableContainer = new HashMapWrapper(hashTableThreshold, hashTableLoadFactor);
                while (kvReader.next()) {
                    this.lastKey = MapJoinKey.read(output, this.lastKey, mapJoinTableSerdes[pos].getKeyContext(), (Writable)kvReader.getCurrentKey(), false);
                    LazyFlatRowContainer values = (LazyFlatRowContainer)tableContainer.get(this.lastKey);
                    if (values == null) {
                        values = new LazyFlatRowContainer();
                        tableContainer.put(this.lastKey, values);
                    }
                    values.add(mapJoinTableSerdes[pos].getValueContext(), (BytesWritable)kvReader.getCurrentValue(), useLazyRows);
                }
                mapJoinTables[pos] = tableContainer;
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            LOG.info((Object)("Is this a bucket map join: " + this.desc.isBucketMapJoin()));
            if (this.desc.isBucketMapJoin()) continue;
            tezCacheAccess.registerCachedInput(inputName);
            LOG.info((Object)("Setting Input: " + inputName + " as cached"));
        }
        if (this.lastKey == null) {
            this.lastKey = new MapJoinKeyObject();
        }
    }
}

