/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;

public abstract class RecordProcessor {
    protected JobConf jconf;
    protected Map<String, LogicalInput> inputs;
    protected Map<String, LogicalOutput> outputs;
    protected Map<String, OutputCollector> outMap;
    protected TezProcessorContext processorContext;
    public static final Log l4j = LogFactory.getLog(RecordProcessor.class);
    public static MemoryMXBean memoryMXBean;
    protected boolean isLogInfoEnabled = false;
    protected MRTaskReporter reporter;
    private long numRows = 0L;
    private long nextUpdateCntr = 1L;
    protected PerfLogger perfLogger = PerfLogger.getPerfLogger();
    protected String CLASS_NAME = RecordProcessor.class.getName();

    void init(JobConf jconf, TezProcessorContext processorContext, MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.jconf = jconf;
        this.reporter = mrReporter;
        this.inputs = inputs;
        this.outputs = outputs;
        this.processorContext = processorContext;
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        l4j.info((Object)("maximum memory = " + memoryMXBean.getHeapMemoryUsage().getMax()));
        this.isLogInfoEnabled = l4j.isInfoEnabled();
        try {
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("conf classpath = " + Arrays.asList(((URLClassLoader)jconf.getClassLoader()).getURLs())));
                l4j.debug((Object)("thread classpath = " + Arrays.asList(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs())));
            }
        }
        catch (Exception e) {
            l4j.info((Object)("cannot get classpath: " + e.getMessage()));
        }
    }

    abstract void run() throws Exception;

    abstract void close();

    protected void logCloseInfo() {
        long used_memory = memoryMXBean.getHeapMemoryUsage().getUsed();
        l4j.info((Object)("ExecMapper: processed " + this.numRows + " rows: used memory = " + used_memory));
    }

    protected void logProgress() {
        ++this.numRows;
        if (this.numRows == this.nextUpdateCntr) {
            long used_memory = memoryMXBean.getHeapMemoryUsage().getUsed();
            l4j.info((Object)("ExecMapper: processing " + this.numRows + " rows: used memory = " + used_memory));
            this.nextUpdateCntr = this.getNextUpdateRecordCounter(this.numRows);
        }
    }

    private long getNextUpdateRecordCounter(long cntr) {
        if (cntr >= 1000000L) {
            return cntr + 1000000L;
        }
        return 10L * cntr;
    }

    protected void createOutputMap() {
        Preconditions.checkState((this.outMap == null ? 1 : 0) != 0, (Object)"Outputs should only be setup once");
        this.outMap = Maps.newHashMap();
        for (Map.Entry<String, LogicalOutput> entry : this.outputs.entrySet()) {
            TezProcessor.TezKVOutputCollector collector = new TezProcessor.TezKVOutputCollector(entry.getValue());
            this.outMap.put(entry.getKey(), collector);
        }
    }
}

