/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class DecimalColumnVector
extends ColumnVector {
    public Decimal128[] vector;
    public short scale;
    public short precision;
    private final HiveDecimalWritable writableObj = new HiveDecimalWritable();

    public DecimalColumnVector(int precision, int scale) {
        this(1024, precision, scale);
    }

    public DecimalColumnVector(int size, int precision, int scale) {
        super(size);
        this.precision = (short)precision;
        this.scale = (short)scale;
        int len = size;
        this.vector = new Decimal128[len];
        for (int i = 0; i < len; ++i) {
            this.vector[i] = new Decimal128(0L, this.scale);
        }
    }

    @Override
    public Writable getWritableObject(int index) {
        if (this.isRepeating) {
            index = 0;
        }
        if (!this.noNulls && this.isNull[index]) {
            return NullWritable.get();
        }
        Decimal128 dec = this.vector[index];
        this.writableObj.set(HiveDecimal.create((BigDecimal)dec.toBigDecimal()));
        return this.writableObj;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        this.vector[outElementNum].update(((DecimalColumnVector)inputVector).vector[inputElementNum]);
        this.vector[outElementNum].changeScaleDestructive(this.scale);
    }

    public void checkPrecisionOverflow(int i) {
        try {
            this.vector[i].checkPrecisionOverflow((int)this.precision);
        }
        catch (ArithmeticException e) {
            this.noNulls = false;
            this.isNull[i] = true;
        }
    }
}

