/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class VectorColumnAssignFactory {
    public static VectorColumnAssign[] buildAssigners(VectorizedRowBatch outputBatch) throws HiveException {
        VectorColumnAssign[] vca = new VectorColumnAssign[outputBatch.cols.length];
        for (int i = 0; i < vca.length; ++i) {
            ColumnVector cv = outputBatch.cols[i];
            if (cv == null) continue;
            if (cv instanceof LongColumnVector) {
                vca[i] = new VectorLongColumnAssign(){

                    @Override
                    protected void copyValue(LongColumnVector in, int srcIndex, int destIndex) {
                        this.assignLong(in.vector[srcIndex], destIndex);
                    }
                }.init(outputBatch, (LongColumnVector)cv);
                continue;
            }
            if (cv instanceof DoubleColumnVector) {
                vca[i] = new VectorDoubleColumnAssign(){

                    @Override
                    protected void copyValue(DoubleColumnVector in, int srcIndex, int destIndex) {
                        this.assignDouble(in.vector[srcIndex], destIndex);
                    }
                }.init(outputBatch, (DoubleColumnVector)cv);
                continue;
            }
            if (cv instanceof BytesColumnVector) {
                vca[i] = new VectorBytesColumnAssign(){

                    @Override
                    protected void copyValue(BytesColumnVector src, int srcIndex, int destIndex) {
                        this.assignBytes(src.vector[srcIndex], src.start[srcIndex], src.length[srcIndex], destIndex);
                    }
                }.init(outputBatch, (BytesColumnVector)cv);
                continue;
            }
            if (cv instanceof DecimalColumnVector) {
                vca[i] = new VectorDecimalColumnAssign(){

                    @Override
                    protected void copyValue(DecimalColumnVector src, int srcIndex, int destIndex) {
                        this.assignDecimal(src.vector[srcIndex], destIndex);
                    }
                };
                continue;
            }
            throw new HiveException("Unimplemented vector column type: " + cv.getClass().getName());
        }
        return vca;
    }

    public static VectorColumnAssign buildObjectAssign(VectorizedRowBatch outputBatch, int outColIndex, ObjectInspector objInspector) throws HiveException {
        VectorColumnAssign outVCA;
        block20: {
            ColumnVector destCol;
            block23: {
                PrimitiveObjectInspector poi;
                block22: {
                    block21: {
                        block19: {
                            poi = (PrimitiveObjectInspector)objInspector;
                            outVCA = null;
                            destCol = outputBatch.cols[outColIndex];
                            if (!(destCol instanceof LongColumnVector)) break block19;
                            switch (poi.getPrimitiveCategory()) {
                                case BOOLEAN: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                BooleanWritable bw = (BooleanWritable)val;
                                                this.assignLong(bw.get() ? 1L : 0L, destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                case BYTE: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                ByteWritable bw = (ByteWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                case SHORT: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                ShortWritable bw = (ShortWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                case INT: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                IntWritable bw = (IntWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                case LONG: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                LongWritable bw = (LongWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                case TIMESTAMP: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                TimestampWritable bw = (TimestampWritable)val;
                                                Timestamp t = bw.getTimestamp();
                                                this.assignLong(TimestampUtils.getTimeNanoSec(t), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                case DATE: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                DateWritable bw = (DateWritable)val;
                                                this.assignLong(bw.getDays(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block20;
                                }
                                default: {
                                    throw new HiveException("Incompatible Long vector column and primitive category " + poi.getPrimitiveCategory());
                                }
                            }
                        }
                        if (!(destCol instanceof DoubleColumnVector)) break block21;
                        switch (poi.getPrimitiveCategory()) {
                            case DOUBLE: {
                                outVCA = new VectorDoubleColumnAssign(){

                                    @Override
                                    public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                        if (val == null) {
                                            this.assignNull(destIndex);
                                        } else {
                                            DoubleWritable bw = (DoubleWritable)val;
                                            this.assignDouble(bw.get(), destIndex);
                                        }
                                    }
                                }.init(outputBatch, (DoubleColumnVector)destCol);
                                break block20;
                            }
                            case FLOAT: {
                                outVCA = new VectorDoubleColumnAssign(){

                                    @Override
                                    public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                        if (val == null) {
                                            this.assignNull(destIndex);
                                        } else {
                                            FloatWritable bw = (FloatWritable)val;
                                            this.assignDouble(bw.get(), destIndex);
                                        }
                                    }
                                }.init(outputBatch, (DoubleColumnVector)destCol);
                                break block20;
                            }
                            default: {
                                throw new HiveException("Incompatible Double vector column and primitive category " + poi.getPrimitiveCategory());
                            }
                        }
                    }
                    if (!(destCol instanceof BytesColumnVector)) break block22;
                    switch (poi.getPrimitiveCategory()) {
                        case STRING: {
                            outVCA = new VectorBytesColumnAssign(){

                                @Override
                                public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                    if (val == null) {
                                        this.assignNull(destIndex);
                                    } else {
                                        Text bw = (Text)val;
                                        byte[] bytes = bw.getBytes();
                                        this.assignBytes(bytes, 0, bytes.length, destIndex);
                                    }
                                }
                            }.init(outputBatch, (BytesColumnVector)destCol);
                            break block20;
                        }
                        default: {
                            throw new HiveException("Incompatible Bytes vector column and primitive category " + poi.getPrimitiveCategory());
                        }
                    }
                }
                if (!(destCol instanceof DecimalColumnVector)) break block23;
                switch (poi.getPrimitiveCategory()) {
                    case DECIMAL: {
                        outVCA = new VectorDecimalColumnAssign(){

                            @Override
                            public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                if (val == null) {
                                    this.assignNull(destIndex);
                                } else {
                                    HiveDecimalWritable hdw = (HiveDecimalWritable)val;
                                    this.assignDecimal(hdw, destIndex);
                                }
                            }
                        }.init(outputBatch, (DecimalColumnVector)destCol);
                        break block20;
                    }
                    default: {
                        throw new HiveException("Incompatible Decimal vector column and primitive category " + poi.getPrimitiveCategory());
                    }
                }
            }
            throw new HiveException("Unknown vector column type " + destCol.getClass().getName());
        }
        return outVCA;
    }

    public static VectorColumnAssign[] buildAssigners(VectorizedRowBatch outputBatch, ObjectInspector outputOI, Map<String, Integer> columnMap, List<String> outputColumnNames) throws HiveException {
        StructObjectInspector soi = (StructObjectInspector)outputOI;
        VectorColumnAssign[] vcas = new VectorColumnAssign[outputColumnNames.size()];
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            String columnName = outputColumnNames.get(i);
            Integer columnIndex = columnMap.get(columnName);
            StructField columnRef = soi.getStructFieldRef(columnName);
            ObjectInspector valueOI = columnRef.getFieldObjectInspector();
            vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, columnIndex, valueOI);
        }
        return vcas;
    }

    private static abstract class VectorDecimalColumnAssign
    extends VectorColumnAssignVectorBase<DecimalColumnVector> {
        private VectorDecimalColumnAssign() {
        }

        protected void assignDecimal(HiveDecimal value, int index) {
            ((DecimalColumnVector)this.outCol).vector[index].update(value.unscaledValue(), (short)((byte)value.scale()));
        }

        protected void assignDecimal(Decimal128 value, int index) {
            ((DecimalColumnVector)this.outCol).vector[index].update(value);
        }

        protected void assignDecimal(HiveDecimalWritable hdw, int index) {
            byte[] internalStorage = hdw.getInternalStorage();
            int scale = hdw.getScale();
            ((DecimalColumnVector)this.outCol).vector[index].fastUpdateFromInternalStorage(internalStorage, (short)scale);
        }
    }

    private static abstract class VectorBytesColumnAssign
    extends VectorColumnAssignVectorBase<BytesColumnVector> {
        byte[] pad = new byte[16384];
        int padUsed = 0;

        private VectorBytesColumnAssign() {
        }

        protected void assignBytes(byte[] buffer, int start, int length, int destIndex) {
            if (this.padUsed + length <= this.pad.length) {
                System.arraycopy(buffer, start, this.pad, this.padUsed, length);
                ((BytesColumnVector)this.outCol).vector[destIndex] = this.pad;
                ((BytesColumnVector)this.outCol).start[destIndex] = this.padUsed;
                ((BytesColumnVector)this.outCol).length[destIndex] = length;
                this.padUsed += length;
            } else {
                ((BytesColumnVector)this.outCol).vector[destIndex] = Arrays.copyOfRange(buffer, start, length);
                ((BytesColumnVector)this.outCol).start[destIndex] = 0;
                ((BytesColumnVector)this.outCol).length[destIndex] = length;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.padUsed = 0;
        }
    }

    private static abstract class VectorDoubleColumnAssign
    extends VectorColumnAssignVectorBase<DoubleColumnVector> {
        private VectorDoubleColumnAssign() {
        }

        protected void assignDouble(double value, int destIndex) {
            ((DoubleColumnVector)this.outCol).vector[destIndex] = value;
        }
    }

    private static abstract class VectorLongColumnAssign
    extends VectorColumnAssignVectorBase<LongColumnVector> {
        private VectorLongColumnAssign() {
        }

        protected void assignLong(long value, int destIndex) {
            ((LongColumnVector)this.outCol).vector[destIndex] = value;
        }
    }

    private static abstract class VectorColumnAssignVectorBase<T extends ColumnVector>
    implements VectorColumnAssign {
        protected VectorizedRowBatch outBatch;
        protected T outCol;

        private VectorColumnAssignVectorBase() {
        }

        protected void copyValue(T in, int srcIndex, int destIndex) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        @Override
        public void assignVectorValue(VectorizedRowBatch inBatch, int batchIndex, int valueColumnIndex, int destIndex) throws HiveException {
            ColumnVector in = inBatch.cols[valueColumnIndex];
            if (in.isRepeating) {
                if (in.noNulls) {
                    this.copyValue(in, 0, destIndex);
                } else {
                    this.assignNull(destIndex);
                }
            } else {
                int srcIndex;
                int n = srcIndex = inBatch.selectedInUse ? inBatch.selected[batchIndex] : batchIndex;
                if (in.noNulls || !in.isNull[srcIndex]) {
                    this.copyValue(in, srcIndex, destIndex);
                } else {
                    this.assignNull(destIndex);
                }
            }
        }

        public VectorColumnAssign init(VectorizedRowBatch out, T cv) {
            this.outBatch = out;
            this.outCol = cv;
            return this;
        }

        protected void assignNull(int index) {
            VectorizedBatchUtil.setNullColIsNullValue(this.outCol, index);
        }

        @Override
        public void reset() {
        }

        @Override
        public void assignObjectValue(Object value, int destIndex) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }
    }
}

