/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSerde;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;

public class VectorFileSinkOperator
extends FileSinkOperator {
    private static final long serialVersionUID = 1L;
    protected transient Object[] singleRow;
    protected transient VectorExpressionWriter[] valueWriters;

    public VectorFileSinkOperator(VectorizationContext context, OperatorDesc conf) {
        this.conf = (FileSinkDesc)conf;
    }

    public VectorFileSinkOperator() {
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.valueWriters = VectorExpressionWriterFactory.getExpressionWriters((StructObjectInspector)this.inputObjInspectors[0]);
        this.singleRow = new Object[this.valueWriters.length];
    }

    @Override
    public void processOp(Object data, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)data;
        Writable[] records = null;
        boolean vectorizedSerde = false;
        try {
            if (this.serializer instanceof VectorizedSerde) {
                this.recordValue = ((VectorizedSerde)this.serializer).serializeVector(vrg, this.inputObjInspectors[0]);
                records = (Writable[])((ObjectWritable)this.recordValue).get();
                vectorizedSerde = true;
            }
        }
        catch (SerDeException e1) {
            throw new HiveException(e1);
        }
        for (int i = 0; i < vrg.size; ++i) {
            Writable row = null;
            if (vectorizedSerde) {
                row = records[i];
            } else {
                if (vrg.valueWriters == null) {
                    vrg.setValueWriters(this.valueWriters);
                }
                try {
                    row = this.serializer.serialize((Object)this.getRowObject(vrg, i), this.inputObjInspectors[0]);
                }
                catch (SerDeException ex) {
                    throw new HiveException(ex);
                }
            }
            String lbDirName = null;
            String string = lbDirName = this.lbCtx == null ? null : this.generateListBucketingDirName(row);
            if (!this.bDynParts && !this.filesCreated) {
                if (lbDirName != null) {
                    FileSinkOperator.FSPaths fsp2 = this.lookupListBucketingPaths(lbDirName);
                } else {
                    this.createBucketFiles(this.fsp);
                }
            }
            try {
                FileSinkOperator.FSPaths fpaths;
                this.updateProgress();
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                if (this.bDynParts) {
                    this.dpVals.clear();
                    this.dpWritables.clear();
                    ObjectInspectorUtils.partialCopyToStandardObject((List)this.dpWritables, (Object)row, (int)this.dpStartCol, (int)this.numDynParts, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                    for (Object o : this.dpWritables) {
                        if (o == null || o.toString().length() == 0) {
                            this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                            continue;
                        }
                        this.dpVals.add(o.toString());
                    }
                    fpaths = this.getDynOutPaths(this.dpVals, lbDirName);
                } else {
                    fpaths = lbDirName != null ? this.lookupListBucketingPaths(lbDirName) : this.fsp;
                }
                this.rowOutWriters = fpaths.getOutWriters();
                if (((FileSinkDesc)this.conf).isGatherStats()) {
                    SerDeStats stats;
                    if (this.statsCollectRawDataSize && (stats = this.serializer.getSerDeStats()) != null) {
                        fpaths.getStat().addToStat("rawDataSize", stats.getRawDataSize());
                    }
                    fpaths.getStat().addToStat("numRows", 1L);
                }
                if (this.row_count != null) {
                    this.row_count.set(this.row_count.get() + 1L);
                }
                if (!this.multiFileSpray) {
                    this.rowOutWriters[0].write(row);
                    continue;
                }
                int keyHashCode = 0;
                this.key.setHashCode(keyHashCode);
                int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
                int idx = (Integer)this.bucketMap.get(bucketNum);
                this.rowOutWriters[idx].write(row);
                continue;
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }
    }

    private Object[] getRowObject(VectorizedRowBatch vrg, int rowIndex) throws HiveException {
        int batchIndex = rowIndex;
        if (vrg.selectedInUse) {
            batchIndex = vrg.selected[rowIndex];
        }
        for (int i = 0; i < vrg.projectionSize; ++i) {
            ColumnVector vectorColumn = vrg.cols[vrg.projectedColumns[i]];
            this.singleRow[i] = vrg.valueWriters[i].writeValue(vectorColumn, batchIndex);
        }
        return this.singleRow;
    }
}

