/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorUtilBatchObjectPool;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

public class VectorGroupByOperator
extends GroupByOperator {
    private static final Log LOG = LogFactory.getLog((String)VectorGroupByOperator.class.getName());
    private VectorAggregateExpression[] aggregators;
    private VectorExpression[] keyExpressions;
    private transient VectorExpressionWriter[] keyOutputWriters;
    private transient VectorAggregationBufferBatch aggregationBatchInfo;
    private transient VectorHashKeyWrapperBatch keyWrappersBatch;
    private transient Object[] forwardCache;
    private transient IProcessingMode processingMode;
    private static final long serialVersionUID = 1L;

    public VectorGroupByOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        GroupByDesc desc = (GroupByDesc)conf;
        this.conf = desc;
        ArrayList<ExprNodeDesc> keysDesc = desc.getKeys();
        this.keyExpressions = vContext.getVectorExpressions(keysDesc);
        ArrayList<AggregationDesc> aggrDesc = desc.getAggregators();
        this.aggregators = new VectorAggregateExpression[aggrDesc.size()];
        for (int i = 0; i < aggrDesc.size(); ++i) {
            AggregationDesc aggDesc = aggrDesc.get(i);
            this.aggregators[i] = vContext.getAggregatorExpression(aggDesc);
        }
    }

    public VectorGroupByOperator() {
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        ArrayList<ObjectInspector> objectInspectors = new ArrayList<ObjectInspector>();
        ArrayList<ExprNodeDesc> keysDesc = ((GroupByDesc)this.conf).getKeys();
        try {
            int i;
            this.keyOutputWriters = new VectorExpressionWriter[this.keyExpressions.length];
            for (i = 0; i < this.keyExpressions.length; ++i) {
                this.keyOutputWriters[i] = VectorExpressionWriterFactory.genVectorExpressionWritable((ExprNodeDesc)keysDesc.get(i));
                objectInspectors.add(this.keyOutputWriters[i].getObjectInspector());
            }
            for (i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].init(((GroupByDesc)this.conf).getAggregators().get(i));
                objectInspectors.add(this.aggregators[i].getOutputObjectInspector());
            }
            this.keyWrappersBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
            this.aggregationBatchInfo = new VectorAggregationBufferBatch();
            this.aggregationBatchInfo.compileAggregationBatchInfo(this.aggregators);
            ArrayList<String> outputFieldNames = ((GroupByDesc)this.conf).getOutputColumnNames();
            this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(outputFieldNames, objectInspectors);
        }
        catch (HiveException he) {
            throw he;
        }
        catch (Throwable e) {
            throw new HiveException(e);
        }
        this.initializeChildren(hconf);
        this.forwardCache = new Object[this.keyExpressions.length + this.aggregators.length];
        this.processingMode = this.keyExpressions.length == 0 ? new ProcessingModeGlobalAggregate() : new ProcessingModeHashAggregate();
        this.processingMode.initialize(hconf);
    }

    private void changeToStreamingMode() throws HiveException {
        this.processingMode = new ProcessingModeStreaming();
        this.processingMode.initialize(null);
        LOG.trace((Object)"switched to streaming mode");
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        if (batch.size > 0) {
            this.processingMode.processBatch(batch);
        }
    }

    private void flushSingleRow(VectorHashKeyWrapper kw, VectorAggregationBufferRow agg) throws HiveException {
        int i;
        int fi = 0;
        for (i = 0; i < this.keyExpressions.length; ++i) {
            this.forwardCache[fi++] = this.keyWrappersBatch.getWritableKeyValue(kw, i, this.keyOutputWriters[i]);
        }
        for (i = 0; i < this.aggregators.length; ++i) {
            this.forwardCache[fi++] = this.aggregators[i].evaluateOutput(agg.getAggregationBuffer(i));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("forwarding keys: %s: %s", kw, Arrays.toString(this.forwardCache)));
        }
        this.forward((Object)this.forwardCache, this.outputObjInspector);
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        this.processingMode.close(aborted);
    }

    public static String getOperatorName() {
        return "GBY";
    }

    public VectorExpression[] getKeyExpressions() {
        return this.keyExpressions;
    }

    public void setKeyExpressions(VectorExpression[] keyExpressions) {
        this.keyExpressions = keyExpressions;
    }

    public VectorAggregateExpression[] getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(VectorAggregateExpression[] aggregators) {
        this.aggregators = aggregators;
    }

    private class ProcessingModeStreaming
    extends ProcessingModeBase {
        private VectorAggregationBufferRow currentStreamingAggregators;
        private VectorHashKeyWrapper streamingKey;
        private final VectorHashKeyWrapper[] keysToFlush;
        private final VectorAggregationBufferRow[] rowsToFlush;
        private VectorUtilBatchObjectPool<VectorAggregationBufferRow> streamAggregationBufferRowPool;

        private ProcessingModeStreaming() {
            this.keysToFlush = new VectorHashKeyWrapper[1024];
            this.rowsToFlush = new VectorAggregationBufferRow[1024];
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            this.streamAggregationBufferRowPool = new VectorUtilBatchObjectPool<VectorAggregationBufferRow>(1024, new VectorUtilBatchObjectPool.IAllocator<VectorAggregationBufferRow>(){

                @Override
                public VectorAggregationBufferRow alloc() throws HiveException {
                    return ProcessingModeStreaming.this.allocateAggregationBuffer();
                }

                @Override
                public void free(VectorAggregationBufferRow t) {
                }
            });
            LOG.info((Object)"using streaming aggregation processing mode");
        }

        @Override
        public void processBatch(VectorizedRowBatch batch) throws HiveException {
            int i;
            VectorGroupByOperator.this.keyWrappersBatch.evaluateBatch(batch);
            VectorHashKeyWrapper[] batchKeys = VectorGroupByOperator.this.keyWrappersBatch.getVectorHashKeyWrappers();
            if (this.streamingKey == null) {
                this.currentStreamingAggregators = this.streamAggregationBufferRowPool.getFromPool();
                this.streamingKey = (VectorHashKeyWrapper)batchKeys[0].copyKey();
            }
            VectorGroupByOperator.this.aggregationBatchInfo.startBatch();
            int flushMark = 0;
            for (i = 0; i < batch.size; ++i) {
                if (!batchKeys[i].equals(this.streamingKey)) {
                    this.rowsToFlush[flushMark] = this.currentStreamingAggregators;
                    if (this.keysToFlush[flushMark] == null) {
                        this.keysToFlush[flushMark] = (VectorHashKeyWrapper)this.streamingKey.copyKey();
                    } else {
                        this.streamingKey.duplicateTo(this.keysToFlush[flushMark]);
                    }
                    this.currentStreamingAggregators = this.streamAggregationBufferRowPool.getFromPool();
                    batchKeys[i].duplicateTo(this.streamingKey);
                    ++flushMark;
                }
                VectorGroupByOperator.this.aggregationBatchInfo.mapAggregationBufferSet(this.currentStreamingAggregators, i);
            }
            this.processAggregators(batch);
            for (i = 0; i < flushMark; ++i) {
                VectorGroupByOperator.this.flushSingleRow(this.keysToFlush[i], this.rowsToFlush[i]);
                this.rowsToFlush[i].reset();
                this.streamAggregationBufferRowPool.putInPool(this.rowsToFlush[i]);
            }
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted && null != this.streamingKey) {
                VectorGroupByOperator.this.flushSingleRow(this.streamingKey, this.currentStreamingAggregators);
            }
        }
    }

    private class ProcessingModeHashAggregate
    extends ProcessingModeBase {
        private Map<KeyWrapper, VectorAggregationBufferRow> mapKeysAggregationBuffers;
        private int fixedHashEntrySize;
        private int avgVariableSize;
        private int numEntriesSinceCheck;
        private long sumBatchSize;
        private int maxHtEntries;
        private int checkInterval;
        private float percentEntriesToFlush;
        private SoftReference<Object> gcCanary;
        private long gcCanaryFlushes;
        private long lastModeCheckRowCount;
        private float minReductionHashAggr;
        private long numRowsCompareHashAggr;

        private ProcessingModeHashAggregate() {
            this.maxHtEntries = 1000000;
            this.checkInterval = 10000;
            this.percentEntriesToFlush = 0.1f;
            this.gcCanary = new SoftReference<Object>(new Object());
            this.gcCanaryFlushes = 0L;
            this.lastModeCheckRowCount = 0L;
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            if (null != hconf) {
                this.percentEntriesToFlush = HiveConf.getFloatVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_FLUSH_PERCENT);
                this.checkInterval = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_CHECKINTERVAL);
                this.maxHtEntries = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_MAXENTRIES);
                this.minReductionHashAggr = HiveConf.getFloatVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION);
                this.numRowsCompareHashAggr = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEGROUPBYMAPINTERVAL);
            } else {
                this.percentEntriesToFlush = HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_FLUSH_PERCENT.defaultFloatVal;
                this.checkInterval = HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_CHECKINTERVAL.defaultIntVal;
                this.maxHtEntries = HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_MAXENTRIES.defaultIntVal;
                this.minReductionHashAggr = HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION.defaultFloatVal;
                this.numRowsCompareHashAggr = HiveConf.ConfVars.HIVEGROUPBYMAPINTERVAL.defaultIntVal;
            }
            this.mapKeysAggregationBuffers = new HashMap<KeyWrapper, VectorAggregationBufferRow>();
            this.computeMemoryLimits();
            LOG.info((Object)"using hash aggregation processing mode");
        }

        @Override
        public void processBatch(VectorizedRowBatch batch) throws HiveException {
            VectorGroupByOperator.this.keyWrappersBatch.evaluateBatch(batch);
            this.prepareBatchAggregationBufferSets(batch);
            this.processAggregators(batch);
            int preFlushEntriesCount = VectorGroupByOperator.this.numEntriesHashTable;
            while (this.shouldFlush(batch)) {
                this.flush(false);
                if (this.gcCanary.get() == null) {
                    ++this.gcCanaryFlushes;
                    this.gcCanary = new SoftReference<Object>(new Object());
                }
                if (VectorGroupByOperator.this.numEntriesHashTable >= preFlushEntriesCount) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)String.format("Flush did not progress: %d entries before, %d entries after", preFlushEntriesCount, VectorGroupByOperator.this.numEntriesHashTable));
                    break;
                }
                preFlushEntriesCount = VectorGroupByOperator.this.numEntriesHashTable;
            }
            if (this.sumBatchSize == 0L && 0 != batch.size) {
                this.updateAvgVariableSize(batch);
            }
            this.sumBatchSize += (long)batch.size;
            this.lastModeCheckRowCount += (long)batch.size;
            this.checkHashModeEfficiency();
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted) {
                this.flush(true);
            }
        }

        private void prepareBatchAggregationBufferSets(VectorizedRowBatch batch) throws HiveException {
            VectorGroupByOperator.this.aggregationBatchInfo.startBatch();
            VectorHashKeyWrapper[] keyWrappers = VectorGroupByOperator.this.keyWrappersBatch.getVectorHashKeyWrappers();
            for (int i = 0; i < batch.size; ++i) {
                VectorHashKeyWrapper kw = keyWrappers[i];
                VectorAggregationBufferRow aggregationBuffer = this.mapKeysAggregationBuffers.get(kw);
                if (null == aggregationBuffer) {
                    aggregationBuffer = this.allocateAggregationBuffer();
                    this.mapKeysAggregationBuffers.put(kw.copyKey(), aggregationBuffer);
                    VectorGroupByOperator.this.numEntriesHashTable++;
                    ++this.numEntriesSinceCheck;
                }
                VectorGroupByOperator.this.aggregationBatchInfo.mapAggregationBufferSet(aggregationBuffer, i);
            }
        }

        private void computeMemoryLimits() {
            JavaDataModel model = JavaDataModel.get();
            this.fixedHashEntrySize = model.hashMapEntry() + VectorGroupByOperator.this.keyWrappersBatch.getKeysFixedSize() + VectorGroupByOperator.this.aggregationBatchInfo.getAggregatorsFixedSize();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            VectorGroupByOperator.this.maxMemory = memoryMXBean.getHeapMemoryUsage().getMax();
            VectorGroupByOperator.this.memoryThreshold = ((GroupByDesc)VectorGroupByOperator.this.conf).getMemoryThreshold();
            if (VectorGroupByOperator.this.memoryThreshold == 0.0f) {
                VectorGroupByOperator.this.memoryThreshold = 1.0f;
            }
            VectorGroupByOperator.this.maxHashTblMemory = (int)((float)VectorGroupByOperator.this.maxMemory * VectorGroupByOperator.this.memoryThreshold);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("maxMemory:%dMb (%d * %f) fixSize:%d (key:%d agg:%d)", VectorGroupByOperator.this.maxHashTblMemory / 1024L / 1024L, VectorGroupByOperator.this.maxMemory / 1024L / 1024L, Float.valueOf(VectorGroupByOperator.this.memoryThreshold), this.fixedHashEntrySize, VectorGroupByOperator.this.keyWrappersBatch.getKeysFixedSize(), VectorGroupByOperator.this.aggregationBatchInfo.getAggregatorsFixedSize()));
            }
        }

        private void flush(boolean all) throws HiveException {
            int entriesToFlush = all ? VectorGroupByOperator.this.numEntriesHashTable : (int)((float)VectorGroupByOperator.this.numEntriesHashTable * this.percentEntriesToFlush);
            int entriesFlushed = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Flush %d %s entries:%d fixed:%d variable:%d (used:%dMb max:%dMb) gcCanary:%s", entriesToFlush, all ? "(all)" : "", VectorGroupByOperator.this.numEntriesHashTable, this.fixedHashEntrySize, this.avgVariableSize, VectorGroupByOperator.this.numEntriesHashTable * (this.fixedHashEntrySize + this.avgVariableSize) / 1024 / 1024, VectorGroupByOperator.this.maxHashTblMemory / 1024L / 1024L, this.gcCanary.get() == null ? "dead" : "alive"));
            }
            Iterator<Map.Entry<KeyWrapper, VectorAggregationBufferRow>> iter = this.mapKeysAggregationBuffers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<KeyWrapper, VectorAggregationBufferRow> pair = iter.next();
                VectorGroupByOperator.this.flushSingleRow((VectorHashKeyWrapper)pair.getKey(), pair.getValue());
                if (all) continue;
                iter.remove();
                --VectorGroupByOperator.this.numEntriesHashTable;
                if (++entriesFlushed < entriesToFlush) continue;
                break;
            }
            if (all) {
                this.mapKeysAggregationBuffers.clear();
                VectorGroupByOperator.this.numEntriesHashTable = 0;
            }
            if (all && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("GC canary caused %d flushes", this.gcCanaryFlushes));
            }
        }

        private boolean shouldFlush(VectorizedRowBatch batch) {
            if (batch.size == 0) {
                return false;
            }
            if (this.numEntriesSinceCheck >= this.checkInterval) {
                this.updateAvgVariableSize(batch);
                this.numEntriesSinceCheck = 0;
            }
            if (VectorGroupByOperator.this.numEntriesHashTable > this.maxHtEntries || (long)(VectorGroupByOperator.this.numEntriesHashTable * (this.fixedHashEntrySize + this.avgVariableSize)) > VectorGroupByOperator.this.maxHashTblMemory) {
                return true;
            }
            return this.gcCanary.get() == null;
        }

        private void updateAvgVariableSize(VectorizedRowBatch batch) {
            int keyVariableSize = VectorGroupByOperator.this.keyWrappersBatch.getVariableSize(batch.size);
            int aggVariableSize = VectorGroupByOperator.this.aggregationBatchInfo.getVariableSize(batch.size);
            this.avgVariableSize = (int)(((long)this.avgVariableSize * this.sumBatchSize + (long)keyVariableSize + (long)aggVariableSize) / (this.sumBatchSize + (long)batch.size));
        }

        private void checkHashModeEfficiency() throws HiveException {
            if (this.lastModeCheckRowCount > this.numRowsCompareHashAggr) {
                this.lastModeCheckRowCount = 0L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("checkHashModeEfficiency: HT:%d RC:%d MIN:%d", VectorGroupByOperator.this.numEntriesHashTable, this.sumBatchSize, (long)((float)this.sumBatchSize * this.minReductionHashAggr)));
                }
                if ((float)VectorGroupByOperator.this.numEntriesHashTable > (float)this.sumBatchSize * this.minReductionHashAggr) {
                    this.flush(true);
                    VectorGroupByOperator.this.changeToStreamingMode();
                }
            }
        }
    }

    private class ProcessingModeGlobalAggregate
    extends ProcessingModeBase {
        private VectorAggregationBufferRow aggregationBuffers;

        private ProcessingModeGlobalAggregate() {
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            this.aggregationBuffers = this.allocateAggregationBuffer();
            LOG.info((Object)"using global aggregation processing mode");
        }

        @Override
        public void processBatch(VectorizedRowBatch batch) throws HiveException {
            for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                VectorGroupByOperator.this.aggregators[i].aggregateInput(this.aggregationBuffers.getAggregationBuffer(i), batch);
            }
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted) {
                VectorGroupByOperator.this.flushSingleRow(null, this.aggregationBuffers);
            }
        }
    }

    private abstract class ProcessingModeBase
    implements IProcessingMode {
        private ProcessingModeBase() {
        }

        protected void processAggregators(VectorizedRowBatch batch) throws HiveException {
            VectorAggregationBufferRow[] aggregationBufferSets = VectorGroupByOperator.this.aggregationBatchInfo.getAggregationBuffers();
            if (VectorGroupByOperator.this.aggregationBatchInfo.getDistinctBufferSetCount() == 1) {
                VectorAggregateExpression.AggregationBuffer[] aggregationBuffers = aggregationBufferSets[0].getAggregationBuffers();
                for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                    VectorGroupByOperator.this.aggregators[i].aggregateInput(aggregationBuffers[i], batch);
                }
            } else {
                for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                    VectorGroupByOperator.this.aggregators[i].aggregateInputSelection(aggregationBufferSets, i, batch);
                }
            }
        }

        protected VectorAggregationBufferRow allocateAggregationBuffer() throws HiveException {
            VectorAggregateExpression.AggregationBuffer[] aggregationBuffers = new VectorAggregateExpression.AggregationBuffer[VectorGroupByOperator.this.aggregators.length];
            for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                aggregationBuffers[i] = VectorGroupByOperator.this.aggregators[i].getNewAggregationBuffer();
                VectorGroupByOperator.this.aggregators[i].reset(aggregationBuffers[i]);
            }
            VectorAggregationBufferRow bufferSet = new VectorAggregationBufferRow(aggregationBuffers);
            return bufferSet;
        }
    }

    private static interface IProcessingMode {
        public void initialize(Configuration var1) throws HiveException;

        public void processBatch(VectorizedRowBatch var1) throws HiveException;

        public void close(boolean var1) throws HiveException;
    }
}

