/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssignFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorMapJoinOperator
extends MapJoinOperator
implements VectorizationContextRegion {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinOperator.class.getName());
    private static final long serialVersionUID = 1L;
    private String fileKey;
    private int tagLen;
    private VectorExpression[] keyExpressions;
    private transient VectorHashKeyWrapperBatch keyWrapperBatch;
    private transient VectorExpressionWriter[] keyOutputWriters;
    private VectorExpression[] bigTableFilterExpressions;
    private VectorExpression[] bigTableValueExpressions;
    private transient VectorizedRowBatch outputBatch;
    private transient MapJoinKeyEvaluator keyEvaluator;
    private transient VectorExpressionWriter[] valueWriters;
    private transient Map<ObjectInspector, VectorColumnAssign[]> outputVectorAssigners;
    private transient int batchIndex;
    private transient VectorHashKeyWrapper[] keyValues;
    private transient VectorizationContext vOutContext = null;
    private transient VectorizedRowBatchCtx vrbCtx = null;

    public VectorMapJoinOperator() {
    }

    public VectorMapJoinOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.order = desc.getTagOrder();
        this.numAliases = desc.getExprs().size();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.filterMaps = desc.getFilterMap();
        this.tagLen = desc.getTagLength();
        this.noOuterJoin = desc.isNoOuterJoin();
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(this.posBigTable);
        this.keyExpressions = vContext.getVectorExpressions(keyDesc);
        Map<Byte, List<ExprNodeDesc>> exprs = desc.getExprs();
        this.bigTableValueExpressions = vContext.getVectorExpressions(exprs.get(this.posBigTable));
        List<String> outColNames = desc.getOutputColumnNames();
        HashMap<String, Integer> mapOutCols = new HashMap<String, Integer>(outColNames.size());
        int outColIndex = 0;
        for (String outCol : outColNames) {
            mapOutCols.put(outCol, outColIndex++);
        }
        this.vOutContext = new VectorizationContext(mapOutCols, outColIndex);
        this.vOutContext.setFileKey(vContext.getFileKey() + "/MAP_JOIN_" + desc.getBigTableAlias());
        this.fileKey = this.vOutContext.getFileKey();
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        List<ExprNodeDesc> keyDesc = ((MapJoinDesc)this.conf).getKeys().get(this.posBigTable);
        this.keyOutputWriters = VectorExpressionWriterFactory.getExpressionWriters(keyDesc);
        this.vrbCtx = new VectorizedRowBatchCtx();
        this.vrbCtx.init(hconf, this.fileKey, (StructObjectInspector)this.outputObjInspector);
        this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
        this.keyWrapperBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
        this.keyEvaluator = new MapJoinKeyEvaluator(){
            private MapJoinKey key = null;
            private final ByteStream.Output output = new ByteStream.Output();

            public MapJoinKeyEvaluator init() {
                return this;
            }

            @Override
            public MapJoinKey evaluate(VectorHashKeyWrapper kw) throws HiveException {
                MapJoinKey refKey = VectorMapJoinOperator.this.getRefKey(this.key, VectorMapJoinOperator.this.alias);
                this.key = MapJoinKey.readFromVector(this.output, refKey, kw, VectorMapJoinOperator.this.keyOutputWriters, VectorMapJoinOperator.this.keyWrapperBatch, refKey == this.key);
                return this.key;
            }
        }.init();
        Map<Byte, List<ExprNodeDesc>> valueExpressions = ((MapJoinDesc)this.conf).getExprs();
        List<ExprNodeDesc> bigTableExpressions = valueExpressions.get(this.posBigTable);
        VectorExpressionWriterFactory.processVectorExpressions(bigTableExpressions, new VectorExpressionWriterFactory.ListOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, List<ObjectInspector> oids) {
                VectorMapJoinOperator.access$402(VectorMapJoinOperator.this, writers);
                ((VectorMapJoinOperator)VectorMapJoinOperator.this).joinValuesObjectInspectors[((VectorMapJoinOperator)VectorMapJoinOperator.this).posBigTable] = oids;
            }
        });
        ArrayList<ExprNodeEvaluator> vectorNodeEvaluators = new ArrayList<ExprNodeEvaluator>(bigTableExpressions.size());
        for (int i = 0; i < bigTableExpressions.size(); ++i) {
            ExprNodeDesc desc = bigTableExpressions.get(i);
            VectorExpression vectorExpr = this.bigTableValueExpressions[i];
            ExprNodeEvaluator eval = new ExprNodeEvaluator<ExprNodeDesc>(desc){
                int columnIndex;
                int writerIndex;

                public ExprNodeEvaluator initVectorExpr(int columnIndex, int writerIndex) {
                    this.columnIndex = columnIndex;
                    this.writerIndex = writerIndex;
                    return this;
                }

                @Override
                public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
                    throw new HiveException("should never reach here");
                }

                @Override
                protected Object _evaluate(Object row, int version) throws HiveException {
                    VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
                    int rowIndex = inBatch.selectedInUse ? inBatch.selected[VectorMapJoinOperator.this.batchIndex] : VectorMapJoinOperator.this.batchIndex;
                    return VectorMapJoinOperator.this.valueWriters[this.writerIndex].writeValue(inBatch.cols[this.columnIndex], rowIndex);
                }
            }.initVectorExpr(vectorExpr.getOutputColumn(), i);
            vectorNodeEvaluators.add(eval);
        }
        this.joinValues[this.posBigTable] = vectorNodeEvaluators;
        this.filterMaps[this.posBigTable] = null;
        this.outputVectorAssigners = new HashMap<ObjectInspector, VectorColumnAssign[]>();
    }

    @Override
    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        Object[] values = (Object[])row;
        VectorColumnAssign[] vcas = this.outputVectorAssigners.get(outputOI);
        if (null == vcas) {
            Map<String, Map<String, Integer>> allColumnMaps = Utilities.getMapRedWork(this.hconf).getMapWork().getScratchColumnMap();
            Map<String, Integer> columnMap = allColumnMaps.get(this.fileKey);
            vcas = VectorColumnAssignFactory.buildAssigners(this.outputBatch, outputOI, columnMap, ((MapJoinDesc)this.conf).getOutputColumnNames());
            this.outputVectorAssigners.put(outputOI, vcas);
        }
        for (int i = 0; i < values.length; ++i) {
            vcas[i].assignObjectValue(values[i], this.outputBatch.size);
        }
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
        }
    }

    private void flushOutput() throws HiveException {
        this.forward(this.outputBatch, null);
        this.outputBatch.reset();
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        if (!aborted && 0 < this.outputBatch.size) {
            this.flushOutput();
        }
    }

    @Override
    protected MapJoinKey computeMapJoinKey(Object row, byte alias) throws HiveException {
        return this.keyEvaluator.evaluate(this.keyValues[this.batchIndex]);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        byte alias = (byte)tag;
        VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
        if (null != this.bigTableFilterExpressions) {
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(inBatch);
            }
        }
        if (null != this.bigTableValueExpressions) {
            for (VectorExpression ve : this.bigTableValueExpressions) {
                ve.evaluate(inBatch);
            }
        }
        this.keyWrapperBatch.evaluateBatch(inBatch);
        this.keyValues = this.keyWrapperBatch.getVectorHashKeyWrappers();
        this.batchIndex = 0;
        while (this.batchIndex < inBatch.size) {
            super.processOp(row, tag);
            ++this.batchIndex;
        }
        this.batchIndex = -1;
        this.keyValues = null;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }

    static /* synthetic */ VectorExpressionWriter[] access$402(VectorMapJoinOperator x0, VectorExpressionWriter[] x1) {
        x0.valueWriters = x1;
        return x1;
    }

    private static interface MapJoinKeyEvaluator {
        public MapJoinKey evaluate(VectorHashKeyWrapper var1) throws HiveException;
    }
}

