/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssignFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorSMBMapJoinOperator
extends SMBMapJoinOperator
implements VectorizationContextRegion {
    private static final Log LOG = LogFactory.getLog((String)VectorSMBMapJoinOperator.class.getName());
    private static final long serialVersionUID = 1L;
    private int tagLen;
    private transient VectorizedRowBatch outputBatch;
    private transient VectorizationContext vOutContext = null;
    private transient VectorizedRowBatchCtx vrbCtx = null;
    private String fileKey;
    private VectorExpression[] bigTableValueExpressions;
    private VectorExpression[] bigTableFilterExpressions;
    private VectorExpression[] keyExpressions;
    private VectorExpressionWriter[] keyOutputWriters;
    private transient VectorHashKeyWrapperBatch keyWrapperBatch;
    private transient Map<ObjectInspector, VectorColumnAssign[]> outputVectorAssigners;
    private transient int batchIndex = -1;
    private transient VectorHashKeyWrapper[] keyValues;
    private transient SMBJoinKeyEvaluator keyEvaluator;
    private transient VectorExpressionWriter[] valueWriters;

    public VectorSMBMapJoinOperator() {
    }

    public VectorSMBMapJoinOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        SMBJoinDesc desc = (SMBJoinDesc)conf;
        this.conf = desc;
        this.order = desc.getTagOrder();
        this.numAliases = desc.getExprs().size();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.filterMaps = desc.getFilterMap();
        this.tagLen = desc.getTagLength();
        this.noOuterJoin = desc.isNoOuterJoin();
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(this.posBigTable);
        this.keyExpressions = vContext.getVectorExpressions(keyDesc);
        this.keyOutputWriters = VectorExpressionWriterFactory.getExpressionWriters(keyDesc);
        Map<Byte, List<ExprNodeDesc>> exprs = desc.getExprs();
        this.bigTableValueExpressions = vContext.getVectorExpressions(exprs.get(this.posBigTable));
        List<String> outColNames = desc.getOutputColumnNames();
        HashMap<String, Integer> mapOutCols = new HashMap<String, Integer>(outColNames.size());
        int outColIndex = 0;
        for (String outCol : outColNames) {
            mapOutCols.put(outCol, outColIndex++);
        }
        this.vOutContext = new VectorizationContext(mapOutCols, outColIndex);
        this.vOutContext.setFileKey(vContext.getFileKey() + "/SMB_JOIN_" + desc.getBigTableAlias());
        this.fileKey = this.vOutContext.getFileKey();
    }

    @Override
    protected List<Object> smbJoinComputeKeys(Object row, byte alias) throws HiveException {
        if (alias == this.posBigTable) {
            VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
            return this.keyEvaluator.evaluate(this.keyValues[this.batchIndex]);
        }
        return super.smbJoinComputeKeys(row, alias);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.vrbCtx = new VectorizedRowBatchCtx();
        this.vrbCtx.init(hconf, this.fileKey, (StructObjectInspector)this.outputObjInspector);
        this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
        this.keyWrapperBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
        this.outputVectorAssigners = new HashMap<ObjectInspector, VectorColumnAssign[]>();
        this.keyEvaluator = new SMBJoinKeyEvaluator(){
            private List<Object> key;

            public SMBJoinKeyEvaluator init() {
                this.key = new ArrayList<Object>();
                for (int i = 0; i < VectorSMBMapJoinOperator.this.keyExpressions.length; ++i) {
                    this.key.add(null);
                }
                return this;
            }

            @Override
            public List<Object> evaluate(VectorHashKeyWrapper kw) throws HiveException {
                for (int i = 0; i < VectorSMBMapJoinOperator.this.keyExpressions.length; ++i) {
                    this.key.set(i, VectorSMBMapJoinOperator.this.keyWrapperBatch.getWritableKeyValue(kw, i, VectorSMBMapJoinOperator.this.keyOutputWriters[i]));
                }
                return this.key;
            }
        }.init();
        Map<Byte, List<ExprNodeDesc>> valueExpressions = ((SMBJoinDesc)this.conf).getExprs();
        List<ExprNodeDesc> bigTableExpressions = valueExpressions.get(this.posBigTable);
        ArrayList<ExprNodeEvaluator> vectorNodeEvaluators = new ArrayList<ExprNodeEvaluator>(bigTableExpressions.size());
        VectorExpressionWriterFactory.processVectorExpressions(bigTableExpressions, new VectorExpressionWriterFactory.ListOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, List<ObjectInspector> oids) {
                VectorSMBMapJoinOperator.access$302(VectorSMBMapJoinOperator.this, writers);
                ((VectorSMBMapJoinOperator)VectorSMBMapJoinOperator.this).joinValuesObjectInspectors[((VectorSMBMapJoinOperator)VectorSMBMapJoinOperator.this).posBigTable] = oids;
            }
        });
        for (int i = 0; i < bigTableExpressions.size(); ++i) {
            ExprNodeDesc desc = bigTableExpressions.get(i);
            VectorExpression vectorExpr = this.bigTableValueExpressions[i];
            ExprNodeEvaluator eval = new ExprNodeEvaluator<ExprNodeDesc>(desc){
                int columnIndex;
                int writerIndex;

                public ExprNodeEvaluator initVectorExpr(int columnIndex, int writerIndex) {
                    this.columnIndex = columnIndex;
                    this.writerIndex = writerIndex;
                    return this;
                }

                @Override
                public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
                    throw new HiveException("should never reach here");
                }

                @Override
                protected Object _evaluate(Object row, int version) throws HiveException {
                    VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
                    int rowIndex = inBatch.selectedInUse ? inBatch.selected[VectorSMBMapJoinOperator.this.batchIndex] : VectorSMBMapJoinOperator.this.batchIndex;
                    return VectorSMBMapJoinOperator.this.valueWriters[this.writerIndex].writeValue(inBatch.cols[this.columnIndex], rowIndex);
                }
            }.initVectorExpr(vectorExpr.getOutputColumn(), i);
            vectorNodeEvaluators.add(eval);
        }
        this.joinValues[this.posBigTable] = vectorNodeEvaluators;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        byte alias = (byte)tag;
        if (alias != this.posBigTable) {
            super.processOp(row, tag);
        } else {
            VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
            if (null != this.bigTableFilterExpressions) {
                for (VectorExpression ve : this.bigTableFilterExpressions) {
                    ve.evaluate(inBatch);
                }
            }
            if (null != this.bigTableValueExpressions) {
                for (VectorExpression ve : this.bigTableValueExpressions) {
                    ve.evaluate(inBatch);
                }
            }
            this.keyWrapperBatch.evaluateBatch(inBatch);
            this.keyValues = this.keyWrapperBatch.getVectorHashKeyWrappers();
            this.batchIndex = 0;
            while (this.batchIndex < inBatch.size) {
                super.processOp(row, tag);
                ++this.batchIndex;
            }
            this.batchIndex = -1;
            this.keyValues = null;
        }
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        super.closeOp(aborted);
        if (!aborted && 0 < this.outputBatch.size) {
            this.flushOutput();
        }
    }

    @Override
    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        Object[] values = (Object[])row;
        VectorColumnAssign[] vcas = this.outputVectorAssigners.get(outputOI);
        if (null == vcas) {
            Map<String, Map<String, Integer>> allColumnMaps = Utilities.getMapRedWork(this.hconf).getMapWork().getScratchColumnMap();
            Map<String, Integer> columnMap = allColumnMaps.get(this.fileKey);
            vcas = VectorColumnAssignFactory.buildAssigners(this.outputBatch, outputOI, columnMap, ((SMBJoinDesc)this.conf).getOutputColumnNames());
            this.outputVectorAssigners.put(outputOI, vcas);
        }
        for (int i = 0; i < values.length; ++i) {
            vcas[i].assignObjectValue(values[i], this.outputBatch.size);
        }
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
        }
    }

    private void flushOutput() throws HiveException {
        this.forward(this.outputBatch, null);
        this.outputBatch.reset();
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }

    static /* synthetic */ VectorExpressionWriter[] access$302(VectorSMBMapJoinOperator x0, VectorExpressionWriter[] x1) {
        x0.valueWriters = x1;
        return x1;
    }

    private static interface SMBJoinKeyEvaluator {
        public List<Object> evaluate(VectorHashKeyWrapper var1) throws HiveException;
    }
}

