/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToStringViaLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterConstantBooleanVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDecimalColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterLongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDecimalInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDoubleInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ILongInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStringInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsTrue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLength;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorCoalesce;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFAvgDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCount;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCountStar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFSumDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFAvgDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFAvgLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdPopDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdPopDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdPopLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdSampDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdSampDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdSampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPopDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPopDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPopLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarSampDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarSampDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarSampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToBooleanViaLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastTimestampToDoubleViaLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorizationContext {
    private static final Log LOG = LogFactory.getLog((String)VectorizationContext.class.getName());
    VectorExpressionDescriptor vMap;
    private final Map<String, Integer> columnMap;
    private final int firstOutputColumnIndex;
    public static final Pattern decimalTypePattern = Pattern.compile("decimal.*", 2);
    private final OutputColumnManager ocm;
    private String fileKey = null;
    private static Set<Class<?>> castExpressionUdfs = new HashSet();
    static Object[][] aggregatesDefinition;

    public VectorizationContext(Map<String, Integer> columnMap, int initialOutputCol) {
        this.columnMap = columnMap;
        this.ocm = new OutputColumnManager(initialOutputCol);
        this.firstOutputColumnIndex = initialOutputCol;
        this.vMap = new VectorExpressionDescriptor();
    }

    public VectorizationContext(VectorizationContext parent) {
        this.columnMap = new HashMap<String, Integer>(parent.columnMap);
        this.ocm = parent.ocm;
        this.firstOutputColumnIndex = parent.firstOutputColumnIndex;
        this.vMap = new VectorExpressionDescriptor();
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    protected int getInputColumnIndex(String name) {
        if (!this.columnMap.containsKey(name)) {
            LOG.error((Object)String.format("The column %s is not in the vectorization context column map.", name));
        }
        return this.columnMap.get(name);
    }

    protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) {
        return this.columnMap.get(colExpr.getColumn());
    }

    private VectorExpression getColumnVectorExpression(ExprNodeColumnDesc exprDesc, VectorExpressionDescriptor.Mode mode) {
        int columnNum = this.getInputColumnIndex(exprDesc.getColumn());
        VectorExpression expr = null;
        switch (mode) {
            case FILTER: {
                expr = new SelectColumnIsTrue(columnNum);
                break;
            }
            case PROJECTION: {
                expr = new IdentityExpression(columnNum, exprDesc.getTypeString());
            }
        }
        return expr;
    }

    public VectorExpression[] getVectorExpressions(List<ExprNodeDesc> exprNodes) throws HiveException {
        return this.getVectorExpressions(exprNodes, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    public VectorExpression[] getVectorExpressions(List<ExprNodeDesc> exprNodes, VectorExpressionDescriptor.Mode mode) throws HiveException {
        int i = 0;
        if (null == exprNodes) {
            return new VectorExpression[0];
        }
        VectorExpression[] ret = new VectorExpression[exprNodes.size()];
        for (ExprNodeDesc e : exprNodes) {
            ret[i++] = this.getVectorExpression(e, mode);
        }
        return ret;
    }

    public VectorExpression getVectorExpression(ExprNodeDesc exprDesc) throws HiveException {
        return this.getVectorExpression(exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    public VectorExpression getVectorExpression(ExprNodeDesc exprDesc, VectorExpressionDescriptor.Mode mode) throws HiveException {
        VectorExpression ve = null;
        if (exprDesc instanceof ExprNodeColumnDesc) {
            ve = this.getColumnVectorExpression((ExprNodeColumnDesc)exprDesc, mode);
        } else if (exprDesc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)exprDesc;
            if (VectorizationContext.isCustomUDF(expr) || VectorizationContext.isNonVectorizedPathUDF(expr)) {
                ve = this.getCustomUDFExpression(expr);
            } else {
                List<ExprNodeDesc> childExpressions = this.getChildExpressionsWithImplicitCast(expr.getGenericUDF(), exprDesc.getChildren(), exprDesc.getTypeInfo());
                ve = this.getGenericUdfVectorExpression(expr.getGenericUDF(), childExpressions, mode, exprDesc.getTypeInfo());
            }
        } else if (exprDesc instanceof ExprNodeConstantDesc) {
            ve = this.getConstantVectorExpression(((ExprNodeConstantDesc)exprDesc).getValue(), exprDesc.getTypeInfo(), mode);
        }
        if (ve == null) {
            throw new HiveException("Could not vectorize expression: " + exprDesc.getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Input Expression = " + exprDesc.getTypeInfo() + ", Vectorized Expression = " + ve.toString()));
        }
        return ve;
    }

    private TypeInfo getCommonTypeForChildExpressions(GenericUDF genericUdf, List<ExprNodeDesc> children, TypeInfo returnType) {
        TypeInfo commonType;
        if (genericUdf instanceof GenericUDFBaseCompare) {
            TypeInfo tRight;
            TypeInfo tLeft = children.get(0).getTypeInfo();
            commonType = FunctionRegistry.getCommonClassForComparison(tLeft, tRight = children.get(1).getTypeInfo());
            if (commonType == null) {
                commonType = returnType;
            }
        } else {
            if (genericUdf instanceof GenericUDFIn) {
                return children.get(0).getTypeInfo();
            }
            commonType = returnType;
        }
        return commonType;
    }

    private List<ExprNodeDesc> getChildExpressionsWithImplicitCast(GenericUDF genericUDF, List<ExprNodeDesc> children, TypeInfo returnType) throws HiveException {
        if (this.isExcludedFromCast(genericUDF)) {
            return children;
        }
        if (children == null) {
            return null;
        }
        TypeInfo commonType = this.getCommonTypeForChildExpressions(genericUDF, children, returnType);
        if (commonType == null) {
            return children;
        }
        ArrayList<ExprNodeDesc> childrenWithCasts = new ArrayList<ExprNodeDesc>();
        boolean atleastOneCastNeeded = false;
        for (ExprNodeDesc child : children) {
            ExprNodeDesc castExpression = this.getImplicitCastExpression(genericUDF, child, commonType);
            if (castExpression != null) {
                atleastOneCastNeeded = true;
                childrenWithCasts.add(castExpression);
                continue;
            }
            childrenWithCasts.add(child);
        }
        if (atleastOneCastNeeded) {
            return childrenWithCasts;
        }
        return children;
    }

    private boolean isExcludedFromCast(GenericUDF genericUDF) {
        boolean ret;
        boolean bl = ret = castExpressionUdfs.contains(genericUDF.getClass()) || genericUDF instanceof GenericUDFRound || genericUDF instanceof GenericUDFBetween;
        if (ret) {
            return ret;
        }
        if (genericUDF instanceof GenericUDFBridge) {
            Class<? extends UDF> udfClass = ((GenericUDFBridge)genericUDF).getUdfClass();
            return castExpressionUdfs.contains(udfClass) || UDFSign.class.isAssignableFrom(udfClass);
        }
        return false;
    }

    private TypeInfo updatePrecision(TypeInfo inputTypeInfo, DecimalTypeInfo returnType) {
        if (!(inputTypeInfo instanceof PrimitiveTypeInfo)) {
            return returnType;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)inputTypeInfo;
        int precision = this.getPrecisionForType(ptinfo);
        int scale = HiveDecimalUtils.getScaleForType((PrimitiveTypeInfo)ptinfo);
        return new DecimalTypeInfo(precision, scale);
    }

    private ExprNodeDesc getImplicitCastExpression(GenericUDF udf, ExprNodeDesc child, TypeInfo castType) throws HiveException {
        String castTypeString;
        TypeInfo inputTypeInfo = child.getTypeInfo();
        String inputTypeString = inputTypeInfo.getTypeName();
        if (inputTypeString.equals(castTypeString = castType.getTypeName())) {
            return null;
        }
        boolean inputTypeDecimal = false;
        boolean castTypeDecimal = false;
        if (decimalTypePattern.matcher(inputTypeString).matches()) {
            inputTypeDecimal = true;
        }
        if (decimalTypePattern.matcher(castTypeString).matches()) {
            castTypeDecimal = true;
        }
        if (castTypeDecimal && !inputTypeDecimal) {
            castType = this.updatePrecision(inputTypeInfo, (DecimalTypeInfo)castType);
            GenericUDFToDecimal castToDecimalUDF = new GenericUDFToDecimal();
            castToDecimalUDF.setTypeInfo(castType);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(child);
            ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc(castType, (GenericUDF)castToDecimalUDF, children);
            return desc;
        }
        if (!castTypeDecimal && inputTypeDecimal) {
            GenericUDF genericUdf = this.getGenericUDFForCast(castType);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(child);
            ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc(castType, genericUdf, children);
            return desc;
        }
        if (udf instanceof GenericUDFCoalesce) {
            GenericUDF genericUdf = this.getGenericUDFForCast(castType);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(child);
            ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc(castType, genericUdf, children);
            return desc;
        }
        return null;
    }

    private int getPrecisionForType(PrimitiveTypeInfo typeInfo) {
        if (VectorizationContext.isFloatFamily(typeInfo.getTypeName())) {
            return 38;
        }
        return HiveDecimalUtils.getPrecisionForType((PrimitiveTypeInfo)typeInfo);
    }

    private GenericUDF getGenericUDFForCast(TypeInfo castType) throws HiveException {
        UDF udfClass = null;
        GenericUDF genericUdf = null;
        switch (((PrimitiveTypeInfo)castType).getPrimitiveCategory()) {
            case BYTE: {
                udfClass = new UDFToByte();
                break;
            }
            case SHORT: {
                udfClass = new UDFToShort();
                break;
            }
            case INT: {
                udfClass = new UDFToInteger();
                break;
            }
            case LONG: {
                udfClass = new UDFToLong();
                break;
            }
            case FLOAT: {
                udfClass = new UDFToFloat();
                break;
            }
            case DOUBLE: {
                udfClass = new UDFToDouble();
                break;
            }
            case STRING: {
                udfClass = new UDFToString();
                break;
            }
            case BOOLEAN: {
                udfClass = new UDFToBoolean();
                break;
            }
            case DATE: {
                genericUdf = new GenericUDFToDate();
                break;
            }
            case TIMESTAMP: {
                genericUdf = new GenericUDFToUnixTimeStamp();
                break;
            }
            case BINARY: {
                genericUdf = new GenericUDFToBinary();
                break;
            }
            case DECIMAL: {
                genericUdf = new GenericUDFToDecimal();
            }
        }
        if (genericUdf == null) {
            if (udfClass == null) {
                throw new HiveException("Could not add implicit cast for type " + castType.getTypeName());
            }
            genericUdf = new GenericUDFBridge();
            ((GenericUDFBridge)genericUdf).setUdfClassName(udfClass.getClass().getName());
        }
        if (genericUdf instanceof SettableUDF) {
            ((SettableUDF)((Object)genericUdf)).setTypeInfo(castType);
        }
        return genericUdf;
    }

    public static boolean isNonVectorizedPathUDF(ExprNodeGenericFuncDesc expr) {
        GenericUDFBridge bridge;
        Class<? extends UDF> udfClass;
        GenericUDF gudf = expr.getGenericUDF();
        return gudf instanceof GenericUDFBridge ? (udfClass = (bridge = (GenericUDFBridge)gudf).getUdfClass()).equals(UDFHex.class) || udfClass.equals(UDFConv.class) || VectorizationContext.isCastToIntFamily(udfClass) && VectorizationContext.arg0Type(expr).equals("string") || VectorizationContext.isCastToFloatFamily(udfClass) && VectorizationContext.arg0Type(expr).equals("string") || udfClass.equals(UDFToString.class) && (VectorizationContext.arg0Type(expr).equals("timestamp") || VectorizationContext.arg0Type(expr).equals("double") || VectorizationContext.arg0Type(expr).equals("float")) : gudf instanceof GenericUDFTimestamp && VectorizationContext.arg0Type(expr).equals("string") || gudf instanceof GenericUDFCase || gudf instanceof GenericUDFWhen;
    }

    public static boolean isCastToIntFamily(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToByte.class) || udfClass.equals(UDFToShort.class) || udfClass.equals(UDFToInteger.class) || udfClass.equals(UDFToLong.class);
    }

    public static boolean isCastToFloatFamily(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToDouble.class) || udfClass.equals(UDFToFloat.class);
    }

    public static String arg0Type(ExprNodeGenericFuncDesc expr) {
        String type = expr.getChildren().get(0).getTypeString();
        return type;
    }

    public static boolean isCustomUDF(ExprNodeGenericFuncDesc expr) {
        String udfName = expr.getFuncText();
        if (udfName == null) {
            return false;
        }
        FunctionInfo funcInfo = FunctionRegistry.getFunctionInfo(udfName);
        if (funcInfo == null) {
            return false;
        }
        boolean isNativeFunc = funcInfo.isNative();
        return !isNativeFunc;
    }

    ExprNodeDesc foldConstantsForUnaryExpression(ExprNodeDesc exprDesc) throws HiveException {
        if (!(exprDesc instanceof ExprNodeGenericFuncDesc)) {
            return exprDesc;
        }
        if (exprDesc.getChildren() == null || exprDesc.getChildren().size() != 1) {
            return exprDesc;
        }
        ExprNodeConstantDesc foldedChild = null;
        if (!(exprDesc.getChildren().get(0) instanceof ExprNodeConstantDesc)) {
            ExprNodeDesc expr = this.foldConstantsForUnaryExpression(exprDesc.getChildren().get(0));
            if (expr instanceof ExprNodeConstantDesc) {
                foldedChild = (ExprNodeConstantDesc)expr;
            }
        } else {
            foldedChild = (ExprNodeConstantDesc)exprDesc.getChildren().get(0);
        }
        if (foldedChild == null) {
            return exprDesc;
        }
        ConstantObjectInspector childoi = foldedChild.getWritableObjectInspector();
        GenericUDF gudf = ((ExprNodeGenericFuncDesc)exprDesc).getGenericUDF();
        if (gudf instanceof GenericUDFOPNegative || gudf instanceof GenericUDFOPPositive || castExpressionUdfs.contains(gudf.getClass()) || gudf instanceof GenericUDFBridge && castExpressionUdfs.contains(((GenericUDFBridge)gudf).getUdfClass())) {
            ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(exprDesc);
            ObjectInspector output = evaluator.initialize((ObjectInspector)childoi);
            Object constant = evaluator.evaluate(null);
            Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
            return new ExprNodeConstantDesc(exprDesc.getTypeInfo(), java);
        }
        return exprDesc;
    }

    private List<ExprNodeDesc> foldConstantsForUnaryExprs(List<ExprNodeDesc> childExpr) throws HiveException {
        ArrayList<ExprNodeDesc> constantFoldedChildren = new ArrayList<ExprNodeDesc>();
        if (childExpr != null) {
            for (ExprNodeDesc expr : childExpr) {
                expr = this.foldConstantsForUnaryExpression(expr);
                constantFoldedChildren.add(expr);
            }
        }
        return constantFoldedChildren;
    }

    private VectorExpression getConstantVectorExpression(Object constantValue, TypeInfo typeInfo, VectorExpressionDescriptor.Mode mode) throws HiveException {
        String type = typeInfo.getTypeName();
        String colVectorType = VectorizationContext.getNormalizedTypeName(type);
        int outCol = -1;
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            outCol = this.ocm.allocateOutputColumn(colVectorType);
        }
        if (decimalTypePattern.matcher(type).matches()) {
            ConstantVectorExpression ve = new ConstantVectorExpression(outCol, (Decimal128)constantValue);
            ((VectorExpression)ve).setOutputType(typeInfo.getTypeName());
            return ve;
        }
        if (type.equalsIgnoreCase("long") || type.equalsIgnoreCase("int") || type.equalsIgnoreCase("short") || type.equalsIgnoreCase("byte")) {
            return new ConstantVectorExpression(outCol, ((Number)constantValue).longValue());
        }
        if (type.equalsIgnoreCase("double") || type.equalsIgnoreCase("float")) {
            return new ConstantVectorExpression(outCol, ((Number)constantValue).doubleValue());
        }
        if (type.equalsIgnoreCase("string")) {
            return new ConstantVectorExpression(outCol, ((String)constantValue).getBytes());
        }
        if (type.equalsIgnoreCase("boolean")) {
            if (mode == VectorExpressionDescriptor.Mode.FILTER) {
                if (((Boolean)constantValue).booleanValue()) {
                    return new FilterConstantBooleanVectorExpression(1L);
                }
                return new FilterConstantBooleanVectorExpression(0L);
            }
            if (((Boolean)constantValue).booleanValue()) {
                return new ConstantVectorExpression(outCol, 1L);
            }
            return new ConstantVectorExpression(outCol, 0L);
        }
        throw new HiveException("Unsupported constant type: " + type.toString());
    }

    private VectorExpression getIdentityExpression(List<ExprNodeDesc> childExprList) throws HiveException {
        String colType;
        int inputCol;
        ExprNodeDesc childExpr = childExprList.get(0);
        VectorExpression v1 = null;
        if (childExpr instanceof ExprNodeGenericFuncDesc) {
            v1 = this.getVectorExpression(childExpr);
            inputCol = v1.getOutputColumn();
            colType = v1.getOutputType();
        } else if (childExpr instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)childExpr;
            inputCol = this.getInputColumnIndex(colDesc.getColumn());
            colType = colDesc.getTypeString();
        } else {
            throw new HiveException("Expression not supported: " + childExpr);
        }
        IdentityExpression expr = new IdentityExpression(inputCol, colType);
        if (v1 != null) {
            expr.setChildExpressions(new VectorExpression[]{v1});
        }
        return expr;
    }

    private VectorExpression getVectorExpressionForUdf(Class<?> udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        int numChildren;
        int n = numChildren = childExpr == null ? 0 : childExpr.size();
        if (numChildren > 3) {
            return null;
        }
        VectorExpressionDescriptor.Builder builder = new VectorExpressionDescriptor.Builder();
        builder.setNumArguments(numChildren);
        builder.setMode(mode);
        for (int i = 0; i < numChildren; ++i) {
            ExprNodeDesc child = childExpr.get(i);
            builder.setArgumentType(i, child.getTypeString());
            if (child instanceof ExprNodeGenericFuncDesc || child instanceof ExprNodeColumnDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.COLUMN);
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.SCALAR);
                continue;
            }
            throw new HiveException("Cannot handle expression type: " + child.getClass().getSimpleName());
        }
        VectorExpressionDescriptor.Descriptor descriptor = builder.build();
        Class<?> vclass = this.vMap.getVectorExpressionClass(udf, descriptor);
        if (vclass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No vector udf found for " + udf.getSimpleName() + ", descriptor: " + descriptor));
            }
            return null;
        }
        VectorExpressionDescriptor.Mode childrenMode = this.getChildrenMode(mode, udf);
        return this.createVectorExpression(vclass, childExpr, childrenMode, returnType);
    }

    private VectorExpression createVectorExpression(Class<?> vectorClass, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode childrenMode, TypeInfo returnType) throws HiveException {
        int numChildren = childExpr == null ? 0 : childExpr.size();
        VectorExpression.Type[] inputTypes = new VectorExpression.Type[numChildren];
        ArrayList<VectorExpression> children = new ArrayList<VectorExpression>();
        Object[] arguments = new Object[numChildren];
        try {
            for (int i = 0; i < numChildren; ++i) {
                ExprNodeDesc child = childExpr.get(i);
                inputTypes[i] = VectorExpression.Type.getValue(child.getTypeInfo().getTypeName());
                if (child instanceof ExprNodeGenericFuncDesc) {
                    VectorExpression vChild = this.getVectorExpression(child, childrenMode);
                    children.add(vChild);
                    arguments[i] = vChild.getOutputColumn();
                    continue;
                }
                if (child instanceof ExprNodeColumnDesc) {
                    int colIndex = this.getInputColumnIndex((ExprNodeColumnDesc)child);
                    if (childrenMode == VectorExpressionDescriptor.Mode.FILTER) {
                        children.add(new SelectColumnIsTrue(colIndex));
                    }
                    arguments[i] = colIndex;
                    continue;
                }
                if (child instanceof ExprNodeConstantDesc) {
                    Object scalarValue;
                    arguments[i] = scalarValue = this.getVectorTypeScalarValue((ExprNodeConstantDesc)child);
                    continue;
                }
                throw new HiveException("Cannot handle expression type: " + child.getClass().getSimpleName());
            }
            VectorExpression vectorExpression = this.instantiateExpression(vectorClass, returnType, arguments);
            vectorExpression.setInputTypes(inputTypes);
            if (vectorExpression != null && !children.isEmpty()) {
                vectorExpression.setChildExpressions(children.toArray(new VectorExpression[0]));
            }
            VectorExpression vectorExpression2 = vectorExpression;
            return vectorExpression2;
        }
        catch (Exception ex) {
            throw new HiveException(ex);
        }
        finally {
            for (VectorExpression ve : children) {
                this.ocm.freeOutputColumn(ve.getOutputColumn());
            }
        }
    }

    private VectorExpressionDescriptor.Mode getChildrenMode(VectorExpressionDescriptor.Mode mode, Class<?> udf) {
        if (mode.equals((Object)VectorExpressionDescriptor.Mode.FILTER) && (udf.equals(GenericUDFOPAnd.class) || udf.equals(GenericUDFOPOr.class))) {
            return VectorExpressionDescriptor.Mode.FILTER;
        }
        return VectorExpressionDescriptor.Mode.PROJECTION;
    }

    private VectorExpression instantiateExpression(Class<?> vclass, TypeInfo returnType, Object ... args) throws HiveException {
        VectorExpression ve = null;
        Constructor<?> ctor = this.getConstructor(vclass);
        int numParams = ctor.getParameterTypes().length;
        int argsLength = args == null ? 0 : args.length;
        try {
            if (numParams == 0) {
                ve = (VectorExpression)ctor.newInstance(new Object[0]);
            } else if (numParams == argsLength) {
                ve = (VectorExpression)ctor.newInstance(args);
            } else if (numParams == argsLength + 1) {
                String outType = returnType != null ? VectorizationContext.getNormalizedTypeName(returnType.getTypeName()).toLowerCase() : ((VectorExpression)vclass.newInstance()).getOutputType();
                int outputCol = this.ocm.allocateOutputColumn(outType);
                Object[] newArgs = Arrays.copyOf(args, numParams);
                newArgs[numParams - 1] = outputCol;
                ve = (VectorExpression)ctor.newInstance(newArgs);
                ve.setOutputType(outType);
            }
        }
        catch (Exception ex) {
            throw new HiveException("Could not instantiate " + vclass.getSimpleName(), ex);
        }
        return ve;
    }

    private VectorExpression getGenericUdfVectorExpression(GenericUDF udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        VectorExpression ve;
        List<ExprNodeDesc> constantFoldedChildren = this.foldConstantsForUnaryExprs(childExpr);
        childExpr = constantFoldedChildren;
        if (udf instanceof GenericUDFBetween) {
            return this.getBetweenFilterExpression(childExpr, mode, returnType);
        }
        if (udf instanceof GenericUDFIn) {
            return this.getInExpression(childExpr, mode, returnType);
        }
        if (udf instanceof GenericUDFOPPositive) {
            return this.getIdentityExpression(childExpr);
        }
        if (udf instanceof GenericUDFCoalesce) {
            return this.getCoalesceExpression(childExpr, returnType);
        }
        if (udf instanceof GenericUDFBridge) {
            VectorExpression v = this.getGenericUDFBridgeVectorExpression((GenericUDFBridge)udf, childExpr, mode, returnType);
            if (v != null) {
                return v;
            }
        } else if (udf instanceof GenericUDFToDecimal) {
            return this.getCastToDecimal(childExpr, returnType);
        }
        Class<Object> udfClass = udf.getClass();
        if (udf instanceof GenericUDFBridge) {
            udfClass = ((GenericUDFBridge)udf).getUdfClass();
        }
        if ((ve = this.getVectorExpressionForUdf(udfClass, constantFoldedChildren, mode, returnType)) == null) {
            throw new HiveException("Udf: " + udf.getClass().getSimpleName() + ", is not supported");
        }
        return ve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VectorExpression getCoalesceExpression(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        int[] inputColumns = new int[childExpr.size()];
        VectorExpression[] vectorChildren = null;
        try {
            vectorChildren = this.getVectorExpressions(childExpr, VectorExpressionDescriptor.Mode.PROJECTION);
            int i = 0;
            for (VectorExpression ve : vectorChildren) {
                inputColumns[i++] = ve.getOutputColumn();
            }
            int outColumn = this.ocm.allocateOutputColumn(VectorizationContext.getNormalizedTypeName(returnType.getTypeName()));
            VectorCoalesce vectorCoalesce = new VectorCoalesce(inputColumns, outColumn);
            vectorCoalesce.setOutputType(returnType.getTypeName());
            vectorCoalesce.setChildExpressions(vectorChildren);
            VectorCoalesce vectorCoalesce2 = vectorCoalesce;
            return vectorCoalesce2;
        }
        finally {
            if (vectorChildren != null) {
                for (VectorExpression v : vectorChildren) {
                    this.ocm.freeOutputColumn(v.getOutputColumn());
                }
            }
        }
    }

    private VectorExpression getInExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        ExprNodeDesc colExpr = childExpr.get(0);
        TypeInfo colTypeInfo = colExpr.getTypeInfo();
        String colType = colExpr.getTypeString();
        List<ExprNodeDesc> childrenForInList = this.foldConstantsForUnaryExprs(childExpr.subList(1, childExpr.size()));
        VectorExpression expr = null;
        Class cl = null;
        if (VectorizationContext.isIntFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            long[] inVals = new long[childrenForInList.size()];
            for (int i = 0; i != inVals.length; ++i) {
                inVals[i] = this.getIntFamilyScalarAsLong((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((ILongInExpr)((Object)expr)).setInListValues(inVals);
        } else if (VectorizationContext.isTimestampFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            long[] inVals = new long[childrenForInList.size()];
            for (int i = 0; i != inVals.length; ++i) {
                inVals[i] = this.getTimestampScalar(childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((ILongInExpr)((Object)expr)).setInListValues(inVals);
        } else if (VectorizationContext.isStringFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterStringColumnInList.class : StringColumnInList.class;
            byte[][] inVals = new byte[childrenForInList.size()][];
            for (int i = 0; i != inVals.length; ++i) {
                inVals[i] = this.getStringScalarAsByteArray((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((IStringInExpr)((Object)expr)).setInListValues(inVals);
        } else if (VectorizationContext.isFloatFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDoubleColumnInList.class : DoubleColumnInList.class;
            double[] inValsD = new double[childrenForInList.size()];
            for (int i = 0; i != inValsD.length; ++i) {
                inValsD[i] = this.getNumericScalarAsDouble(childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((IDoubleInExpr)((Object)expr)).setInListValues(inValsD);
        } else if (VectorizationContext.isDecimalFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDecimalColumnInList.class : DecimalColumnInList.class;
            Decimal128[] inValsD = new Decimal128[childrenForInList.size()];
            for (int i = 0; i != inValsD.length; ++i) {
                inValsD[i] = (Decimal128)this.getVectorTypeScalarValue((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((IDecimalInExpr)((Object)expr)).setInListValues(inValsD);
        } else if (VectorizationContext.isDateFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            long[] inVals = new long[childrenForInList.size()];
            for (int i = 0; i != inVals.length; ++i) {
                inVals[i] = ((Integer)this.getVectorTypeScalarValue((ExprNodeConstantDesc)childrenForInList.get(i))).intValue();
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((ILongInExpr)((Object)expr)).setInListValues(inVals);
        }
        return expr;
    }

    private byte[] getStringScalarAsByteArray(ExprNodeConstantDesc exprNodeConstantDesc) throws HiveException {
        Object o = this.getScalarValue(exprNodeConstantDesc);
        if (!(o instanceof byte[])) {
            throw new HiveException("Expected constant argument of type string");
        }
        return (byte[])o;
    }

    private VectorExpression getGenericUDFBridgeVectorExpression(GenericUDFBridge udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        Class<? extends UDF> cl = udf.getUdfClass();
        if (VectorizationContext.isCastToIntFamily(cl)) {
            return this.getCastToLongExpression(childExpr);
        }
        if (cl.equals(UDFToBoolean.class)) {
            return this.getCastToBoolean(childExpr);
        }
        if (VectorizationContext.isCastToFloatFamily(cl)) {
            return this.getCastToDoubleExpression(cl, childExpr, returnType);
        }
        if (cl.equals(UDFToString.class)) {
            return this.getCastToString(childExpr, returnType);
        }
        return null;
    }

    private VectorExpression getCastToDecimal(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            Decimal128 decimalValue = this.castConstantToDecimal(constantValue, child.getTypeInfo());
            return this.getConstantVectorExpression(decimalValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isFloatFamily(inputType)) {
            return this.createVectorExpression(CastDoubleToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (decimalTypePattern.matcher(inputType).matches()) {
            return this.createVectorExpression(CastDecimalToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDatetimeFamily(inputType)) {
            return this.createVectorExpression(CastTimestampToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        throw new HiveException("Unhandled cast input type: " + inputType);
    }

    private Decimal128 castConstantToDecimal(Object scalar, TypeInfo type) throws HiveException {
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        String typename = type.getTypeName();
        Decimal128 d = new Decimal128();
        int scale = HiveDecimalUtils.getScaleForType((PrimitiveTypeInfo)ptinfo);
        switch (ptinfo.getPrimitiveCategory()) {
            case FLOAT: {
                float floatVal = ((Float)scalar).floatValue();
                d.update((double)floatVal, (short)scale);
                break;
            }
            case DOUBLE: {
                double doubleVal = (Double)scalar;
                d.update(doubleVal, (short)scale);
                break;
            }
            case BYTE: {
                byte byteVal = (Byte)scalar;
                d.update((long)byteVal, (short)scale);
                break;
            }
            case SHORT: {
                short shortVal = (Short)scalar;
                d.update((long)shortVal, (short)scale);
                break;
            }
            case INT: {
                int intVal = (Integer)scalar;
                d.update((long)intVal, (short)scale);
                break;
            }
            case LONG: {
                long longVal = (Long)scalar;
                d.update(longVal, (short)scale);
                break;
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                d.update(decimalVal.unscaledValue(), (short)scale);
                break;
            }
            default: {
                throw new HiveException("Unsupported type " + typename + " for cast to Decimal128");
            }
        }
        return d;
    }

    private VectorExpression getCastToString(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        String inputType = childExpr.get(0).getTypeString();
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToStringViaLongToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, null);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, null);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        throw new HiveException("Unhandled cast input type: " + inputType);
    }

    private VectorExpression getCastToDoubleExpression(Class<?> udf, List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        String inputType = childExpr.get(0).getTypeString();
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (inputType.equals("timestamp")) {
            return this.createVectorExpression(CastTimestampToDoubleViaLongToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isFloatFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getCastToBoolean(List<ExprNodeDesc> childExpr) throws HiveException {
        String inputType = childExpr.get(0).getTypeString();
        if (inputType.equals("string")) {
            VectorExpression lenExpr = this.createVectorExpression(StringLength.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, null);
            int outputCol = this.ocm.allocateOutputColumn("integer");
            CastLongToBooleanViaLongToLong lenToBoolExpr = new CastLongToBooleanViaLongToLong(lenExpr.getOutputColumn(), outputCol);
            lenToBoolExpr.setChildExpressions(new VectorExpression[]{lenExpr});
            this.ocm.freeOutputColumn(lenExpr.getOutputColumn());
            return lenToBoolExpr;
        }
        return null;
    }

    private VectorExpression getCastToLongExpression(List<ExprNodeDesc> childExpr) throws HiveException {
        String inputType = childExpr.get(0).getTypeString();
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getBetweenFilterExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            return null;
        }
        boolean notKeywordPresent = (Boolean)((ExprNodeConstantDesc)childExpr.get(0)).getValue();
        ExprNodeDesc colExpr = childExpr.get(1);
        TypeInfo commonType = FunctionRegistry.getCommonClassForComparison(childExpr.get(1).getTypeInfo(), childExpr.get(2).getTypeInfo());
        if (commonType == null) {
            return null;
        }
        if ((commonType = FunctionRegistry.getCommonClassForComparison(commonType, childExpr.get(3).getTypeInfo())) == null) {
            return null;
        }
        ArrayList<ExprNodeDesc> castChildren = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc desc : childExpr.subList(1, 4)) {
            if (commonType.equals((Object)desc.getTypeInfo())) {
                castChildren.add(desc);
                continue;
            }
            GenericUDF castUdf = this.getGenericUDFForCast(commonType);
            ExprNodeGenericFuncDesc engfd = new ExprNodeGenericFuncDesc(commonType, castUdf, Arrays.asList(desc));
            castChildren.add(engfd);
        }
        String colType = commonType.getTypeName();
        List<ExprNodeDesc> childrenAfterNot = this.foldConstantsForUnaryExprs(castChildren);
        Class cl = null;
        if (VectorizationContext.isIntFamily(colType) && !notKeywordPresent) {
            cl = FilterLongColumnBetween.class;
        } else if (VectorizationContext.isIntFamily(colType) && notKeywordPresent) {
            cl = FilterLongColumnNotBetween.class;
        } else if (VectorizationContext.isFloatFamily(colType) && !notKeywordPresent) {
            cl = FilterDoubleColumnBetween.class;
        } else if (VectorizationContext.isFloatFamily(colType) && notKeywordPresent) {
            cl = FilterDoubleColumnNotBetween.class;
        } else if (colType.equals("string") && !notKeywordPresent) {
            cl = FilterStringColumnBetween.class;
        } else if (colType.equals("string") && notKeywordPresent) {
            cl = FilterStringColumnNotBetween.class;
        } else if (colType.equals("timestamp")) {
            long left = this.getTimestampScalar(childExpr.get(2));
            long right = this.getTimestampScalar(childExpr.get(3));
            childrenAfterNot = new ArrayList<ExprNodeDesc>();
            childrenAfterNot.add(colExpr);
            childrenAfterNot.add(new ExprNodeConstantDesc(left));
            childrenAfterNot.add(new ExprNodeConstantDesc(right));
            cl = notKeywordPresent ? FilterLongColumnNotBetween.class : FilterLongColumnBetween.class;
        } else if (VectorizationContext.isDecimalFamily(colType) && !notKeywordPresent) {
            cl = FilterDecimalColumnBetween.class;
        } else if (VectorizationContext.isDecimalFamily(colType) && notKeywordPresent) {
            cl = FilterDecimalColumnNotBetween.class;
        } else if (VectorizationContext.isDateFamily(colType) && !notKeywordPresent) {
            cl = FilterLongColumnBetween.class;
        } else if (VectorizationContext.isDateFamily(colType) && notKeywordPresent) {
            cl = FilterLongColumnNotBetween.class;
        }
        return this.createVectorExpression(cl, childrenAfterNot, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
    }

    private VectorExpression getCustomUDFExpression(ExprNodeGenericFuncDesc expr) throws HiveException {
        List<ExprNodeDesc> childExprList = expr.getChildren();
        VectorUDFArgDesc[] argDescs = new VectorUDFArgDesc[expr.getChildren().size()];
        for (int i = 0; i < argDescs.length; ++i) {
            argDescs[i] = new VectorUDFArgDesc();
        }
        ArrayList<Integer> variableArgPositions = new ArrayList<Integer>();
        ArrayList<Integer> exprResultColumnNums = new ArrayList<Integer>();
        ArrayList<VectorExpression> vectorExprs = new ArrayList<VectorExpression>();
        for (int i = 0; i < childExprList.size(); ++i) {
            ExprNodeDesc child = childExprList.get(i);
            if (child instanceof ExprNodeGenericFuncDesc) {
                VectorExpression e = this.getVectorExpression(child, VectorExpressionDescriptor.Mode.PROJECTION);
                vectorExprs.add(e);
                variableArgPositions.add(i);
                exprResultColumnNums.add(e.getOutputColumn());
                argDescs[i].setVariable(e.getOutputColumn());
                continue;
            }
            if (child instanceof ExprNodeColumnDesc) {
                variableArgPositions.add(i);
                argDescs[i].setVariable(this.getInputColumnIndex(((ExprNodeColumnDesc)child).getColumn()));
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                argDescs[i].setConstant((ExprNodeConstantDesc)child);
                continue;
            }
            throw new HiveException("Unable to vectorize Custom UDF");
        }
        int outputCol = -1;
        String resultType = expr.getTypeInfo().getTypeName();
        String resultColVectorType = VectorizationContext.getNormalizedTypeName(resultType);
        outputCol = this.ocm.allocateOutputColumn(resultColVectorType);
        VectorUDFAdaptor ve = new VectorUDFAdaptor(expr, outputCol, resultColVectorType, argDescs);
        VectorExpression[] childVEs = null;
        if (exprResultColumnNums.size() != 0) {
            childVEs = new VectorExpression[exprResultColumnNums.size()];
            for (int i = 0; i < childVEs.length; ++i) {
                childVEs[i] = (VectorExpression)vectorExprs.get(i);
            }
        }
        ve.setChildExpressions(childVEs);
        for (Integer i : exprResultColumnNums) {
            this.ocm.freeOutputColumn(i);
        }
        return ve;
    }

    public static boolean isStringFamily(String resultType) {
        return resultType.equalsIgnoreCase("string");
    }

    public static boolean isDatetimeFamily(String resultType) {
        return resultType.equalsIgnoreCase("timestamp") || resultType.equalsIgnoreCase("date");
    }

    public static boolean isTimestampFamily(String resultType) {
        return resultType.equalsIgnoreCase("timestamp");
    }

    public static boolean isDateFamily(String resultType) {
        return resultType.equalsIgnoreCase("date");
    }

    public static boolean isFloatFamily(String resultType) {
        return resultType.equalsIgnoreCase("double") || resultType.equalsIgnoreCase("float");
    }

    public static boolean isIntFamily(String resultType) {
        return resultType.equalsIgnoreCase("tinyint") || resultType.equalsIgnoreCase("smallint") || resultType.equalsIgnoreCase("int") || resultType.equalsIgnoreCase("bigint") || resultType.equalsIgnoreCase("boolean") || resultType.equalsIgnoreCase("long");
    }

    public static boolean isDecimalFamily(String colType) {
        return decimalTypePattern.matcher(colType).matches();
    }

    private Object getScalarValue(ExprNodeConstantDesc constDesc) throws HiveException {
        if (constDesc.getTypeString().equalsIgnoreCase("String")) {
            try {
                byte[] bytes = ((String)constDesc.getValue()).getBytes("UTF-8");
                return bytes;
            }
            catch (Exception ex) {
                throw new HiveException(ex);
            }
        }
        if (constDesc.getTypeString().equalsIgnoreCase("boolean")) {
            if (constDesc.getValue().equals(true)) {
                return 1;
            }
            return 0;
        }
        if (decimalTypePattern.matcher(constDesc.getTypeString()).matches()) {
            HiveDecimal hd = (HiveDecimal)constDesc.getValue();
            Decimal128 dvalue = new Decimal128();
            dvalue.update(hd.unscaledValue(), (short)hd.scale());
            return dvalue;
        }
        return constDesc.getValue();
    }

    private long getIntFamilyScalarAsLong(ExprNodeConstantDesc constDesc) throws HiveException {
        Object o = this.getScalarValue(constDesc);
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new HiveException("Unexpected type when converting to long : " + o.getClass().getSimpleName());
    }

    private double getNumericScalarAsDouble(ExprNodeDesc constDesc) throws HiveException {
        Object o = this.getScalarValue((ExprNodeConstantDesc)constDesc);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        throw new HiveException("Unexpected type when converting to double");
    }

    private Object getVectorTypeScalarValue(ExprNodeConstantDesc constDesc) throws HiveException {
        String t = constDesc.getTypeInfo().getTypeName();
        if (VectorizationContext.isTimestampFamily(t)) {
            return TimestampUtils.getTimeNanoSec((Timestamp)this.getScalarValue(constDesc));
        }
        if (VectorizationContext.isDateFamily(t)) {
            return DateWritable.dateToDays((Date)((Date)this.getScalarValue(constDesc)));
        }
        return this.getScalarValue(constDesc);
    }

    private long getTimestampScalar(ExprNodeDesc expr) throws HiveException {
        if (expr instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)expr).getGenericUDF() instanceof GenericUDFTimestamp) {
            return this.evaluateCastToTimestamp(expr);
        }
        if (!(expr instanceof ExprNodeConstantDesc)) {
            throw new HiveException("Constant timestamp value expected for expression argument. Non-constant argument not supported for vectorization.");
        }
        ExprNodeConstantDesc constExpr = (ExprNodeConstantDesc)expr;
        if (constExpr.getTypeString().equals("string")) {
            ExprNodeGenericFuncDesc expr2 = new ExprNodeGenericFuncDesc();
            GenericUDFTimestamp f = new GenericUDFTimestamp();
            expr2.setGenericUDF(f);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(expr);
            expr2.setChildren(children);
            return this.evaluateCastToTimestamp(expr2);
        }
        throw new HiveException("Udf: unhandled constant type for scalar argument. Expecting string.");
    }

    private long evaluateCastToTimestamp(ExprNodeDesc expr) throws HiveException {
        ExprNodeGenericFuncDesc expr2 = (ExprNodeGenericFuncDesc)expr;
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr2);
        ObjectInspector output = evaluator.initialize(null);
        Object constant = evaluator.evaluate(null);
        Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
        if (!(java instanceof Timestamp)) {
            throw new HiveException("Udf: failed to convert to timestamp");
        }
        Timestamp ts = (Timestamp)java;
        return TimestampUtils.getTimeNanoSec(ts);
    }

    private Constructor<?> getConstructor(Class<?> cl) throws HiveException {
        try {
            Constructor<?>[] ctors = cl.getDeclaredConstructors();
            if (ctors.length == 1) {
                return ctors[0];
            }
            Constructor<?> defaultCtor = cl.getConstructor(new Class[0]);
            for (Constructor<?> ctor : ctors) {
                if (ctor.equals(defaultCtor)) continue;
                return ctor;
            }
            throw new HiveException("Only default constructor found");
        }
        catch (Exception ex) {
            throw new HiveException(ex);
        }
    }

    static String getNormalizedTypeName(String colType) {
        String normalizedType = null;
        normalizedType = colType.equalsIgnoreCase("Double") || colType.equalsIgnoreCase("Float") ? "Double" : (colType.equalsIgnoreCase("String") ? "String" : (decimalTypePattern.matcher(colType).matches() ? colType : "Long"));
        return normalizedType;
    }

    public VectorAggregateExpression getAggregatorExpression(AggregationDesc desc) throws HiveException {
        ExprNodeDesc inputExpr;
        ArrayList<ExprNodeDesc> paramDescList = desc.getParameters();
        VectorExpression[] vectorParams = new VectorExpression[paramDescList.size()];
        for (int i = 0; i < paramDescList.size(); ++i) {
            ExprNodeDesc exprDesc = paramDescList.get(i);
            vectorParams[i] = this.getVectorExpression(exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        String aggregateName = desc.getGenericUDAFName();
        String inputType = null;
        if (paramDescList.size() > 0 && decimalTypePattern.matcher(inputType = VectorizationContext.getNormalizedTypeName((inputExpr = paramDescList.get(0)).getTypeString())).matches()) {
            inputType = "Decimal";
        }
        for (Object[] aggDef : aggregatesDefinition) {
            if (!aggregateName.equalsIgnoreCase((String)aggDef[0]) || (aggDef[1] != null || inputType != null) && (aggDef[1] == null || !aggDef[1].equals(inputType))) continue;
            Class aggClass = (Class)aggDef[2];
            try {
                Constructor ctor = aggClass.getConstructor(VectorExpression.class);
                VectorAggregateExpression aggExpr = (VectorAggregateExpression)ctor.newInstance(vectorParams.length > 0 ? vectorParams[0] : null);
                aggExpr.init(desc);
                return aggExpr;
            }
            catch (Exception e) {
                throw new HiveException("Internal exception for vector aggregate : \"" + aggregateName + "\" for type: \"" + inputType + "", e);
            }
        }
        throw new HiveException("Vector aggregate not implemented: \"" + aggregateName + "\" for type: \"" + inputType + "");
    }

    public Map<Integer, String> getOutputColumnTypeMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < this.ocm.outputColCount; ++i) {
            String type = this.ocm.outputColumnsTypes[i];
            map.put(i + this.firstOutputColumnIndex, type);
        }
        return map;
    }

    public Map<String, Integer> getColumnMap() {
        return this.columnMap;
    }

    public void addToColumnMap(String columnName, int outputColumn) throws HiveException {
        if (this.columnMap.containsKey(columnName) && this.columnMap.get(columnName) != outputColumn) {
            throw new HiveException(String.format("Column %s is already mapped to %d. Cannot remap to %d.", columnName, this.columnMap.get(columnName), outputColumn));
        }
        this.columnMap.put(columnName, outputColumn);
    }

    static {
        castExpressionUdfs.add(GenericUDFToDecimal.class);
        castExpressionUdfs.add(GenericUDFToBinary.class);
        castExpressionUdfs.add(GenericUDFToDate.class);
        castExpressionUdfs.add(GenericUDFToUnixTimeStamp.class);
        castExpressionUdfs.add(GenericUDFToUtcTimestamp.class);
        castExpressionUdfs.add(GenericUDFToChar.class);
        castExpressionUdfs.add(GenericUDFToVarchar.class);
        castExpressionUdfs.add(GenericUDFTimestamp.class);
        castExpressionUdfs.add(UDFToByte.class);
        castExpressionUdfs.add(UDFToBoolean.class);
        castExpressionUdfs.add(UDFToDouble.class);
        castExpressionUdfs.add(UDFToFloat.class);
        castExpressionUdfs.add(UDFToString.class);
        castExpressionUdfs.add(UDFToInteger.class);
        castExpressionUdfs.add(UDFToLong.class);
        castExpressionUdfs.add(UDFToShort.class);
        aggregatesDefinition = new Object[][]{{"min", "Long", VectorUDAFMinLong.class}, {"min", "Double", VectorUDAFMinDouble.class}, {"min", "String", VectorUDAFMinString.class}, {"min", "Decimal", VectorUDAFMinDecimal.class}, {"max", "Long", VectorUDAFMaxLong.class}, {"max", "Double", VectorUDAFMaxDouble.class}, {"max", "String", VectorUDAFMaxString.class}, {"max", "Decimal", VectorUDAFMaxDecimal.class}, {"count", null, VectorUDAFCountStar.class}, {"count", "Long", VectorUDAFCount.class}, {"count", "Double", VectorUDAFCount.class}, {"count", "String", VectorUDAFCount.class}, {"count", "Decimal", VectorUDAFCount.class}, {"sum", "Long", VectorUDAFSumLong.class}, {"sum", "Double", VectorUDAFSumDouble.class}, {"sum", "Decimal", VectorUDAFSumDecimal.class}, {"avg", "Long", VectorUDAFAvgLong.class}, {"avg", "Double", VectorUDAFAvgDouble.class}, {"avg", "Decimal", VectorUDAFAvgDecimal.class}, {"variance", "Long", VectorUDAFVarPopLong.class}, {"var_pop", "Long", VectorUDAFVarPopLong.class}, {"variance", "Double", VectorUDAFVarPopDouble.class}, {"var_pop", "Double", VectorUDAFVarPopDouble.class}, {"variance", "Decimal", VectorUDAFVarPopDecimal.class}, {"var_pop", "Decimal", VectorUDAFVarPopDecimal.class}, {"var_samp", "Long", VectorUDAFVarSampLong.class}, {"var_samp", "Double", VectorUDAFVarSampDouble.class}, {"var_samp", "Decimal", VectorUDAFVarSampDecimal.class}, {"std", "Long", VectorUDAFStdPopLong.class}, {"stddev", "Long", VectorUDAFStdPopLong.class}, {"stddev_pop", "Long", VectorUDAFStdPopLong.class}, {"std", "Double", VectorUDAFStdPopDouble.class}, {"stddev", "Double", VectorUDAFStdPopDouble.class}, {"stddev_pop", "Double", VectorUDAFStdPopDouble.class}, {"std", "Decimal", VectorUDAFStdPopDecimal.class}, {"stddev", "Decimal", VectorUDAFStdPopDecimal.class}, {"stddev_pop", "Decimal", VectorUDAFStdPopDecimal.class}, {"stddev_samp", "Long", VectorUDAFStdSampLong.class}, {"stddev_samp", "Double", VectorUDAFStdSampDouble.class}, {"stddev_samp", "Decimal", VectorUDAFStdSampDecimal.class}};
    }

    private static class OutputColumnManager {
        private final int initialOutputCol;
        private int outputColCount = 0;
        private String[] outputColumnsTypes = new String[100];
        private final Set<Integer> usedOutputColumns = new HashSet<Integer>();

        protected OutputColumnManager(int initialOutputCol) {
            this.initialOutputCol = initialOutputCol;
        }

        int allocateOutputColumn(String columnType) {
            if (this.initialOutputCol < 0) {
                return 0;
            }
            int relativeCol = this.allocateOutputColumnInternal(columnType);
            return this.initialOutputCol + relativeCol;
        }

        private int allocateOutputColumnInternal(String columnType) {
            int newIndex;
            for (int i = 0; i < this.outputColCount; ++i) {
                if (this.usedOutputColumns.contains(i) || !this.outputColumnsTypes[i].equalsIgnoreCase(columnType)) continue;
                this.usedOutputColumns.add(i);
                return i;
            }
            if (this.outputColCount < this.outputColumnsTypes.length) {
                newIndex = this.outputColCount;
                this.outputColumnsTypes[this.outputColCount++] = columnType;
                this.usedOutputColumns.add(newIndex);
                return newIndex;
            }
            this.outputColumnsTypes = Arrays.copyOf(this.outputColumnsTypes, 2 * this.outputColCount);
            newIndex = this.outputColCount;
            this.outputColumnsTypes[this.outputColCount++] = columnType;
            this.usedOutputColumns.add(newIndex);
            return newIndex;
        }

        void freeOutputColumn(int index) {
            if (this.initialOutputCol < 0) {
                return;
            }
            int colIndex = index - this.initialOutputCol;
            if (colIndex >= 0) {
                this.usedOutputColumns.remove(index - this.initialOutputCol);
            }
        }
    }
}

