/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class VectorizedBatchUtil {
    public static void setNullColIsNullValue(ColumnVector cv, int rowIndex) {
        cv.isNull[rowIndex] = true;
        if (cv.noNulls) {
            cv.noNulls = false;
        }
    }

    public static void setNoNullFields(VectorizedRowBatch batch) {
        for (int i = 0; i < batch.numCols; ++i) {
            batch.cols[i].noNulls = true;
        }
    }

    public static void addRowToBatch(Object row, StructObjectInspector oi, int rowIndex, VectorizedRowBatch batch, DataOutputBuffer buffer) throws HiveException {
        List fieldRefs = oi.getAllStructFieldRefs();
        block15: for (int i = 0; i < fieldRefs.size(); ++i) {
            Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
            ObjectInspector foi = ((StructField)fieldRefs.get(i)).getFieldObjectInspector();
            assert (foi.getCategory() == ObjectInspector.Category.PRIMITIVE);
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)foi;
            Object writableCol = poi.getPrimitiveWritableObject(fieldData);
            switch (poi.getPrimitiveCategory()) {
                case BOOLEAN: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        lcv.vector[rowIndex] = ((BooleanWritable)writableCol).get() ? 1L : 0L;
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case BYTE: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        lcv.vector[rowIndex] = ((ByteWritable)writableCol).get();
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case SHORT: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        lcv.vector[rowIndex] = ((ShortWritable)writableCol).get();
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case INT: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        lcv.vector[rowIndex] = ((IntWritable)writableCol).get();
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case LONG: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        lcv.vector[rowIndex] = ((LongWritable)writableCol).get();
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case DATE: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        lcv.vector[rowIndex] = ((DateWritable)writableCol).getDays();
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case FLOAT: {
                    ColumnVector dcv = (DoubleColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        dcv.vector[rowIndex] = ((FloatWritable)writableCol).get();
                        dcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    dcv.vector[rowIndex] = Double.NaN;
                    VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                    continue block15;
                }
                case DOUBLE: {
                    ColumnVector dcv = (DoubleColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        dcv.vector[rowIndex] = ((DoubleWritable)writableCol).get();
                        dcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    dcv.vector[rowIndex] = Double.NaN;
                    VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                    continue block15;
                }
                case TIMESTAMP: {
                    LongColumnVector lcv = (LongColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        Timestamp t = ((TimestampWritable)writableCol).getTimestamp();
                        lcv.vector[rowIndex] = TimestampUtils.getTimeNanoSec(t);
                        lcv.isNull[rowIndex] = false;
                        continue block15;
                    }
                    lcv.vector[rowIndex] = 1L;
                    VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                    continue block15;
                }
                case STRING: {
                    BytesColumnVector bcv = (BytesColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        bcv.isNull[rowIndex] = false;
                        Text colText = (Text)writableCol;
                        int start = buffer.getLength();
                        int length = colText.getLength();
                        try {
                            buffer.write(colText.getBytes(), 0, length);
                        }
                        catch (IOException ioe) {
                            throw new IllegalStateException("bad write", ioe);
                        }
                        bcv.setRef(rowIndex, buffer.getData(), start, length);
                        continue block15;
                    }
                    VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                    continue block15;
                }
                case DECIMAL: {
                    ColumnVector dcv = (DecimalColumnVector)batch.cols[i];
                    if (writableCol != null) {
                        ((DecimalColumnVector)dcv).isNull[rowIndex] = false;
                        HiveDecimalWritable wobj = (HiveDecimalWritable)writableCol;
                        ((DecimalColumnVector)dcv).vector[rowIndex].update(wobj.getHiveDecimal().unscaledValue(), (short)wobj.getScale());
                        continue block15;
                    }
                    VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                    continue block15;
                }
                default: {
                    throw new HiveException("Vectorizaton is not supported for datatype:" + poi.getPrimitiveCategory());
                }
            }
        }
    }
}

