/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class ColAndCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public ColAndCol(int colNum1, int colNum2, int outputColumn) {
        this();
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public ColAndCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        int i;
        int i2;
        int j;
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        if (inputColVector1.noNulls && !inputColVector2.noNulls) {
            outV.noNulls = false;
            if (inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (j = 0; j != n; ++j) {
                    i2 = sel[j];
                    outV.isNull[i2] = inputColVector2.isNull[i2];
                }
            } else {
                for (i = 0; i != n; ++i) {
                    outV.isNull[i] = inputColVector2.isNull[i];
                }
            }
        } else if (!inputColVector1.noNulls && inputColVector2.noNulls) {
            outV.noNulls = false;
            if (inputColVector1.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (j = 0; j != n; ++j) {
                    i2 = sel[j];
                    outV.isNull[i2] = inputColVector1.isNull[i2];
                }
            } else {
                for (i = 0; i != n; ++i) {
                    outV.isNull[i] = inputColVector1.isNull[i];
                }
            }
        } else if (!inputColVector1.noNulls && !inputColVector2.noNulls) {
            outV.noNulls = false;
            if (inputColVector1.isRepeating || inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (j = 0; j != n; ++j) {
                    i2 = sel[j];
                    outV.isNull[i2] = inputColVector1.isNull[i2] && inputColVector2.isNull[i2];
                }
            } else {
                for (i = 0; i != n; ++i) {
                    outV.isNull[i] = inputColVector1.isNull[i] && inputColVector2.isNull[i];
                }
            }
        }
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outV.isRepeating = true;
            outputVector[0] = vector1[0] & vector2[0];
        } else if (batch.selectedInUse) {
            for (j = 0; j != n; ++j) {
                i2 = sel[j];
                outputVector[i2] = vector1[i2] & vector2[i2];
            }
        } else {
            for (i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] & vector2[i];
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

