/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.HashSet;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDecimalInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class DecimalColumnInList
extends VectorExpression
implements IDecimalInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private Decimal128[] inListValues;
    private int outputColumn;
    private transient HashSet<Decimal128> inSet;

    public DecimalColumnInList() {
        this.inSet = null;
    }

    public DecimalColumnInList(int colNum, int outputColumn) {
        this.inputCol = colNum;
        this.outputColumn = outputColumn;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new HashSet(this.inListValues.length);
            for (Decimal128 val : this.inListValues) {
                this.inSet.add(val);
            }
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.inputCol];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        boolean[] outNulls = outputColVector.isNull;
        int n = batch.size;
        Decimal128[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        outputColVector.noNulls = inputColVector.noNulls;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.inSet.contains(vector[0]) ? 1L : 0L;
                outputColVector.isRepeating = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.inSet.contains(vector[0]) ? 1L : 0L;
                outNulls[0] = false;
            } else {
                outNulls[0] = true;
            }
            outputColVector.isRepeating = true;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outNulls[i] = nullPos[i];
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
            }
        } else {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    public Decimal128[] getInListValues() {
        return this.inListValues;
    }

    @Override
    public void setInListValues(Decimal128[] a) {
        this.inListValues = a;
    }
}

