/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetDoubleArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToDouble;

public class FuncLogWithBaseLongToDouble
extends MathFuncLongToDouble
implements ISetDoubleArg {
    private static final long serialVersionUID = 1L;
    private double base;

    public FuncLogWithBaseLongToDouble(double scalarVal, int colNum, int outputColumn) {
        super(colNum, outputColumn);
        this.base = scalarVal;
    }

    public FuncLogWithBaseLongToDouble() {
    }

    @Override
    protected double func(long l) {
        return Math.log(l) / Math.log(this.base);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
    }

    @Override
    public void setArg(double d) {
        this.base = d;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DOUBLE, VectorExpressionDescriptor.ArgumentType.LONG).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

