/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetDoubleArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;

public class FuncPowerDoubleToDouble
extends MathFuncDoubleToDouble
implements ISetDoubleArg {
    private static final long serialVersionUID = 1L;
    private double power;

    public FuncPowerDoubleToDouble(int colNum, double power, int outputColumn) {
        super(colNum, outputColumn);
        this.power = power;
    }

    public FuncPowerDoubleToDouble() {
    }

    @Override
    public double func(double d) {
        return Math.pow(d, this.power);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public void setArg(double d) {
        this.power = d;
    }

    @Override
    protected void cleanup(DoubleColumnVector outputColVector, int[] sel, boolean selectedInUse, int n) {
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DOUBLE, VectorExpressionDescriptor.ArgumentType.DOUBLE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }
}

