/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FuncRoundWithNumDigitsDecimalToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private int decimalPlaces;

    public FuncRoundWithNumDigitsDecimalToDecimal(int colNum, int scalarValue, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.decimalPlaces = scalarValue;
        this.outputType = "decimal";
    }

    public FuncRoundWithNumDigitsDecimalToDecimal() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.colNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        int n = batch.size;
        Decimal128[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.isRepeating) {
            outputIsNull[0] = inputIsNull[0];
            DecimalUtil.round(0, vector[0], outputColVector);
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    DecimalUtil.round(i, vector[i], outputColVector);
                }
            } else {
                Arrays.fill(outputIsNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.round(i, vector[i], outputColVector);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    DecimalUtil.round(i, vector[i], outputColVector);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.round(i, vector[i], outputColVector);
                }
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL, VectorExpressionDescriptor.ArgumentType.LONG).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

