/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IfExprStringScalarStringColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg3Column;
    private byte[] arg2Scalar;
    private int outputColumn;

    public IfExprStringScalarStringColumn(int arg1Column, byte[] arg2Scalar, int arg3Column, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Column = arg3Column;
        this.outputColumn = outputColumn;
    }

    public IfExprStringScalarStringColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        BytesColumnVector arg3ColVector = (BytesColumnVector)batch.cols[this.arg3Column];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = arg3ColVector.noNulls;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        if (arg1ColVector.isRepeating) {
            if (vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    } else if (!arg3ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    } else if (!arg3ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                } else if (!arg3ColVector.isNull[i]) {
                    outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                } else if (!arg3ColVector.isNull[i]) {
                    outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "String";
    }

    public int getArg1Column() {
        return this.arg1Column;
    }

    public void setArg1Column(int colNum) {
        this.arg1Column = colNum;
    }

    public byte[] getArg2Scalar() {
        return this.arg2Scalar;
    }

    public void setArg2Scalar(byte[] value) {
        this.arg2Scalar = value;
    }

    public int getArg3Column() {
        return this.arg3Column;
    }

    public void setArg3Column(int colNum) {
        this.arg3Column = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("string"), VectorExpressionDescriptor.ArgumentType.getType("string")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

