/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;

public class EnforceReadOnlyTables
implements ExecuteWithHookContext {
    private static final Set<String> READ_ONLY_TABLES = new HashSet<String>();

    @Override
    public void run(HookContext hookContext) throws Exception {
        SessionState ss = SessionState.get();
        Set<ReadEntity> inputs = hookContext.getInputs();
        Set<WriteEntity> outputs = hookContext.getOutputs();
        UserGroupInformation ugi = hookContext.getUgi();
        this.run(ss, inputs, outputs, ugi);
    }

    public void run(SessionState sess, Set<ReadEntity> inputs, Set<WriteEntity> outputs, UserGroupInformation ugi) throws Exception {
        if (sess.getConf().getBoolean("hive.test.init.phase", false)) {
            return;
        }
        for (WriteEntity w : outputs) {
            Table t;
            if (w.getTyp() != Entity.Type.TABLE && w.getTyp() != Entity.Type.PARTITION || !"default".equalsIgnoreCase((t = w.getTable()).getDbName()) || !READ_ONLY_TABLES.contains(t.getTableName())) continue;
            throw new RuntimeException("Cannot overwrite read-only table: " + t.getTableName());
        }
    }

    static {
        for (String srcTable : System.getProperty("test.src.tables", "").trim().split(",")) {
            if ((srcTable = srcTable.trim()).isEmpty()) continue;
            READ_ONLY_TABLES.add(srcTable);
        }
        if (READ_ONLY_TABLES.isEmpty()) {
            throw new AssertionError((Object)"Source tables cannot be empty");
        }
    }
}

