/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ReadEntity
extends Entity
implements Serializable {
    private boolean isDirect = true;
    private final Set<ReadEntity> parents = new HashSet<ReadEntity>();

    public ReadEntity() {
    }

    public ReadEntity(Database database) {
        super(database, true);
    }

    public ReadEntity(Table t) {
        super(t, true);
    }

    private void initParent(ReadEntity parent) {
        if (parent != null) {
            this.parents.add(parent);
        }
    }

    public ReadEntity(Table t, ReadEntity parent) {
        super(t, true);
        this.initParent(parent);
    }

    public ReadEntity(Table t, ReadEntity parent, boolean isDirect) {
        this(t, parent);
        this.isDirect = isDirect;
    }

    public ReadEntity(Partition p) {
        super(p, true);
    }

    public ReadEntity(Partition p, ReadEntity parent) {
        super(p, true);
        this.initParent(parent);
    }

    public ReadEntity(Partition p, ReadEntity parent, boolean isDirect) {
        this(p, parent);
        this.isDirect = isDirect;
    }

    public ReadEntity(Path d, boolean islocal) {
        super(d.toString(), islocal, true);
    }

    public Set<ReadEntity> getParents() {
        return this.parents;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ReadEntity) {
            ReadEntity ore = (ReadEntity)o;
            return this.toString().equalsIgnoreCase(ore.toString());
        }
        return false;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setDirect(boolean isDirect) {
        this.isDirect = isDirect;
    }
}

