/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index.bitmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.HiveIndexQueryContext;
import org.apache.hadoop.hive.ql.index.HiveIndexedInputFormat;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.index.TableBasedIndexHandler;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapInnerQuery;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapOuterQuery;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapQuery;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;

public class BitmapIndexHandler
extends TableBasedIndexHandler {
    private Configuration configuration;
    private static final Log LOG = LogFactory.getLog((String)BitmapIndexHandler.class.getName());

    @Override
    public void generateIndexQuery(List<Index> indexes, ExprNodeDesc predicate, ParseContext pctx, HiveIndexQueryContext queryContext) {
        Map<Index, ExprNodeDesc> indexPredicates = this.decomposePredicate(predicate, indexes, queryContext);
        if (indexPredicates == null) {
            LOG.info((Object)"No decomposed predicate found");
            queryContext.setQueryTasks(null);
            return;
        }
        ArrayList<BitmapInnerQuery> iqs = new ArrayList<BitmapInnerQuery>(indexes.size());
        int i = 0;
        for (Index index : indexes) {
            ExprNodeDesc indexPredicate = indexPredicates.get(index);
            if (indexPredicate == null) continue;
            iqs.add(new BitmapInnerQuery(index.getIndexTableName(), indexPredicate, "ind" + i++));
        }
        queryContext.setIndexInputFormat(HiveIndexedInputFormat.class.getName());
        StringBuilder qlCommand = new StringBuilder("INSERT OVERWRITE DIRECTORY ");
        String tmpFile = pctx.getContext().getMRTmpPath().toUri().toString();
        qlCommand.append("\"" + tmpFile + "\" ");
        qlCommand.append("SELECT bucketname AS `_bucketname` , COLLECT_SET(offset) AS `_offsets` FROM ");
        qlCommand.append("(SELECT `_bucketname` AS bucketname , `_offset` AS offset FROM ");
        BitmapQuery head = (BitmapQuery)iqs.get(0);
        for (i = 1; i < iqs.size(); ++i) {
            head = new BitmapOuterQuery("oind" + i, head, (BitmapQuery)iqs.get(i));
        }
        qlCommand.append(((Object)head).toString());
        qlCommand.append(" WHERE NOT EWAH_BITMAP_EMPTY(" + head.getAlias() + ".`_bitmaps`) ) tmp_index GROUP BY bucketname");
        LOG.info((Object)("Generating tasks for re-entrant QL query: " + qlCommand.toString()));
        HiveConf queryConf = new HiveConf((Configuration)pctx.getConf(), BitmapIndexHandler.class);
        HiveConf.setBoolVar((Configuration)queryConf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT, (boolean)false);
        Driver driver = new Driver(queryConf);
        driver.compile(qlCommand.toString(), false);
        queryContext.setIndexIntermediateFile(tmpFile);
        queryContext.addAdditionalSemanticInputs(driver.getPlan().getInputs());
        queryContext.setQueryTasks(driver.getPlan().getRootTasks());
    }

    private Map<Index, ExprNodeDesc> decomposePredicate(ExprNodeDesc predicate, List<Index> indexes, HiveIndexQueryContext queryContext) {
        HashMap<Index, ExprNodeDesc> indexPredicates = new HashMap<Index, ExprNodeDesc>();
        IndexPredicateAnalyzer analyzer = this.getIndexPredicateAnalyzer(indexes, queryContext.getQueryPartitions());
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>();
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate(predicate, searchConditions);
        queryContext.setResidualPredicate(residualPredicate);
        if (searchConditions.size() == 0) {
            return null;
        }
        for (Index index : indexes) {
            ArrayList<Index> in = new ArrayList<Index>(1);
            in.add(index);
            analyzer = this.getIndexPredicateAnalyzer(in, queryContext.getQueryPartitions());
            searchConditions = new ArrayList();
            analyzer.analyzePredicate(predicate, searchConditions);
            if (searchConditions.size() == 0) {
                indexPredicates.put(index, null);
                continue;
            }
            indexPredicates.put(index, analyzer.translateSearchConditions(searchConditions));
        }
        return indexPredicates;
    }

    private IndexPredicateAnalyzer getIndexPredicateAnalyzer(List<Index> indexes, Set<Partition> queryPartitions) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp(GenericUDFOPEqual.class.getName());
        analyzer.addComparisonOp(GenericUDFOPLessThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualOrLessThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPGreaterThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualOrGreaterThan.class.getName());
        for (Index index : indexes) {
            List columnSchemas = index.getSd().getCols();
            for (FieldSchema column : columnSchemas) {
                analyzer.allowColumnName(column.getName());
            }
        }
        for (Partition part : queryPartitions) {
            if (part.getSpec().isEmpty()) continue;
            for (String column : part.getSpec().keySet()) {
                analyzer.allowColumnName(column);
            }
        }
        return analyzer;
    }

    @Override
    public void analyzeIndexDefinition(Table baseTable, Index index, Table indexTable) throws HiveException {
        StorageDescriptor storageDesc = index.getSd();
        if (this.usesIndexTable() && indexTable != null) {
            StorageDescriptor indexTableSd = storageDesc.deepCopy();
            List indexTblCols = indexTableSd.getCols();
            FieldSchema bucketFileName = new FieldSchema("_bucketname", "string", "");
            indexTblCols.add(bucketFileName);
            FieldSchema offSets = new FieldSchema("_offset", "bigint", "");
            indexTblCols.add(offSets);
            FieldSchema bitmaps = new FieldSchema("_bitmaps", "array<bigint>", "");
            indexTblCols.add(bitmaps);
            indexTable.setSd(indexTableSd);
        }
    }

    @Override
    protected Task<?> getIndexBuilderMapRedTask(Set<ReadEntity> inputs, Set<WriteEntity> outputs, List<FieldSchema> indexField, boolean partitioned, PartitionDesc indexTblPartDesc, String indexTableName, PartitionDesc baseTablePartDesc, String baseTableName, String dbName) throws HiveException {
        HiveConf builderConf = new HiveConf(this.getConf(), BitmapIndexHandler.class);
        HiveConf.setBoolVar((Configuration)builderConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEROWOFFSET, (boolean)true);
        String indexCols = HiveUtils.getUnparsedColumnNamesFromFieldSchema(indexField);
        StringBuilder command = new StringBuilder();
        LinkedHashMap<String, String> partSpec = indexTblPartDesc.getPartSpec();
        command.append("INSERT OVERWRITE TABLE " + HiveUtils.unparseIdentifier(indexTableName));
        if (partitioned && indexTblPartDesc != null) {
            command.append(" PARTITION ( ");
            List<String> ret = this.getPartKVPairStringArray(partSpec);
            for (int i = 0; i < ret.size(); ++i) {
                String partKV = ret.get(i);
                command.append(partKV);
                if (i >= ret.size() - 1) continue;
                command.append(",");
            }
            command.append(" ) ");
        }
        command.append(" SELECT ");
        command.append(indexCols);
        command.append(",");
        command.append(VirtualColumn.FILENAME.getName());
        command.append(",");
        command.append(VirtualColumn.BLOCKOFFSET.getName());
        command.append(",");
        command.append("EWAH_BITMAP(");
        command.append(VirtualColumn.ROWOFFSET.getName());
        command.append(")");
        command.append(" FROM " + HiveUtils.unparseIdentifier(baseTableName));
        LinkedHashMap<String, String> basePartSpec = baseTablePartDesc.getPartSpec();
        if (basePartSpec != null) {
            command.append(" WHERE ");
            List<String> pkv = this.getPartKVPairStringArray(basePartSpec);
            for (int i = 0; i < pkv.size(); ++i) {
                String partKV = pkv.get(i);
                command.append(partKV);
                if (i >= pkv.size() - 1) continue;
                command.append(" AND ");
            }
        }
        command.append(" GROUP BY ");
        command.append(VirtualColumn.FILENAME.getName());
        command.append(",");
        command.append(VirtualColumn.BLOCKOFFSET.getName());
        for (FieldSchema fieldSchema : indexField) {
            command.append(",");
            command.append(HiveUtils.unparseIdentifier(fieldSchema.getName()));
        }
        if (!builderConf.get("hive.map.aggr", null).equals("true")) {
            throw new HiveException("Cannot construct index without map-side aggregation");
        }
        Task<?> rootTask = IndexUtils.createRootTask(builderConf, inputs, outputs, command, partSpec, indexTableName, dbName);
        super.setStatsDir(builderConf);
        return rootTask;
    }

    @Override
    public boolean checkQuerySize(long querySize, HiveConf hiveConf) {
        return true;
    }

    @Override
    public boolean usesIndexTable() {
        return true;
    }
}

