/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import org.apache.hadoop.hive.ql.io.orc.IntegerWriter;
import org.apache.hadoop.hive.ql.io.orc.PositionRecorder;
import org.apache.hadoop.hive.ql.io.orc.PositionedOutputStream;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;

class RunLengthIntegerWriterV2
implements IntegerWriter {
    static final int MAX_SCOPE = 512;
    static final int MIN_REPEAT = 3;
    private static final int MAX_SHORT_REPEAT_LENGTH = 10;
    private long prevDelta = 0L;
    private int fixedRunLength = 0;
    private int variableRunLength = 0;
    private final long[] literals = new long[512];
    private final PositionedOutputStream output;
    private final boolean signed;
    private EncodingType encoding;
    private int numLiterals;
    private long[] zigzagLiterals;
    private long[] baseRedLiterals;
    private long[] adjDeltas;
    private long fixedDelta;
    private int zzBits90p;
    private int zzBits100p;
    private int brBits95p;
    private int brBits100p;
    private int bitsDeltaMax;
    private int patchWidth;
    private int patchGapWidth;
    private int patchLength;
    private long[] gapVsPatchList;
    private long min;
    private boolean isFixedDelta;

    RunLengthIntegerWriterV2(PositionedOutputStream output, boolean signed) {
        this.output = output;
        this.signed = signed;
        this.clear();
    }

    private void writeValues() throws IOException {
        if (this.numLiterals != 0) {
            if (this.encoding.equals((Object)EncodingType.SHORT_REPEAT)) {
                this.writeShortRepeatValues();
            } else if (this.encoding.equals((Object)EncodingType.DIRECT)) {
                this.writeDirectValues();
            } else if (this.encoding.equals((Object)EncodingType.PATCHED_BASE)) {
                this.writePatchedBaseValues();
            } else {
                this.writeDeltaValues();
            }
            this.clear();
        }
    }

    private void writeDeltaValues() throws IOException {
        int len = 0;
        int fb = this.bitsDeltaMax;
        int efb = 0;
        if (this.isFixedDelta) {
            if (this.fixedRunLength > 3) {
                len = this.fixedRunLength - 1;
                this.fixedRunLength = 0;
            } else {
                len = this.variableRunLength - 1;
                this.variableRunLength = 0;
            }
        } else {
            if (fb == 1) {
                fb = 2;
            }
            efb = SerializationUtils.encodeBitWidth(fb);
            efb <<= 1;
            len = this.variableRunLength - 1;
            this.variableRunLength = 0;
        }
        int tailBits = (len & 0x100) >>> 8;
        int headerFirstByte = this.getOpcode() | efb | tailBits;
        int headerSecondByte = len & 0xFF;
        this.output.write(headerFirstByte);
        this.output.write(headerSecondByte);
        if (this.signed) {
            SerializationUtils.writeVslong(this.output, this.literals[0]);
        } else {
            SerializationUtils.writeVulong(this.output, this.literals[0]);
        }
        if (this.isFixedDelta) {
            SerializationUtils.writeVslong(this.output, this.fixedDelta);
        } else {
            SerializationUtils.writeVslong(this.output, this.adjDeltas[0]);
            SerializationUtils.writeInts(this.adjDeltas, 1, this.adjDeltas.length - 1, fb, this.output);
        }
    }

    private void writePatchedBaseValues() throws IOException {
        int baseWidth;
        boolean isNegative;
        int fb = this.brBits95p;
        int efb = SerializationUtils.encodeBitWidth(fb) << 1;
        --this.variableRunLength;
        int tailBits = (this.variableRunLength & 0x100) >>> 8;
        int headerFirstByte = this.getOpcode() | efb | tailBits;
        int headerSecondByte = this.variableRunLength & 0xFF;
        boolean bl = isNegative = this.min < 0L;
        if (isNegative) {
            this.min = -this.min;
        }
        int baseBytes = (baseWidth = SerializationUtils.findClosestNumBits(this.min) + 1) % 8 == 0 ? baseWidth / 8 : baseWidth / 8 + 1;
        int bb = baseBytes - 1 << 5;
        if (isNegative) {
            this.min |= 1L << baseBytes * 8 - 1;
        }
        int headerThirdByte = bb | SerializationUtils.encodeBitWidth(this.patchWidth);
        int headerFourthByte = this.patchGapWidth - 1 << 5 | this.patchLength;
        this.output.write(headerFirstByte);
        this.output.write(headerSecondByte);
        this.output.write(headerThirdByte);
        this.output.write(headerFourthByte);
        for (int i = baseBytes - 1; i >= 0; --i) {
            byte b = (byte)(this.min >>> i * 8 & 0xFFL);
            this.output.write(b);
        }
        int closestFixedBits = SerializationUtils.getClosestFixedBits(this.brBits95p);
        SerializationUtils.writeInts(this.baseRedLiterals, 0, this.baseRedLiterals.length, closestFixedBits, this.output);
        closestFixedBits = SerializationUtils.getClosestFixedBits(this.patchGapWidth + this.patchWidth);
        SerializationUtils.writeInts(this.gapVsPatchList, 0, this.gapVsPatchList.length, closestFixedBits, this.output);
        this.variableRunLength = 0;
    }

    private int getOpcode() {
        return this.encoding.ordinal() << 6;
    }

    private void writeDirectValues() throws IOException {
        int efb = SerializationUtils.encodeBitWidth(this.zzBits100p) << 1;
        --this.variableRunLength;
        int tailBits = (this.variableRunLength & 0x100) >>> 8;
        int headerFirstByte = this.getOpcode() | efb | tailBits;
        int headerSecondByte = this.variableRunLength & 0xFF;
        this.output.write(headerFirstByte);
        this.output.write(headerSecondByte);
        SerializationUtils.writeInts(this.zigzagLiterals, 0, this.zigzagLiterals.length, this.zzBits100p, this.output);
        this.variableRunLength = 0;
    }

    private void writeShortRepeatValues() throws IOException {
        long repeatVal = 0L;
        repeatVal = this.signed ? SerializationUtils.zigzagEncode(this.literals[0]) : this.literals[0];
        int numBitsRepeatVal = SerializationUtils.findClosestNumBits(repeatVal);
        int numBytesRepeatVal = numBitsRepeatVal % 8 == 0 ? numBitsRepeatVal >>> 3 : (numBitsRepeatVal >>> 3) + 1;
        int header = this.getOpcode();
        header |= numBytesRepeatVal - 1 << 3;
        this.fixedRunLength -= 3;
        this.output.write(header |= this.fixedRunLength);
        for (int i = numBytesRepeatVal - 1; i >= 0; --i) {
            int b = (int)(repeatVal >>> i * 8 & 0xFFL);
            this.output.write(b);
        }
        this.fixedRunLength = 0;
    }

    private void determineEncoding() {
        this.zigzagLiterals = new long[this.numLiterals];
        this.baseRedLiterals = new long[this.numLiterals];
        this.adjDeltas = new long[this.numLiterals - 1];
        int idx = 0;
        boolean isIncreasing = false;
        int increasingCount = 1;
        boolean isDecreasing = false;
        int decreasingCount = 1;
        this.min = this.literals[0];
        long max = this.literals[0];
        this.isFixedDelta = true;
        long currDelta = 0L;
        this.min = this.literals[0];
        long deltaMax = 0L;
        if (this.numLiterals >= 1) {
            currDelta = this.literals[1] - this.literals[0];
            for (int i = 0; i < this.numLiterals; ++i) {
                if (i > 0 && this.literals[i] >= max) {
                    max = this.literals[i];
                    ++increasingCount;
                }
                if (i > 0 && this.literals[i] <= this.min) {
                    this.min = this.literals[i];
                    ++decreasingCount;
                }
                if (i > 0 && this.isFixedDelta) {
                    if (this.literals[i] - this.literals[i - 1] != currDelta) {
                        this.isFixedDelta = false;
                    }
                    this.fixedDelta = currDelta;
                }
                long zzEncVal = 0L;
                zzEncVal = this.signed ? SerializationUtils.zigzagEncode(this.literals[i]) : this.literals[i];
                this.zigzagLiterals[idx] = zzEncVal;
                ++idx;
                if (i <= 0) continue;
                if (i == 1) {
                    this.adjDeltas[i - 1] = this.literals[i] - this.literals[i - 1];
                    continue;
                }
                this.adjDeltas[i - 1] = Math.abs(this.literals[i] - this.literals[i - 1]);
                if (this.adjDeltas[i - 1] <= deltaMax) continue;
                deltaMax = this.adjDeltas[i - 1];
            }
            this.bitsDeltaMax = SerializationUtils.findClosestNumBits(deltaMax);
            if (increasingCount == 1 && decreasingCount == this.numLiterals) {
                isDecreasing = true;
            }
            if (decreasingCount == 1 && increasingCount == this.numLiterals) {
                isIncreasing = true;
            }
        }
        if (isDecreasing && isIncreasing) {
            isDecreasing = false;
            isIncreasing = false;
        }
        if (!isIncreasing && !isDecreasing && this.isFixedDelta) {
            this.encoding = EncodingType.DELTA;
            return;
        }
        if (isIncreasing || isDecreasing) {
            this.encoding = EncodingType.DELTA;
            return;
        }
        double p = 0.9;
        this.zzBits90p = SerializationUtils.percentileBits(this.zigzagLiterals, p);
        p = 1.0;
        this.zzBits100p = SerializationUtils.percentileBits(this.zigzagLiterals, p);
        int diffBitsLH = this.zzBits100p - this.zzBits90p;
        if (!(isIncreasing || isDecreasing || diffBitsLH <= 1 || this.isFixedDelta)) {
            for (int i = 0; i < this.zigzagLiterals.length; ++i) {
                this.baseRedLiterals[i] = this.literals[i] - this.min;
            }
            p = 0.95;
            this.brBits95p = SerializationUtils.percentileBits(this.baseRedLiterals, p);
            p = 1.0;
            this.brBits100p = SerializationUtils.percentileBits(this.baseRedLiterals, p);
            if (this.brBits100p - this.brBits95p != 0) {
                this.encoding = EncodingType.PATCHED_BASE;
                this.preparePatchedBlob();
                return;
            }
            this.encoding = EncodingType.DIRECT;
            return;
        }
        if (!(isIncreasing || isDecreasing || diffBitsLH > 1 || this.isFixedDelta)) {
            this.encoding = EncodingType.DIRECT;
            return;
        }
        if (this.encoding == null) {
            throw new RuntimeException("Integer encoding cannot be determined.");
        }
    }

    private void preparePatchedBlob() {
        int i;
        long mask = (1L << this.brBits95p) - 1L;
        this.patchLength = (int)Math.ceil((double)this.baseRedLiterals.length * 0.05);
        int[] gapList = new int[this.patchLength];
        long[] patchList = new long[this.patchLength];
        this.patchWidth = this.brBits100p - this.brBits95p;
        this.patchWidth = SerializationUtils.getClosestFixedBits(this.patchWidth);
        if (this.patchWidth == 64) {
            this.patchWidth = 56;
            this.brBits95p = 8;
            mask = (1L << this.brBits95p) - 1L;
        }
        int gapIdx = 0;
        int patchIdx = 0;
        int prev = 0;
        int gap = 0;
        int maxGap = 0;
        for (i = 0; i < this.baseRedLiterals.length; ++i) {
            if (this.baseRedLiterals[i] <= mask) continue;
            gap = i - prev;
            if (gap > maxGap) {
                maxGap = gap;
            }
            prev = i;
            gapList[gapIdx++] = gap;
            long patch = this.baseRedLiterals[i] >>> this.brBits95p;
            patchList[patchIdx++] = patch;
            int n = i;
            this.baseRedLiterals[n] = this.baseRedLiterals[n] & mask;
        }
        this.patchLength = gapIdx;
        this.patchGapWidth = maxGap == 0 && this.patchLength != 0 ? 1 : SerializationUtils.findClosestNumBits(maxGap);
        if (this.patchGapWidth > 8) {
            this.patchGapWidth = 8;
            this.patchLength = maxGap == 511 ? (this.patchLength += 2) : ++this.patchLength;
        }
        gapIdx = 0;
        patchIdx = 0;
        this.gapVsPatchList = new long[this.patchLength];
        for (i = 0; i < this.patchLength; ++i) {
            long g;
            long p = patchList[patchIdx++];
            for (g = (long)gapList[gapIdx++]; g > 255L; g -= 255L) {
                this.gapVsPatchList[i++] = 255L << this.patchWidth;
            }
            this.gapVsPatchList[i] = g << this.patchWidth | p;
        }
    }

    private void clear() {
        this.numLiterals = 0;
        this.encoding = null;
        this.prevDelta = 0L;
        this.zigzagLiterals = null;
        this.baseRedLiterals = null;
        this.adjDeltas = null;
        this.fixedDelta = 0L;
        this.zzBits90p = 0;
        this.zzBits100p = 0;
        this.brBits95p = 0;
        this.brBits100p = 0;
        this.bitsDeltaMax = 0;
        this.patchGapWidth = 0;
        this.patchLength = 0;
        this.patchWidth = 0;
        this.gapVsPatchList = null;
        this.min = 0L;
        this.isFixedDelta = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.numLiterals != 0) {
            if (this.variableRunLength != 0) {
                this.determineEncoding();
                this.writeValues();
            } else if (this.fixedRunLength != 0) {
                if (this.fixedRunLength < 3) {
                    this.variableRunLength = this.fixedRunLength;
                    this.fixedRunLength = 0;
                    this.determineEncoding();
                    this.writeValues();
                } else if (this.fixedRunLength >= 3 && this.fixedRunLength <= 10) {
                    this.encoding = EncodingType.SHORT_REPEAT;
                    this.writeValues();
                } else {
                    this.encoding = EncodingType.DELTA;
                    this.isFixedDelta = true;
                    this.writeValues();
                }
            }
        }
        this.output.flush();
    }

    @Override
    public void write(long val) throws IOException {
        if (this.numLiterals == 0) {
            this.initializeLiterals(val);
        } else if (this.numLiterals == 1) {
            this.prevDelta = val - this.literals[0];
            this.literals[this.numLiterals++] = val;
            if (val == this.literals[0]) {
                this.fixedRunLength = 2;
                this.variableRunLength = 0;
            } else {
                this.fixedRunLength = 0;
                this.variableRunLength = 2;
            }
        } else {
            long currentDelta = val - this.literals[this.numLiterals - 1];
            if (this.prevDelta == 0L && currentDelta == 0L) {
                this.literals[this.numLiterals++] = val;
                if (this.variableRunLength > 0) {
                    this.fixedRunLength = 2;
                }
                ++this.fixedRunLength;
                if (this.fixedRunLength >= 3 && this.variableRunLength > 0) {
                    this.numLiterals -= 3;
                    this.variableRunLength -= 2;
                    long[] tailVals = new long[3];
                    System.arraycopy(this.literals, this.numLiterals, tailVals, 0, 3);
                    this.determineEncoding();
                    this.writeValues();
                    for (long l : tailVals) {
                        this.literals[this.numLiterals++] = l;
                    }
                }
                if (this.fixedRunLength == 512) {
                    this.determineEncoding();
                    this.writeValues();
                }
            } else {
                if (this.fixedRunLength >= 3) {
                    if (this.fixedRunLength <= 10) {
                        this.encoding = EncodingType.SHORT_REPEAT;
                        this.writeValues();
                    } else {
                        this.encoding = EncodingType.DELTA;
                        this.isFixedDelta = true;
                        this.writeValues();
                    }
                }
                if (this.fixedRunLength > 0 && this.fixedRunLength < 3 && val != this.literals[this.numLiterals - 1]) {
                    this.variableRunLength = this.fixedRunLength;
                    this.fixedRunLength = 0;
                }
                if (this.numLiterals == 0) {
                    this.initializeLiterals(val);
                } else {
                    this.prevDelta = val - this.literals[this.numLiterals - 1];
                    this.literals[this.numLiterals++] = val;
                    ++this.variableRunLength;
                    if (this.variableRunLength == 512) {
                        this.determineEncoding();
                        this.writeValues();
                    }
                }
            }
        }
    }

    private void initializeLiterals(long val) {
        this.literals[this.numLiterals++] = val;
        this.fixedRunLength = 1;
        this.variableRunLength = 1;
    }

    @Override
    public void getPosition(PositionRecorder recorder) throws IOException {
        this.output.getPosition(recorder);
        recorder.addPosition(this.numLiterals);
    }

    public static enum EncodingType {
        SHORT_REPEAT,
        DIRECT,
        PATCHED_BASE,
        DELTA;

    }
}

