/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import parquet.io.api.Converter;
import parquet.schema.GroupType;
import parquet.schema.Type;

public class DataWritableGroupConverter
extends HiveGroupConverter {
    private final Converter[] converters;
    private final HiveGroupConverter parent;
    private final int index;
    private final Object[] currentArr;
    private Writable[] rootMap;

    public DataWritableGroupConverter(GroupType requestedSchema, GroupType tableSchema) {
        this(requestedSchema, null, 0, tableSchema);
        int fieldCount = tableSchema.getFieldCount();
        this.rootMap = new Writable[fieldCount];
    }

    public DataWritableGroupConverter(GroupType groupType, HiveGroupConverter parent, int index) {
        this(groupType, parent, index, groupType);
    }

    public DataWritableGroupConverter(GroupType selectedGroupType, HiveGroupConverter parent, int index, GroupType containingGroupType) {
        this.parent = parent;
        this.index = index;
        int totalFieldCount = containingGroupType.getFieldCount();
        int selectedFieldCount = selectedGroupType.getFieldCount();
        this.currentArr = new Object[totalFieldCount];
        this.converters = new Converter[selectedFieldCount];
        List selectedFields = selectedGroupType.getFields();
        for (int i = 0; i < selectedFieldCount; ++i) {
            Type subtype = (Type)selectedFields.get(i);
            if (!containingGroupType.getFields().contains(subtype)) {
                throw new IllegalStateException("Group type [" + containingGroupType + "] does not contain requested field: " + subtype);
            }
            this.converters[i] = DataWritableGroupConverter.getConverterFromDescription(subtype, containingGroupType.getFieldIndex(subtype.getName()), this);
        }
    }

    public final ArrayWritable getCurrentArray() {
        Writable[] writableArr = this.rootMap != null ? this.rootMap : new Writable[this.currentArr.length];
        for (int i = 0; i < this.currentArr.length; ++i) {
            Object obj = this.currentArr[i];
            if (obj instanceof List) {
                List objList = (List)obj;
                ArrayWritable arr = new ArrayWritable(Writable.class, objList.toArray(new Writable[objList.size()]));
                writableArr[i] = arr;
                continue;
            }
            writableArr[i] = (Writable)obj;
        }
        return new ArrayWritable(Writable.class, writableArr);
    }

    @Override
    protected final void set(int index, Writable value) {
        this.currentArr[index] = value;
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        for (int i = 0; i < this.currentArr.length; ++i) {
            this.currentArr[i] = null;
        }
    }

    public void end() {
        if (this.parent != null) {
            this.parent.set(this.index, (Writable)this.getCurrentArray());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void add(int index, Writable value) {
        if (this.currentArr[index] != null) {
            Object obj = this.currentArr[index];
            if (!(obj instanceof List)) throw new IllegalStateException("This should be a List: " + obj);
            List list = (List)obj;
            list.add(value);
            return;
        } else {
            ArrayList<Writable> buffer = new ArrayList<Writable>();
            buffer.add(value);
            this.currentArr[index] = buffer;
        }
    }
}

