/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class VirtualColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static VirtualColumn FILENAME = new VirtualColumn("INPUT__FILE__NAME", TypeInfoFactory.stringTypeInfo);
    public static VirtualColumn BLOCKOFFSET = new VirtualColumn("BLOCK__OFFSET__INSIDE__FILE", TypeInfoFactory.longTypeInfo);
    public static VirtualColumn ROWOFFSET = new VirtualColumn("ROW__OFFSET__INSIDE__BLOCK", TypeInfoFactory.longTypeInfo);
    public static VirtualColumn RAWDATASIZE = new VirtualColumn("RAW__DATA__SIZE", TypeInfoFactory.longTypeInfo);
    public static VirtualColumn GROUPINGID = new VirtualColumn("GROUPING__ID", TypeInfoFactory.intTypeInfo);
    public static VirtualColumn[] VIRTUAL_COLUMNS = new VirtualColumn[]{FILENAME, BLOCKOFFSET, ROWOFFSET, RAWDATASIZE, GROUPINGID};
    private String name;
    private PrimitiveTypeInfo typeInfo;
    private boolean isHidden = true;

    public VirtualColumn() {
    }

    public VirtualColumn(String name, PrimitiveTypeInfo typeInfo) {
        this(name, typeInfo, true);
    }

    VirtualColumn(String name, PrimitiveTypeInfo typeInfo, boolean isHidden) {
        this.name = name;
        this.typeInfo = typeInfo;
        this.isHidden = isHidden;
    }

    public static List<VirtualColumn> getStatsRegistry(Configuration conf) {
        ArrayList<VirtualColumn> l = new ArrayList<VirtualColumn>();
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_COLLECT_RAWDATASIZE)) {
            l.add(RAWDATASIZE);
        }
        return l;
    }

    public static List<VirtualColumn> getRegistry(Configuration conf) {
        ArrayList<VirtualColumn> l = new ArrayList<VirtualColumn>();
        l.add(BLOCKOFFSET);
        l.add(FILENAME);
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEROWOFFSET)) {
            l.add(ROWOFFSET);
        }
        return l;
    }

    public PrimitiveTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(PrimitiveTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        VirtualColumn c = (VirtualColumn)o;
        return this.name.equals(c.name) && this.typeInfo.getTypeName().equals(c.getTypeInfo().getTypeName());
    }

    public static Collection<String> removeVirtualColumns(Collection<String> columns) {
        for (VirtualColumn vcol : VIRTUAL_COLUMNS) {
            columns.remove(vcol.getName());
        }
        return columns;
    }

    public static StructObjectInspector getVCSObjectInspector(List<VirtualColumn> vcs) {
        ArrayList<String> names = new ArrayList<String>(vcs.size());
        ArrayList<AbstractPrimitiveWritableObjectInspector> inspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>(vcs.size());
        for (VirtualColumn vc : vcs) {
            names.add(vc.getName());
            inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)vc.getTypeInfo()));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
    }
}

