/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class ReduceSinkMapJoinProc
implements NodeProcessor {
    protected transient Log LOG = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        BaseWork parentWork;
        GenTezProcContext context = (GenTezProcContext)procContext;
        MapJoinOperator mapJoinOp = (MapJoinOperator)nd;
        if (stack.size() < 2 || !(stack.get(stack.size() - 2) instanceof ReduceSinkOperator)) {
            context.currentMapJoinOperators.add(mapJoinOp);
            return null;
        }
        context.preceedingWork = null;
        context.currentRootOperator = null;
        ReduceSinkOperator parentRS = (ReduceSinkOperator)stack.get(stack.size() - 2);
        if (!context.mapJoinParentMap.containsKey(mapJoinOp)) {
            ArrayList<Operator<OperatorDesc>> parents = new ArrayList<Operator<OperatorDesc>>(mapJoinOp.getParentOperators());
            context.mapJoinParentMap.put(mapJoinOp, parents);
        }
        List<BaseWork> mapJoinWork = null;
        mapJoinWork = context.mapJoinWorkMap.get(mapJoinOp);
        if (context.unionWorkMap.containsKey(parentRS)) {
            parentWork = context.unionWorkMap.get(parentRS);
        } else {
            assert (context.childToWorkMap.get(parentRS).size() == 1);
            parentWork = context.childToWorkMap.get(parentRS).get(0);
        }
        int pos = context.mapJoinParentMap.get(mapJoinOp).indexOf(parentRS);
        if (pos == -1) {
            throw new SemanticException("Cannot find position of parent in mapjoin");
        }
        this.LOG.debug((Object)("Mapjoin " + mapJoinOp + ", pos: " + pos + " --> " + parentWork.getName()));
        ((MapJoinDesc)mapJoinOp.getConf()).getParentToInput().put(pos, parentWork.getName());
        int numBuckets = -1;
        TezEdgeProperty.EdgeType edgeType = TezEdgeProperty.EdgeType.BROADCAST_EDGE;
        if (((MapJoinDesc)mapJoinOp.getConf()).isBucketMapJoin()) {
            numBuckets = (Integer)((MapJoinDesc)mapJoinOp.getConf()).getBigTableBucketNumMapping().values().toArray()[0];
            edgeType = ((MapJoinDesc)mapJoinOp.getConf()).getCustomBucketMapJoin() ? TezEdgeProperty.EdgeType.CUSTOM_EDGE : TezEdgeProperty.EdgeType.CUSTOM_SIMPLE_EDGE;
        }
        TezEdgeProperty edgeProp = new TezEdgeProperty(null, edgeType, numBuckets);
        if (mapJoinWork != null) {
            for (BaseWork myWork : mapJoinWork) {
                TezWork tezWork = (TezWork)context.currentTask.getWork();
                this.LOG.debug((Object)("connecting " + parentWork.getName() + " with " + myWork.getName()));
                tezWork.connect(parentWork, myWork, edgeProp);
                ReduceSinkOperator r = null;
                if (((ReduceSinkDesc)parentRS.getConf()).getOutputName() != null) {
                    this.LOG.debug((Object)"Cloning reduce sink for multi-child broadcast edge");
                    r = (ReduceSinkOperator)OperatorFactory.getAndMakeChild((ReduceSinkDesc)((ReduceSinkDesc)parentRS.getConf()).clone(), parentRS.getParentOperators());
                    context.clonedReduceSinks.add(r);
                } else {
                    r = parentRS;
                }
                ((ReduceSinkDesc)r.getConf()).setOutputName(myWork.getName());
                context.connectedReduceSinks.add(r);
            }
        }
        Map<BaseWork, TezEdgeProperty> linkWorkMap = null;
        linkWorkMap = context.linkOpWithWorkMap.containsKey(mapJoinOp) ? context.linkOpWithWorkMap.get(mapJoinOp) : new HashMap<BaseWork, TezEdgeProperty>();
        linkWorkMap.put(parentWork, edgeProp);
        context.linkOpWithWorkMap.put(mapJoinOp, linkWorkMap);
        List<ReduceSinkOperator> reduceSinks = context.linkWorkWithReduceSinkMap.get(parentWork);
        if (reduceSinks == null) {
            reduceSinks = new ArrayList<ReduceSinkOperator>();
        }
        reduceSinks.add(parentRS);
        context.linkWorkWithReduceSinkMap.put(parentWork, reduceSinks);
        ArrayList<Operator> dummyOperators = new ArrayList<Operator>();
        HashTableDummyDesc desc = new HashTableDummyDesc();
        HashTableDummyOperator dummyOp = (HashTableDummyOperator)OperatorFactory.get(desc, new Operator[0]);
        RowSchema rowSchema = parentRS.getParentOperators().get(0).getSchema();
        TableDesc tbl = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromRowSchema(rowSchema, ""));
        ((HashTableDummyDesc)dummyOp.getConf()).setTbl(tbl);
        Map<Byte, List<ExprNodeDesc>> keyExprMap = ((MapJoinDesc)mapJoinOp.getConf()).getKeys();
        List<ExprNodeDesc> keyCols = keyExprMap.get((byte)0);
        StringBuffer keyOrder = new StringBuffer();
        for (ExprNodeDesc k : keyCols) {
            keyOrder.append("+");
        }
        TableDesc keyTableDesc = PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "mapjoinkey"), keyOrder.toString());
        ((MapJoinDesc)mapJoinOp.getConf()).setKeyTableDesc(keyTableDesc);
        mapJoinOp.replaceParent(parentRS, dummyOp);
        ArrayList<Operator<? extends OperatorDesc>> dummyChildren = new ArrayList<Operator<? extends OperatorDesc>>();
        dummyChildren.add(mapJoinOp);
        dummyOp.setChildOperators(dummyChildren);
        dummyOperators.add(dummyOp);
        List<Operator<OperatorDesc>> childOperators = parentRS.getChildOperators();
        int childIndex = childOperators.indexOf(mapJoinOp);
        childOperators.remove(childIndex);
        if (mapJoinWork != null) {
            for (BaseWork baseWork : mapJoinWork) {
                baseWork.addDummyOp(dummyOp);
            }
        }
        if (context.linkChildOpWithDummyOp.containsKey(mapJoinOp)) {
            for (Operator operator : context.linkChildOpWithDummyOp.get(mapJoinOp)) {
                dummyOperators.add(operator);
            }
        }
        context.linkChildOpWithDummyOp.put(mapJoinOp, dummyOperators);
        return true;
    }
}

