/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public final class RewriteCanApplyProcFactory {
    private static RewriteCanApplyCtx canApplyCtx = null;

    private RewriteCanApplyProcFactory() {
    }

    public static CheckFilterProc canApplyOnFilterOperator() {
        return new CheckFilterProc();
    }

    public static CheckGroupByProc canApplyOnGroupByOperator() {
        return new CheckGroupByProc();
    }

    public static CheckSelectProc canApplyOnSelectOperator() {
        return new CheckSelectProc();
    }

    private static class CheckSelectProc
    implements NodeProcessor {
        private CheckSelectProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator operator = (SelectOperator)nd;
            canApplyCtx = (RewriteCanApplyCtx)ctx;
            List<Operator<OperatorDesc>> childrenList = operator.getChildOperators();
            Operator<OperatorDesc> child = childrenList.get(0);
            if (child instanceof FileSinkOperator) {
                LinkedHashMap<String, String> internalToAlias = new LinkedHashMap<String, String>();
                RowSchema rs = operator.getSchema();
                ArrayList<ColumnInfo> sign = rs.getSignature();
                for (ColumnInfo columnInfo : sign) {
                    internalToAlias.put(columnInfo.getInternalName(), columnInfo.getAlias());
                }
                for (String predCol : canApplyCtx.getPredicateColumnsList()) {
                    String newPredCol = "";
                    if (internalToAlias.get(predCol) == null) continue;
                    newPredCol = (String)internalToAlias.get(predCol);
                    canApplyCtx.getPredicateColumnsList().remove(predCol);
                    canApplyCtx.getPredicateColumnsList().add(newPredCol);
                }
            }
            return null;
        }
    }

    private static class CheckGroupByProc
    implements NodeProcessor {
        private CheckGroupByProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator operator = (GroupByOperator)nd;
            canApplyCtx = (RewriteCanApplyCtx)ctx;
            if (canApplyCtx.getParseContext().getGroupOpToInputTables().containsKey(operator) && !canApplyCtx.isQueryHasGroupBy()) {
                ArrayList<ExprNodeDesc> keyList;
                canApplyCtx.setQueryHasGroupBy(true);
                GroupByDesc conf = (GroupByDesc)operator.getConf();
                ArrayList<AggregationDesc> aggrList = conf.getAggregators();
                if (aggrList != null && aggrList.size() > 0) {
                    for (AggregationDesc aggregationDesc : aggrList) {
                        canApplyCtx.setAggFuncCnt(canApplyCtx.getAggFuncCnt() + 1);
                        if (canApplyCtx.getAggFuncCnt() > 1) {
                            return false;
                        }
                        String aggFunc = aggregationDesc.getGenericUDAFName();
                        if (!"count".equals(aggFunc)) {
                            canApplyCtx.setAggFuncIsNotCount(true);
                            continue;
                        }
                        ArrayList<ExprNodeDesc> para = aggregationDesc.getParameters();
                        if (para == null) {
                            canApplyCtx.setAggFuncColsFetchException(true);
                            continue;
                        }
                        if (para.size() == 0) {
                            canApplyCtx.setCountOnAllCols(true);
                            canApplyCtx.setAggFunction("_count_of_all");
                            continue;
                        }
                        assert (para.size() == 1);
                        for (int i = 0; i < para.size(); ++i) {
                            ExprNodeDesc expr = (ExprNodeDesc)para.get(i);
                            if (expr instanceof ExprNodeColumnDesc) {
                                canApplyCtx.getSelectColumnsList().add(((ExprNodeColumnDesc)expr).getColumn());
                                canApplyCtx.getAggFuncColList().add(((ExprNodeColumnDesc)expr).getColumn());
                                canApplyCtx.setAggFunction("_count_of_" + ((ExprNodeColumnDesc)expr).getColumn() + "");
                                continue;
                            }
                            if (!(expr instanceof ExprNodeConstantDesc)) continue;
                            canApplyCtx.setCountOfOne(true);
                            canApplyCtx.setAggFunction("_count_of_1");
                        }
                    }
                }
                if ((keyList = conf.getKeys()) == null || keyList.size() == 0) {
                    canApplyCtx.setGbyKeysFetchException(true);
                }
                for (ExprNodeDesc expr : keyList) {
                    this.checkExpression(expr);
                }
            }
            return null;
        }

        private void checkExpression(ExprNodeDesc expr) {
            if (expr instanceof ExprNodeColumnDesc) {
                canApplyCtx.getGbKeyNameList().addAll(expr.getCols());
            } else if (expr instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc funcExpr = (ExprNodeGenericFuncDesc)expr;
                List<ExprNodeDesc> childExprs = funcExpr.getChildren();
                for (ExprNodeDesc childExpr : childExprs) {
                    if (childExpr instanceof ExprNodeColumnDesc) {
                        canApplyCtx.getGbKeyNameList().addAll(expr.getCols());
                        canApplyCtx.getSelectColumnsList().add(((ExprNodeColumnDesc)childExpr).getColumn());
                        continue;
                    }
                    if (!(childExpr instanceof ExprNodeGenericFuncDesc)) continue;
                    this.checkExpression(childExpr);
                }
            }
        }
    }

    private static class CheckFilterProc
    implements NodeProcessor {
        private CheckFilterProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            List<String> colList;
            FilterOperator operator = (FilterOperator)nd;
            canApplyCtx = (RewriteCanApplyCtx)ctx;
            FilterDesc conf = (FilterDesc)operator.getConf();
            ExprNodeGenericFuncDesc oldengfd = (ExprNodeGenericFuncDesc)conf.getPredicate();
            if (oldengfd == null) {
                canApplyCtx.setWhrClauseColsFetchException(true);
            }
            if ((colList = oldengfd.getCols()) == null || colList.size() == 0) {
                canApplyCtx.setWhrClauseColsFetchException(true);
            }
            for (String col : colList) {
                canApplyCtx.getPredicateColumnsList().add(col);
            }
            return null;
        }
    }
}

