/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.index.AggregateIndexHandler;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyCtx;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteQueryUsingAggregateIndexCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.util.StringUtils;

public class RewriteGBUsingIndex
implements Transform {
    private ParseContext parseContext;
    private Hive hiveDb;
    private HiveConf hiveConf;
    private static final Log LOG = LogFactory.getLog((String)RewriteGBUsingIndex.class.getName());
    private final Map<String, RewriteCanApplyCtx> tsOpToProcess = new LinkedHashMap<String, RewriteCanApplyCtx>();
    private String baseTableName = null;
    private String indexTableName = null;
    private static final String IDX_BUCKET_COL = "_bucketname";
    private static final String IDX_OFFSETS_ARRAY_COL = "_offsets";

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.parseContext = pctx;
        this.hiveConf = this.parseContext.getConf();
        try {
            this.hiveDb = Hive.get(this.hiveConf);
        }
        catch (HiveException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTINDEXFILTER, (boolean)false);
        if (this.shouldApplyOptimization()) {
            LOG.info((Object)("Rewriting Original Query using " + this.getName() + " optimization."));
            this.rewriteOriginalQuery();
        }
        return this.parseContext;
    }

    private String getName() {
        return "RewriteGBUsingIndex";
    }

    boolean shouldApplyOptimization() throws SemanticException {
        boolean canApply = false;
        if (this.ifQueryHasMultipleTables()) {
            return false;
        }
        HashMap<TableScanOperator, Table> topToTable = this.parseContext.getTopToTable();
        for (TableScanOperator topOp : topToTable.keySet()) {
            Table table = (Table)topToTable.get(topOp);
            this.baseTableName = table.getTableName();
            Map<Table, List<Index>> indexes = this.getIndexesForRewrite();
            if (indexes == null) {
                LOG.debug((Object)("Error getting valid indexes for rewrite, skipping " + this.getName() + " optimization"));
                return false;
            }
            if (indexes.size() == 0) {
                LOG.debug((Object)("No Valid Index Found to apply Rewrite, skipping " + this.getName() + " optimization"));
                return false;
            }
            if (this.parseContext.getOpToPartList() != null && this.parseContext.getOpToPartList().size() > 0) {
                if (this.checkIfIndexBuiltOnAllTablePartitions(topOp, indexes)) {
                    canApply = this.checkIfRewriteCanBeApplied(topOp, table, indexes);
                    continue;
                }
                LOG.debug((Object)("Index is not built for all table partitions, skipping " + this.getName() + " optimization"));
                return false;
            }
            canApply = this.checkIfRewriteCanBeApplied(topOp, table, indexes);
        }
        return canApply;
    }

    private boolean checkIfRewriteCanBeApplied(TableScanOperator topOp, Table baseTable, Map<Table, List<Index>> indexes) throws SemanticException {
        boolean canApply = false;
        RewriteCanApplyCtx canApplyCtx = RewriteCanApplyCtx.getInstance(this.parseContext);
        HashMap<String, Operator<? extends OperatorDesc>> topOps = this.parseContext.getTopOps();
        canApplyCtx.setBaseTableName(this.baseTableName);
        canApplyCtx.populateRewriteVars(topOp);
        Map<Index, Set<String>> indexTableMap = this.getIndexToKeysMap(indexes.get(baseTable));
        Iterator<Index> indexMapItr = indexTableMap.keySet().iterator();
        Index index = null;
        while (indexMapItr.hasNext()) {
            index = indexMapItr.next();
            canApply = canApplyCtx.isIndexUsableForQueryBranchRewrite(index, indexTableMap.get(index));
            if (!canApply) continue;
            canApply = this.checkIfAllRewriteCriteriaIsMet(canApplyCtx);
            if (!canApply || canApplyCtx.getAggFunction() != null) break;
            String aggregationFunction = indexTableMap.get(index).toString();
            aggregationFunction = aggregationFunction.substring(1, aggregationFunction.length() - 1);
            canApplyCtx.setAggFunction("_count_of_" + aggregationFunction + "");
            break;
        }
        this.indexTableName = index.getIndexTableName();
        if (canApply && topOps.containsValue(topOp)) {
            for (String topOpName : topOps.keySet()) {
                if (!((Operator)topOps.get(topOpName)).equals(topOp)) continue;
                this.tsOpToProcess.put(topOpName, canApplyCtx);
            }
        }
        canApply = this.tsOpToProcess.size() != 0;
        return canApply;
    }

    boolean ifQueryHasMultipleTables() {
        HashMap<TableScanOperator, Table> topToTable = this.parseContext.getTopToTable();
        Iterator valuesItr = topToTable.values().iterator();
        HashSet<String> tableNameSet = new HashSet<String>();
        while (valuesItr.hasNext()) {
            Table table = (Table)valuesItr.next();
            tableNameSet.add(table.getTableName());
        }
        if (tableNameSet.size() > 1) {
            LOG.debug((Object)("Query has more than one table that is not supported with " + this.getName() + " optimization."));
            return true;
        }
        return false;
    }

    private Map<Table, List<Index>> getIndexesForRewrite() throws SemanticException {
        ArrayList<String> supportedIndexes = new ArrayList<String>();
        supportedIndexes.add(AggregateIndexHandler.class.getName());
        Collection<Table> topTables = this.parseContext.getTopToTable().values();
        HashMap<Table, List<Index>> indexes = new HashMap<Table, List<Index>>();
        for (Table tbl : topTables) {
            List<Index> tblIndexes = IndexUtils.getIndexes(tbl, supportedIndexes);
            if (tblIndexes.size() <= 0) continue;
            indexes.put(tbl, tblIndexes);
        }
        return indexes;
    }

    private boolean checkIfIndexBuiltOnAllTablePartitions(TableScanOperator tableScan, Map<Table, List<Index>> indexes) throws SemanticException {
        Set<Partition> queryPartitions;
        try {
            queryPartitions = IndexUtils.checkPartitionsCoveredByIndex(tableScan, this.parseContext, indexes);
            if (queryPartitions == null) {
                return false;
            }
        }
        catch (HiveException e) {
            LOG.error((Object)"Fatal Error: problem accessing metastore", (Throwable)e);
            throw new SemanticException(e);
        }
        return queryPartitions.size() != 0;
    }

    Map<Index, Set<String>> getIndexToKeysMap(List<Index> indexTables) throws SemanticException {
        Index index = null;
        Hive hiveInstance = this.hiveDb;
        LinkedHashMap<Index, Set<String>> indexToKeysMap = new LinkedHashMap<Index, Set<String>>();
        for (int idxCtr = 0; idxCtr < indexTables.size(); ++idxCtr) {
            LinkedHashSet<String> indexKeyNames = new LinkedHashSet<String>();
            index = indexTables.get(idxCtr);
            StorageDescriptor sd = index.getSd();
            List idxColList = sd.getCols();
            for (FieldSchema fieldSchema : idxColList) {
                indexKeyNames.add(fieldSchema.getName());
            }
            assert (indexKeyNames.size() == 1);
            ArrayList<String> idxTblColNames = new ArrayList<String>();
            try {
                Table idxTbl = hiveInstance.getTable(index.getDbName(), index.getIndexTableName());
                for (FieldSchema idxTblCol : idxTbl.getCols()) {
                    idxTblColNames.add(idxTblCol.getName());
                }
            }
            catch (HiveException e) {
                LOG.error((Object)("Got exception while locating index table, skipping " + this.getName() + " optimization"));
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
            assert (idxTblColNames.contains(IDX_BUCKET_COL));
            assert (idxTblColNames.contains(IDX_OFFSETS_ARRAY_COL));
            indexToKeysMap.put(index, indexKeyNames);
        }
        return indexToKeysMap;
    }

    private void rewriteOriginalQuery() throws SemanticException {
        HashMap topOpMap = (HashMap)this.parseContext.getTopOps().clone();
        for (String this.baseTableName : this.tsOpToProcess.keySet()) {
            RewriteCanApplyCtx canApplyCtx = this.tsOpToProcess.get(this.baseTableName);
            TableScanOperator topOp = (TableScanOperator)topOpMap.get(this.baseTableName);
            RewriteQueryUsingAggregateIndexCtx rewriteQueryCtx = RewriteQueryUsingAggregateIndexCtx.getInstance(this.parseContext, this.hiveDb, this.indexTableName, this.baseTableName, canApplyCtx.getAggFunction());
            rewriteQueryCtx.invokeRewriteQueryProc(topOp);
            this.parseContext = rewriteQueryCtx.getParseContext();
            this.parseContext.setOpParseCtx((LinkedHashMap)rewriteQueryCtx.getOpc());
        }
        LOG.info((Object)"Finished Rewriting query");
    }

    boolean checkIfAllRewriteCriteriaIsMet(RewriteCanApplyCtx canApplyCtx) {
        if (canApplyCtx.getAggFuncCnt() > 1) {
            LOG.debug((Object)("More than 1 agg funcs: Not supported by " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isAggFuncIsNotCount()) {
            LOG.debug((Object)("Agg func other than count is not supported by " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isCountOnAllCols()) {
            LOG.debug((Object)("Currently count function needs group by on key columns. This is a count(*) case.,Cannot apply this " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isCountOfOne()) {
            LOG.debug((Object)("Currently count function needs group by on key columns. This is a count(1) case.,Cannot apply this " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isAggFuncColsFetchException()) {
            LOG.debug((Object)("Got exception while locating child col refs of agg func, skipping " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isWhrClauseColsFetchException()) {
            LOG.debug((Object)("Got exception while locating child col refs for where clause, skipping " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isSelClauseColsFetchException()) {
            LOG.debug((Object)("Got exception while locating child col refs for select list, skipping " + this.getName() + " optimization."));
            return false;
        }
        if (canApplyCtx.isGbyKeysFetchException()) {
            LOG.debug((Object)("Got exception while locating child col refs for GroupBy key, skipping " + this.getName() + " optimization."));
            return false;
        }
        return true;
    }
}

