/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExp;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;

public class Vectorizer
implements PhysicalPlanResolver {
    protected static final transient Log LOG = LogFactory.getLog(Vectorizer.class);
    Pattern supportedDataTypesPattern;
    List<Task<? extends Serializable>> vectorizableTasks = new ArrayList<Task<? extends Serializable>>();
    Set<Class<?>> supportedGenericUDFs = new HashSet();
    Set<String> supportedAggregationUdfs = new HashSet<String>();
    private PhysicalContext physicalContext = null;

    public Vectorizer() {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("int");
        patternBuilder.append("|smallint");
        patternBuilder.append("|tinyint");
        patternBuilder.append("|bigint");
        patternBuilder.append("|integer");
        patternBuilder.append("|long");
        patternBuilder.append("|short");
        patternBuilder.append("|timestamp");
        patternBuilder.append("|boolean");
        patternBuilder.append("|string");
        patternBuilder.append("|byte");
        patternBuilder.append("|float");
        patternBuilder.append("|double");
        patternBuilder.append("|date");
        patternBuilder.append("|decimal.*");
        this.supportedDataTypesPattern = Pattern.compile(patternBuilder.toString());
        this.supportedGenericUDFs.add(GenericUDFOPPlus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMinus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMultiply.class);
        this.supportedGenericUDFs.add(GenericUDFOPDivide.class);
        this.supportedGenericUDFs.add(GenericUDFOPMod.class);
        this.supportedGenericUDFs.add(GenericUDFOPNegative.class);
        this.supportedGenericUDFs.add(GenericUDFOPPositive.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPNot.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotEqual.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPOr.class);
        this.supportedGenericUDFs.add(GenericUDFOPAnd.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqual.class);
        this.supportedGenericUDFs.add(UDFLength.class);
        this.supportedGenericUDFs.add(UDFYear.class);
        this.supportedGenericUDFs.add(UDFMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfMonth.class);
        this.supportedGenericUDFs.add(UDFHour.class);
        this.supportedGenericUDFs.add(UDFMinute.class);
        this.supportedGenericUDFs.add(UDFSecond.class);
        this.supportedGenericUDFs.add(UDFWeekOfYear.class);
        this.supportedGenericUDFs.add(GenericUDFToUnixTimeStamp.class);
        this.supportedGenericUDFs.add(GenericUDFDateAdd.class);
        this.supportedGenericUDFs.add(GenericUDFDateSub.class);
        this.supportedGenericUDFs.add(GenericUDFDate.class);
        this.supportedGenericUDFs.add(GenericUDFDateDiff.class);
        this.supportedGenericUDFs.add(UDFLike.class);
        this.supportedGenericUDFs.add(UDFRegExp.class);
        this.supportedGenericUDFs.add(UDFSubstr.class);
        this.supportedGenericUDFs.add(GenericUDFLTrim.class);
        this.supportedGenericUDFs.add(GenericUDFRTrim.class);
        this.supportedGenericUDFs.add(GenericUDFTrim.class);
        this.supportedGenericUDFs.add(UDFSin.class);
        this.supportedGenericUDFs.add(UDFCos.class);
        this.supportedGenericUDFs.add(UDFTan.class);
        this.supportedGenericUDFs.add(UDFAsin.class);
        this.supportedGenericUDFs.add(UDFAcos.class);
        this.supportedGenericUDFs.add(UDFAtan.class);
        this.supportedGenericUDFs.add(UDFDegrees.class);
        this.supportedGenericUDFs.add(UDFRadians.class);
        this.supportedGenericUDFs.add(GenericUDFFloor.class);
        this.supportedGenericUDFs.add(GenericUDFCeil.class);
        this.supportedGenericUDFs.add(UDFExp.class);
        this.supportedGenericUDFs.add(UDFLn.class);
        this.supportedGenericUDFs.add(UDFLog2.class);
        this.supportedGenericUDFs.add(UDFLog10.class);
        this.supportedGenericUDFs.add(UDFLog.class);
        this.supportedGenericUDFs.add(GenericUDFPower.class);
        this.supportedGenericUDFs.add(GenericUDFRound.class);
        this.supportedGenericUDFs.add(GenericUDFPosMod.class);
        this.supportedGenericUDFs.add(UDFSqrt.class);
        this.supportedGenericUDFs.add(UDFSign.class);
        this.supportedGenericUDFs.add(UDFRand.class);
        this.supportedGenericUDFs.add(UDFBin.class);
        this.supportedGenericUDFs.add(UDFHex.class);
        this.supportedGenericUDFs.add(UDFConv.class);
        this.supportedGenericUDFs.add(GenericUDFLower.class);
        this.supportedGenericUDFs.add(GenericUDFUpper.class);
        this.supportedGenericUDFs.add(GenericUDFConcat.class);
        this.supportedGenericUDFs.add(GenericUDFAbs.class);
        this.supportedGenericUDFs.add(GenericUDFBetween.class);
        this.supportedGenericUDFs.add(GenericUDFIn.class);
        this.supportedGenericUDFs.add(GenericUDFCase.class);
        this.supportedGenericUDFs.add(GenericUDFWhen.class);
        this.supportedGenericUDFs.add(GenericUDFCoalesce.class);
        this.supportedGenericUDFs.add(UDFToLong.class);
        this.supportedGenericUDFs.add(UDFToInteger.class);
        this.supportedGenericUDFs.add(UDFToShort.class);
        this.supportedGenericUDFs.add(UDFToByte.class);
        this.supportedGenericUDFs.add(UDFToBoolean.class);
        this.supportedGenericUDFs.add(UDFToFloat.class);
        this.supportedGenericUDFs.add(UDFToDouble.class);
        this.supportedGenericUDFs.add(UDFToString.class);
        this.supportedGenericUDFs.add(GenericUDFTimestamp.class);
        this.supportedGenericUDFs.add(GenericUDFToDecimal.class);
        this.supportedGenericUDFs.add(GenericUDFToDate.class);
        this.supportedGenericUDFs.add(GenericUDFIf.class);
        this.supportedAggregationUdfs.add("min");
        this.supportedAggregationUdfs.add("max");
        this.supportedAggregationUdfs.add("count");
        this.supportedAggregationUdfs.add("sum");
        this.supportedAggregationUdfs.add("avg");
        this.supportedAggregationUdfs.add("variance");
        this.supportedAggregationUdfs.add("var_pop");
        this.supportedAggregationUdfs.add("var_samp");
        this.supportedAggregationUdfs.add("std");
        this.supportedAggregationUdfs.add("stddev");
        this.supportedAggregationUdfs.add("stddev_pop");
        this.supportedAggregationUdfs.add("stddev_samp");
    }

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        this.physicalContext = pctx;
        boolean vectorPath = HiveConf.getBoolVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        if (!vectorPath) {
            LOG.info((Object)"Vectorization is disabled");
            return pctx;
        }
        VectorizationDispatcher disp = new VectorizationDispatcher(pctx);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    boolean validateOperator(Operator<? extends OperatorDesc> op) {
        boolean ret = false;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                ret = this.validateGroupByOperator((GroupByOperator)op);
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case TABLESCAN: {
                ret = this.validateTableScanOperator((TableScanOperator)op);
                break;
            }
            case FILESINK: 
            case LIMIT: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private boolean validateSMBMapJoinOperator(SMBMapJoinOperator op) {
        SMBJoinDesc desc = (SMBJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateTableScanOperator(TableScanOperator op) {
        TableScanDesc desc = (TableScanDesc)op.getConf();
        return !desc.isGatherStats();
    }

    private boolean validateMapJoinOperator(MapJoinOperator op) {
        MapJoinDesc desc = (MapJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateMapJoinDesc(MapJoinDesc desc) {
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(posBigTable);
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(posBigTable);
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(posBigTable);
        return this.validateExprNodeDesc(filterExprs, VectorExpressionDescriptor.Mode.FILTER) && this.validateExprNodeDesc(keyExprs) && this.validateExprNodeDesc(valueExprs);
    }

    private boolean validateReduceSinkOperator(ReduceSinkOperator op) {
        ArrayList<ExprNodeDesc> keyDescs = ((ReduceSinkDesc)op.getConf()).getKeyCols();
        ArrayList<ExprNodeDesc> partitionDescs = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
        ArrayList<ExprNodeDesc> valueDesc = ((ReduceSinkDesc)op.getConf()).getValueCols();
        return this.validateExprNodeDesc(keyDescs) && this.validateExprNodeDesc(partitionDescs) && this.validateExprNodeDesc(valueDesc);
    }

    private boolean validateSelectOperator(SelectOperator op) {
        List<ExprNodeDesc> descList = ((SelectDesc)op.getConf()).getColList();
        for (ExprNodeDesc desc : descList) {
            boolean ret = this.validateExprNodeDesc(desc);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateFilterOperator(FilterOperator op) {
        ExprNodeDesc desc = ((FilterDesc)op.getConf()).getPredicate();
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.FILTER);
    }

    private boolean validateGroupByOperator(GroupByOperator op) {
        if (((GroupByDesc)op.getConf()).isGroupingSetsPresent()) {
            LOG.warn((Object)"Grouping sets not supported in vector mode");
            return false;
        }
        boolean ret = this.validateExprNodeDesc(((GroupByDesc)op.getConf()).getKeys());
        if (!ret) {
            return false;
        }
        return this.validateAggregationDesc(((GroupByDesc)op.getConf()).getAggregators());
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs) {
        return this.validateExprNodeDesc(descs, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : descs) {
            boolean ret = this.validateExprNodeDesc(d, mode);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateAggregationDesc(List<AggregationDesc> descs) {
        for (AggregationDesc d : descs) {
            boolean ret = this.validateAggregationDesc(d);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc) {
        ExprNodeGenericFuncDesc d;
        boolean r;
        String typeName = desc.getTypeInfo().getTypeName();
        boolean ret = this.validateDataType(typeName);
        if (!ret) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot vectorize " + desc.toString() + " of type " + typeName));
            }
            return false;
        }
        if (desc instanceof ExprNodeGenericFuncDesc && !(r = this.validateGenericUdf(d = (ExprNodeGenericFuncDesc)desc))) {
            return false;
        }
        if (desc.getChildren() != null) {
            for (ExprNodeDesc d2 : desc.getChildren()) {
                boolean r2 = this.validateExprNodeDescRecursive(d2);
                if (r2) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateExprNodeDesc(ExprNodeDesc desc) {
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        if (!this.validateExprNodeDescRecursive(desc)) {
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
            if (vc.getVectorExpression(desc, mode) == null) {
                return false;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to vectorize", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private boolean validateGenericUdf(ExprNodeGenericFuncDesc genericUDFExpr) {
        if (VectorizationContext.isCustomUDF(genericUDFExpr)) {
            return true;
        }
        GenericUDF genericUDF = genericUDFExpr.getGenericUDF();
        if (genericUDF instanceof GenericUDFBridge) {
            Class<? extends UDF> udf = ((GenericUDFBridge)genericUDF).getUdfClass();
            return this.supportedGenericUDFs.contains(udf);
        }
        return this.supportedGenericUDFs.contains(genericUDF.getClass());
    }

    private boolean validateAggregationDesc(AggregationDesc aggDesc) {
        if (!this.supportedAggregationUdfs.contains(aggDesc.getGenericUDAFName().toLowerCase())) {
            return false;
        }
        if (aggDesc.getParameters() != null) {
            return this.validateExprNodeDesc(aggDesc.getParameters());
        }
        return true;
    }

    private boolean validateDataType(String type) {
        return this.supportedDataTypesPattern.matcher(type.toLowerCase()).matches();
    }

    private VectorizationContext getVectorizationContext(TableScanOperator op, PhysicalContext pctx) {
        RowSchema rs = op.getSchema();
        HashMap<String, Integer> cmap = new HashMap<String, Integer>();
        int columnCount = 0;
        for (ColumnInfo c : rs.getSignature()) {
            if (this.isVirtualColumn(c)) continue;
            cmap.put(c.getInternalName(), columnCount++);
        }
        VectorizationContext vc = new VectorizationContext(cmap, columnCount);
        return vc;
    }

    Operator<? extends OperatorDesc> vectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext) throws HiveException {
        Operator<? extends OperatorDesc> vectorOp = null;
        switch (op.getType()) {
            case MAPJOIN: 
            case GROUPBY: 
            case FILTER: 
            case SELECT: 
            case REDUCESINK: 
            case FILESINK: 
            case LIMIT: {
                vectorOp = OperatorFactory.getVectorOperator(op.getConf(), vContext);
                break;
            }
            default: {
                vectorOp = op;
            }
        }
        if (vectorOp != op) {
            if (op.getParentOperators() != null) {
                vectorOp.setParentOperators(op.getParentOperators());
                for (Operator<OperatorDesc> p : op.getParentOperators()) {
                    p.replaceChild(op, vectorOp);
                }
            }
            if (op.getChildOperators() != null) {
                vectorOp.setChildOperators(op.getChildOperators());
                for (Operator<OperatorDesc> c : op.getChildOperators()) {
                    c.replaceParent(op, vectorOp);
                }
            }
            ((AbstractOperatorDesc)vectorOp.getConf()).setVectorMode(true);
        }
        return vectorOp;
    }

    private boolean isVirtualColumn(ColumnInfo column) {
        for (VirtualColumn vc : VirtualColumn.VIRTUAL_COLUMNS) {
            if (!column.getInternalName().equals(vc.getName())) continue;
            return true;
        }
        return false;
    }

    private static class ValidatorVectorizationContext
    extends VectorizationContext {
        private ValidatorVectorizationContext() {
            super(null, -1);
        }

        @Override
        protected int getInputColumnIndex(String name) {
            return 0;
        }

        @Override
        protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) {
            return 0;
        }
    }

    class VectorizationNodeProcessor
    implements NodeProcessor {
        private final MapWork mWork;
        private final Map<String, VectorizationContext> scratchColumnContext = new HashMap<String, VectorizationContext>();
        private final Map<Operator<? extends OperatorDesc>, VectorizationContext> vContextsByTSOp = new HashMap<Operator<? extends OperatorDesc>, VectorizationContext>();
        private final Set<Operator<? extends OperatorDesc>> opsDone = new HashSet<Operator<? extends OperatorDesc>>();

        public VectorizationNodeProcessor(MapWork mWork) {
            this.mWork = mWork;
        }

        public Map<String, Map<Integer, String>> getScratchColumnVectorTypes() {
            HashMap<String, Map<Integer, String>> scratchColumnVectorTypes = new HashMap<String, Map<Integer, String>>();
            for (String onefile : this.scratchColumnContext.keySet()) {
                VectorizationContext vc = this.scratchColumnContext.get(onefile);
                Map<Integer, String> cmap = vc.getOutputColumnTypeMap();
                scratchColumnVectorTypes.put(onefile, cmap);
            }
            return scratchColumnVectorTypes;
        }

        public Map<String, Map<String, Integer>> getScratchColumnMap() {
            HashMap<String, Map<String, Integer>> scratchColumnMap = new HashMap<String, Map<String, Integer>>();
            for (String oneFile : this.scratchColumnContext.keySet()) {
                VectorizationContext vc = this.scratchColumnContext.get(oneFile);
                Map<String, Integer> cmap = vc.getColumnMap();
                scratchColumnMap.put(oneFile, cmap);
            }
            return scratchColumnMap;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            VectorizationContext vContext = null;
            if (op instanceof TableScanOperator) {
                vContext = Vectorizer.this.getVectorizationContext((TableScanOperator)op, Vectorizer.this.physicalContext);
                block2: for (String onefile : this.mWork.getPathToAliases().keySet()) {
                    List aliases = this.mWork.getPathToAliases().get(onefile);
                    for (String alias : aliases) {
                        Operator<? extends OperatorDesc> opRoot = this.mWork.getAliasToWork().get(alias);
                        if (op != opRoot) continue;
                        vContext.setFileKey(onefile);
                        this.scratchColumnContext.put(onefile, vContext);
                        continue block2;
                    }
                }
                this.vContextsByTSOp.put(op, vContext);
            } else {
                assert (stack.size() > 1);
                int i = stack.size() - 2;
                while (vContext == null) {
                    Operator opParent = (Operator)stack.get(i);
                    vContext = this.vContextsByTSOp.get(opParent);
                    --i;
                }
            }
            assert (vContext != null);
            if ((op.getType().equals((Object)OperatorType.REDUCESINK) || op.getType().equals((Object)OperatorType.FILESINK)) && op.getParentOperators().get(0).getType().equals((Object)OperatorType.GROUPBY)) {
                if (!this.opsDone.contains(op)) {
                    this.opsDone.add(op);
                }
            } else {
                try {
                    if (!this.opsDone.contains(op)) {
                        Operator<? extends OperatorDesc> vectorOp = Vectorizer.this.vectorizeOperator(op, vContext);
                        this.opsDone.add(op);
                        if (vectorOp != op) {
                            this.opsDone.add(vectorOp);
                        }
                        if (vectorOp instanceof VectorizationContextRegion) {
                            VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                            VectorizationContext vOutContext = vcRegion.getOuputVectorizationContext();
                            this.vContextsByTSOp.put(op, vOutContext);
                            this.scratchColumnContext.put(vOutContext.getFileKey(), vOutContext);
                        }
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
            }
            return null;
        }
    }

    class ValidationNodeProcessor
    implements NodeProcessor {
        ValidationNodeProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if ((op.getType().equals((Object)OperatorType.REDUCESINK) || op.getType().equals((Object)OperatorType.FILESINK)) && op.getParentOperators().get(0).getType().equals((Object)OperatorType.GROUPBY)) {
                    return new Boolean(true);
                }
                boolean ret = Vectorizer.this.validateOperator(op);
                if (ret) continue;
                LOG.info((Object)("Operator: " + op.getName() + " could not be vectorized."));
                return new Boolean(false);
            }
            return new Boolean(true);
        }
    }

    class VectorizationDispatcher
    implements Dispatcher {
        public VectorizationDispatcher(PhysicalContext pctx) {
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task currTask = (Task)nd;
            if (currTask instanceof MapRedTask) {
                this.convertMapWork(((MapredWork)((MapRedTask)currTask).getWork()).getMapWork());
            } else if (currTask instanceof TezTask) {
                TezWork work = (TezWork)((TezTask)currTask).getWork();
                for (BaseWork w : work.getAllWork()) {
                    if (!(w instanceof MapWork)) continue;
                    this.convertMapWork((MapWork)w);
                }
            }
            return null;
        }

        private void convertMapWork(MapWork mapWork) throws SemanticException {
            boolean ret = this.validateMapWork(mapWork);
            if (ret) {
                this.vectorizeMapWork(mapWork);
            }
        }

        private boolean validateMapWork(MapWork mapWork) throws SemanticException {
            for (String path : mapWork.getPathToPartitionInfo().keySet()) {
                PartitionDesc pd = mapWork.getPathToPartitionInfo().get(path);
                List<Class<?>> interfaceList = Arrays.asList(pd.getInputFileFormatClass().getInterfaces());
                if (interfaceList.contains(VectorizedInputFormatInterface.class)) continue;
                LOG.info((Object)("Input format: " + pd.getInputFileFormatClassName() + ", doesn't provide vectorized input"));
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ValidationNodeProcessor vnp = new ValidationNodeProcessor();
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), vnp);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private void vectorizeMapWork(MapWork mapWork) throws SemanticException {
            LOG.info((Object)"Vectorizing task...");
            mapWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            VectorizationNodeProcessor vnp = new VectorizationNodeProcessor(mapWork);
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), vnp);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            Map<String, Map<Integer, String>> columnVectorTypes = vnp.getScratchColumnVectorTypes();
            mapWork.setScratchColumnVectorTypes(columnVectorTypes);
            Map<String, Map<String, Integer>> columnMap = vnp.getScratchColumnMap();
            mapWork.setScratchColumnMap(columnMap);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("vectorTypes: %s", columnVectorTypes.toString()));
                LOG.debug((Object)String.format("columnMap: %s", columnMap.toString()));
            }
        }
    }
}

