/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExplainWork;

public class ExplainSemanticAnalyzer
extends BaseSemanticAnalyzer {
    List<FieldSchema> fieldList;

    public ExplainSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        boolean extended = false;
        boolean formatted = false;
        boolean dependency = false;
        boolean logical = false;
        if (ast.getChildCount() == 2) {
            int explainOptions = ast.getChild(1).getType();
            formatted = explainOptions == 113;
            extended = explainOptions == 101;
            dependency = explainOptions == 81;
            logical = explainOptions == 155;
        }
        this.ctx.setExplain(true);
        this.ctx.setExplainLogical(logical);
        ASTNode input = (ASTNode)ast.getChild(0);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.conf, input);
        sem.analyze(input, this.ctx);
        sem.validate();
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        List<Task<Serializable>> tasks = sem.getRootTasks();
        FetchTask fetchTask = sem.getFetchTask();
        if (tasks == null) {
            tasks = Collections.emptyList();
        }
        ParseContext pCtx = null;
        if (sem instanceof SemanticAnalyzer) {
            pCtx = ((SemanticAnalyzer)sem).getParseContext();
        }
        ExplainWork work = new ExplainWork(this.ctx.getResFile(), pCtx, tasks, fetchTask, input.dump(), sem.getInputs(), extended, formatted, dependency, logical);
        work.setAppendTaskType(HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEEXPLAINDEPENDENCYAPPENDTASKTYPES));
        Task<ExplainWork> explTask = TaskFactory.get(work, this.conf, new Task[0]);
        this.fieldList = explTask.getResultSchema();
        this.rootTasks.add(explTask);
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.fieldList;
    }
}

