/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;

public class GenTezWork
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)GenTezWork.class.getName());
    private GenTezUtils utils = null;

    public GenTezWork(GenTezUtils utils) {
        this.utils = utils;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        BaseWork work;
        GenTezProcContext context = (GenTezProcContext)procContext;
        assert (context != null && context.currentTask != null && context.currentRootOperator != null);
        Operator operator = (Operator)nd;
        Operator<? extends OperatorDesc> root = context.currentRootOperator;
        LOG.debug((Object)("Root operator: " + root));
        LOG.debug((Object)("Leaf operator: " + operator));
        if (context.clonedReduceSinks.contains(operator)) {
            return null;
        }
        TezWork tezWork = (TezWork)context.currentTask.getWork();
        if (context.rootToWorkMap.containsKey(root)) {
            work = context.rootToWorkMap.get(root);
        } else {
            work = context.preceedingWork == null ? this.utils.createMapWork(context, root, tezWork, null) : this.utils.createReduceWork(context, root, tezWork);
            context.rootToWorkMap.put(root, work);
        }
        if (!context.childToWorkMap.containsKey(operator)) {
            LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
            workItems.add(work);
            context.childToWorkMap.put(operator, workItems);
        } else {
            context.childToWorkMap.get(operator).add(work);
        }
        if (!context.currentMapJoinOperators.isEmpty()) {
            for (MapJoinOperator mapJoinOperator : context.currentMapJoinOperators) {
                Map<BaseWork, TezEdgeProperty> linkWorkMap;
                LOG.debug((Object)("Processing map join: " + mapJoinOperator));
                if (!context.mapJoinWorkMap.containsKey(mapJoinOperator)) {
                    LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
                    workItems.add(work);
                    context.mapJoinWorkMap.put(mapJoinOperator, workItems);
                } else {
                    context.mapJoinWorkMap.get(mapJoinOperator).add(work);
                }
                if (!context.linkOpWithWorkMap.containsKey(mapJoinOperator) || (linkWorkMap = context.linkOpWithWorkMap.get(mapJoinOperator)) == null) continue;
                if (context.linkChildOpWithDummyOp.containsKey(mapJoinOperator)) {
                    for (Operator operator2 : context.linkChildOpWithDummyOp.get(mapJoinOperator)) {
                        work.addDummyOp((HashTableDummyOperator)operator2);
                    }
                }
                for (Map.Entry entry : linkWorkMap.entrySet()) {
                    BaseWork parentWork = (BaseWork)entry.getKey();
                    LOG.debug((Object)("connecting " + parentWork.getName() + " with " + work.getName()));
                    TezEdgeProperty edgeProp = (TezEdgeProperty)entry.getValue();
                    tezWork.connect(parentWork, work, edgeProp);
                    for (ReduceSinkOperator r : context.linkWorkWithReduceSinkMap.get(parentWork)) {
                        if (((ReduceSinkDesc)r.getConf()).getOutputName() != null) {
                            LOG.debug((Object)"Cloning reduce sink for multi-child broadcast edge");
                            r = (ReduceSinkOperator)OperatorFactory.getAndMakeChild((ReduceSinkDesc)((ReduceSinkDesc)r.getConf()).clone(), r.getParentOperators());
                            context.clonedReduceSinks.add(r);
                        }
                        ((ReduceSinkDesc)r.getConf()).setOutputName(work.getName());
                        context.connectedReduceSinks.add(r);
                    }
                }
            }
            context.currentMapJoinOperators.clear();
        }
        for (Operator operator3 : new ArrayList<Operator<OperatorDesc>>(root.getParentOperators())) {
            context.leafOperatorToFollowingWork.put(operator3, work);
            LOG.debug((Object)("Removing " + operator3 + " as parent from " + root));
            root.removeParent(operator3);
        }
        if (!context.currentUnionOperators.isEmpty()) {
            UnionWork unionWork;
            if (context.unionWorkMap.containsKey(operator)) {
                assert (operator.getChildOperators().isEmpty());
                unionWork = (UnionWork)context.unionWorkMap.get(operator);
            } else {
                unionWork = this.utils.createUnionWork(context, operator, tezWork);
            }
            LOG.debug((Object)("Connecting union work (" + unionWork + ") with work (" + work + ")"));
            TezEdgeProperty tezEdgeProperty = new TezEdgeProperty(TezEdgeProperty.EdgeType.CONTAINS);
            tezWork.connect(unionWork, work, tezEdgeProperty);
            unionWork.addUnionOperators(context.currentUnionOperators);
            context.currentUnionOperators.clear();
            context.workWithUnionOperators.add(work);
            work = unionWork;
        }
        if (context.leafOperatorToFollowingWork.containsKey(operator)) {
            BaseWork followingWork = context.leafOperatorToFollowingWork.get(operator);
            LOG.debug((Object)("Second pass. Leaf operator: " + operator + " has common downstream work:" + followingWork));
            assert (operator instanceof ReduceSinkOperator && followingWork instanceof ReduceWork);
            ReduceSinkOperator reduceSinkOperator = (ReduceSinkOperator)operator;
            ReduceWork rWork = (ReduceWork)followingWork;
            GenMapRedUtils.setKeyAndValueDesc(rWork, reduceSinkOperator);
            rWork.getTagToInput().put(((ReduceSinkDesc)reduceSinkOperator.getConf()).getTag(), work.getName());
            ((ReduceSinkDesc)reduceSinkOperator.getConf()).setOutputName(rWork.getName());
            if (!context.connectedReduceSinks.contains(reduceSinkOperator)) {
                TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
                tezWork.connect(work, rWork, edgeProp);
                context.connectedReduceSinks.add(reduceSinkOperator);
            }
        } else {
            LOG.debug((Object)("First pass. Leaf operator: " + operator));
        }
        if (!operator.getChildOperators().isEmpty()) {
            assert (operator.getChildOperators().size() == 1);
            context.parentOfRoot = operator;
            context.currentRootOperator = operator.getChildOperators().get(0);
            context.preceedingWork = work;
        }
        return null;
    }
}

