/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnStatsTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.IndexUpdater;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;

public abstract class TaskCompiler {
    protected final Log LOG = LogFactory.getLog(TaskCompiler.class);
    protected Hive db;
    protected SessionState.LogHelper console;
    protected HiveConf conf;

    public void init(HiveConf conf, SessionState.LogHelper console, Hive db) {
        this.conf = conf;
        this.db = db;
        this.console = console;
    }

    public void compile(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        Context ctx = pCtx.getContext();
        GlobalLimitCtx globalLimitCtx = pCtx.getGlobalLimitCtx();
        QB qb = pCtx.getQB();
        ArrayList<Task<MoveWork>> mvTask = new ArrayList<Task<MoveWork>>();
        List<LoadTableDesc> loadTableWork = pCtx.getLoadTableWork();
        List<LoadFileDesc> loadFileWork = pCtx.getLoadFileWork();
        boolean isCStats = qb.isAnalyzeRewrite();
        if (pCtx.getFetchTask() != null) {
            return;
        }
        this.optimizeOperatorPlan(pCtx, inputs, outputs);
        if (pCtx.getQB().getIsQuery() && !isCStats) {
            if (!loadTableWork.isEmpty() || loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            LoadFileDesc loadFileDesc = loadFileWork.get(0);
            String cols = loadFileDesc.getColumns();
            String colTypes = loadFileDesc.getColumnTypes();
            TableDesc resultTab = pCtx.getFetchTabledesc();
            if (resultTab == null) {
                String string = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, string);
            }
            FetchWork fetchWork = new FetchWork(loadFileDesc.getSourcePath(), resultTab, qb.getParseInfo().getOuterQueryLimit());
            fetchWork.setSource(pCtx.getFetchSource());
            fetchWork.setSink(pCtx.getFetchSink());
            pCtx.setFetchTask((FetchTask)TaskFactory.get(fetchWork, this.conf, new Task[0]));
            int fetchLimit = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVELIMITOPTMAXFETCH);
            if (globalLimitCtx.isEnable() && globalLimitCtx.getGlobalLimit() > fetchLimit) {
                this.LOG.info((Object)("For FetchTask, LIMIT " + globalLimitCtx.getGlobalLimit() + " > " + fetchLimit + ". Doesn't qualify limit optimiztion."));
                globalLimitCtx.disableOpt();
            }
        } else if (!isCStats) {
            for (LoadTableDesc ltd : loadTableWork) {
                ExecDriver tsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false), this.conf, new Task[0]);
                mvTask.add(tsk);
                if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEINDEXAUTOUPDATE)) continue;
                IndexUpdater indexUpdater = new IndexUpdater(loadTableWork, inputs, (Configuration)this.conf);
                try {
                    List<Task<? extends Serializable>> list = indexUpdater.generateUpdateTasks();
                    for (Task<? extends Serializable> updateTask : list) {
                        tsk.addDependentTask(updateTask);
                    }
                }
                catch (HiveException hiveException) {
                    this.console.printInfo("WARNING: could not auto-update stale indexes, which are not in sync");
                }
            }
            boolean oneLoadFile = true;
            for (LoadFileDesc lfd : loadFileWork) {
                if (qb.isCTAS()) {
                    Path location;
                    assert (oneLoadFile);
                    String string = qb.getTableDesc().getLocation();
                    if (string == null) {
                        Path targetPath;
                        try {
                            Table dumpTable = this.db.newTable(qb.getTableDesc().getTableName());
                            if (!this.db.databaseExists(dumpTable.getDbName())) {
                                throw new SemanticException("ERROR: The database " + dumpTable.getDbName() + " does not exist.");
                            }
                            Warehouse wh = new Warehouse((Configuration)this.conf);
                            targetPath = wh.getTablePath(this.db.getDatabase(dumpTable.getDbName()), dumpTable.getTableName());
                        }
                        catch (HiveException e) {
                            throw new SemanticException(e);
                        }
                        catch (MetaException e) {
                            throw new SemanticException(e);
                        }
                        location = targetPath;
                    } else {
                        location = new Path(string);
                    }
                    lfd.setTargetDir(location);
                    oneLoadFile = false;
                }
                mvTask.add(TaskFactory.get(new MoveWork(null, null, null, lfd, false), this.conf, new Task[0]));
            }
        }
        this.generateTaskTree(rootTasks, pCtx, mvTask, inputs, outputs);
        if (isCStats) {
            this.genColumnStatsTask(qb, loadTableWork, loadFileWork, rootTasks);
        }
        for (Task<? extends Serializable> rootTask : rootTasks) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(rootTask);
        }
        for (Task<? extends Serializable> rootTask : rootTasks) {
            this.setInputFormat(rootTask);
        }
        this.optimizeTaskPlan(rootTasks, pCtx, ctx);
        this.decideExecMode(rootTasks, ctx, globalLimitCtx);
        if (qb.isCTAS()) {
            CreateTableDesc crtTblDesc = qb.getTableDesc();
            crtTblDesc.validate(this.conf);
            outputs.clear();
            Task<DDLWork> crtTblTask = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc), this.conf, new Task[0]);
            LinkedHashSet<Task<? extends Serializable>> leaves = new LinkedHashSet<Task<? extends Serializable>>();
            this.getLeafTasks(rootTasks, leaves);
            assert (leaves.size() > 0);
            for (Task task : leaves) {
                if (task instanceof StatsTask) {
                    for (Task<Serializable> parentOfStatsTask : task.getParentTasks()) {
                        parentOfStatsTask.addDependentTask(crtTblTask);
                    }
                    for (Task<Serializable> parentOfCrtTblTask : crtTblTask.getParentTasks()) {
                        parentOfCrtTblTask.removeDependentTask(task);
                    }
                    crtTblTask.addDependentTask(task);
                    continue;
                }
                task.addDependentTask(crtTblTask);
            }
        }
        if (globalLimitCtx.isEnable() && pCtx.getFetchTask() != null) {
            this.LOG.info((Object)("set least row check for FetchTask: " + globalLimitCtx.getGlobalLimit()));
            ((FetchWork)pCtx.getFetchTask().getWork()).setLeastNumRows(globalLimitCtx.getGlobalLimit());
        }
        if (globalLimitCtx.isEnable() && globalLimitCtx.getLastReduceLimitDesc() != null) {
            this.LOG.info((Object)("set least row check for LimitDesc: " + globalLimitCtx.getGlobalLimit()));
            globalLimitCtx.getLastReduceLimitDesc().setLeastRows(globalLimitCtx.getGlobalLimit());
            List<ExecDriver> mrTasks = Utilities.getMRTasks(rootTasks);
            for (ExecDriver tsk : mrTasks) {
                tsk.setRetryCmdWhenFail(true);
            }
        }
    }

    protected void genColumnStatsTask(QB qb, List<LoadTableDesc> loadTableWork, List<LoadFileDesc> loadFileWork, List<Task<? extends Serializable>> rootTasks) {
        QBParseInfo qbParseInfo = qb.getParseInfo();
        ColumnStatsTask cStatsTask = null;
        ColumnStatsWork cStatsWork = null;
        FetchWork fetch = null;
        String tableName = qbParseInfo.getTableName();
        String partName = qbParseInfo.getPartName();
        List<String> colName = qbParseInfo.getColName();
        List<String> colType = qbParseInfo.getColType();
        boolean isTblLevel = qbParseInfo.isTblLvl();
        String cols = loadFileWork.get(0).getColumns();
        String colTypes = loadFileWork.get(0).getColumnTypes();
        String resFileFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
        TableDesc resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat);
        fetch = new FetchWork(loadFileWork.get(0).getSourcePath(), resultTab, qb.getParseInfo().getOuterQueryLimit());
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tableName, partName, colName, colType, isTblLevel);
        cStatsWork = new ColumnStatsWork(fetch, cStatsDesc);
        cStatsTask = (ColumnStatsTask)TaskFactory.get(cStatsWork, this.conf, new Task[0]);
        rootTasks.add(cStatsTask);
    }

    protected void getLeafTasks(List<Task<? extends Serializable>> rootTasks, HashSet<Task<? extends Serializable>> leaves) {
        for (Task<? extends Serializable> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<? extends Serializable> task, HashSet<Task<? extends Serializable>> leaves) {
        if (task.getDependentTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getDependentTasks(), leaves);
        }
    }

    protected abstract void decideExecMode(List<Task<? extends Serializable>> var1, Context var2, GlobalLimitCtx var3) throws SemanticException;

    protected void optimizeOperatorPlan(ParseContext pCtxSet, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
    }

    protected abstract void optimizeTaskPlan(List<Task<? extends Serializable>> var1, ParseContext var2, Context var3) throws SemanticException;

    protected abstract void setInputFormat(Task<? extends Serializable> var1);

    protected abstract void generateTaskTree(List<Task<? extends Serializable>> var1, ParseContext var2, List<Task<MoveWork>> var3, Set<ReadEntity> var4, Set<WriteEntity> var5) throws SemanticException;

    public ParseContext getParseContext(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks) {
        return new ParseContext(this.conf, pCtx.getQB(), pCtx.getParseTree(), pCtx.getOpToPartPruner(), pCtx.getOpToPartList(), pCtx.getTopOps(), pCtx.getTopSelOps(), pCtx.getOpParseCtx(), pCtx.getJoinContext(), pCtx.getSmbMapJoinContext(), pCtx.getTopToTable(), pCtx.getTopToProps(), pCtx.getFsopToTable(), pCtx.getLoadTableWork(), pCtx.getLoadFileWork(), pCtx.getContext(), pCtx.getIdToTableNameMap(), pCtx.getDestTableId(), pCtx.getUCtx(), pCtx.getListMapJoinOpsNoReducer(), pCtx.getGroupOpToInputTables(), pCtx.getPrunedPartitions(), pCtx.getOpToSamplePruner(), pCtx.getGlobalLimitCtx(), pCtx.getNameToSplitSample(), pCtx.getSemanticInputs(), rootTasks, pCtx.getOpToPartToSkewedPruner(), pCtx.getViewAliasToInput(), pCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting(), pCtx.getQueryProperties());
    }
}

