/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class ColStatistics {
    private String tabAlias;
    private String colName;
    private String colType;
    private String fqColName;
    private long countDistint;
    private long numNulls;
    private double avgColLen;
    private long numTrues;
    private long numFalses;

    public ColStatistics(String tabAlias, String colName, String colType) {
        this.setTableAlias(tabAlias);
        this.setColumnName(colName);
        this.setColumnType(colType);
        this.setFullyQualifiedColName(StatsUtils.getFullyQualifiedColumnName(tabAlias, colName));
    }

    public ColStatistics() {
        this(null, null, null);
    }

    public String getColumnName() {
        return this.colName;
    }

    public void setColumnName(String colName) {
        this.colName = colName;
        this.fqColName = StatsUtils.getFullyQualifiedColumnName(this.tabAlias, colName);
    }

    public String getColumnType() {
        return this.colType;
    }

    public void setColumnType(String colType) {
        this.colType = colType;
    }

    public long getCountDistint() {
        return this.countDistint;
    }

    public void setCountDistint(long countDistint) {
        this.countDistint = countDistint;
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
    }

    public double getAvgColLen() {
        return this.avgColLen;
    }

    public void setAvgColLen(double avgColLen) {
        this.avgColLen = avgColLen;
    }

    public String getFullyQualifiedColName() {
        return this.fqColName;
    }

    public void setFullyQualifiedColName(String fqColName) {
        this.fqColName = fqColName;
    }

    public String getTableAlias() {
        return this.tabAlias;
    }

    public void setTableAlias(String tabName) {
        this.tabAlias = tabName;
        this.fqColName = StatsUtils.getFullyQualifiedColumnName(tabName, this.colName);
    }

    public long getNumTrues() {
        return this.numTrues;
    }

    public void setNumTrues(long numTrues) {
        this.numTrues = numTrues;
    }

    public long getNumFalses() {
        return this.numFalses;
    }

    public void setNumFalses(long numFalses) {
        this.numFalses = numFalses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" fqColName: ");
        sb.append(this.fqColName);
        sb.append(" colName: ");
        sb.append(this.colName);
        sb.append(" colType: ");
        sb.append(this.colType);
        sb.append(" countDistincts: ");
        sb.append(this.countDistint);
        sb.append(" numNulls: ");
        sb.append(this.numNulls);
        sb.append(" avgColLen: ");
        sb.append(this.avgColLen);
        sb.append(" numTrues: ");
        sb.append(this.numTrues);
        sb.append(" numFalses: ");
        sb.append(this.numFalses);
        return sb.toString();
    }

    public ColStatistics clone() throws CloneNotSupportedException {
        ColStatistics clone = new ColStatistics(this.tabAlias, this.colName, this.colType);
        clone.setFullyQualifiedColName(this.fqColName);
        clone.setAvgColLen(this.avgColLen);
        clone.setCountDistint(this.countDistint);
        clone.setNumNulls(this.numNulls);
        clone.setNumTrues(this.numTrues);
        clone.setNumFalses(this.numFalses);
        return clone;
    }
}

