/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

@Explain(displayName="Drop Table")
public class DropTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    ArrayList<PartSpec> partSpecs;
    boolean expectView;
    boolean ifExists;
    boolean ignoreProtection;

    public DropTableDesc() {
    }

    public DropTableDesc(String tableName, boolean expectView, boolean ifExists) {
        this.tableName = tableName;
        this.partSpecs = null;
        this.expectView = expectView;
        this.ifExists = ifExists;
        this.ignoreProtection = false;
    }

    public DropTableDesc(String tableName, Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs, boolean expectView, boolean ignoreProtection) {
        this.tableName = tableName;
        this.partSpecs = new ArrayList(partSpecs.size());
        for (Map.Entry<Integer, List<ExprNodeGenericFuncDesc>> partSpec : partSpecs.entrySet()) {
            int prefixLength = partSpec.getKey();
            for (ExprNodeGenericFuncDesc expr : partSpec.getValue()) {
                this.partSpecs.add(new PartSpec(expr, prefixLength));
            }
        }
        this.ignoreProtection = ignoreProtection;
        this.expectView = expectView;
    }

    @Explain(displayName="table")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ArrayList<PartSpec> getPartSpecs() {
        return this.partSpecs;
    }

    public boolean getIgnoreProtection() {
        return this.ignoreProtection;
    }

    public void setIgnoreProtection(boolean ignoreProtection) {
        this.ignoreProtection = ignoreProtection;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public static class PartSpec {
        private static final long serialVersionUID = 1L;
        private ExprNodeGenericFuncDesc partSpec;
        private int prefixLength;

        public PartSpec(ExprNodeGenericFuncDesc partSpec, int prefixLength) {
            this.partSpec = partSpec;
            this.prefixLength = prefixLength;
        }

        public ExprNodeGenericFuncDesc getPartSpec() {
            return this.partSpec;
        }

        public int getPrefixLength() {
            return this.prefixLength;
        }
    }
}

