/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Reduce Output Operator")
public class ReduceSinkDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private ArrayList<ExprNodeDesc> keyCols;
    private ArrayList<String> outputKeyColumnNames;
    private List<List<Integer>> distinctColumnIndices;
    private ArrayList<ExprNodeDesc> valueCols;
    private ArrayList<String> outputValueColumnNames;
    private TableDesc keySerializeInfo;
    private TableDesc valueSerializeInfo;
    private int tag;
    private int numDistributionKeys;
    private String outputName;
    private ArrayList<ExprNodeDesc> partitionCols;
    private int numReducers;
    private int numBuckets;
    private List<ExprNodeDesc> bucketCols;
    private int topN = -1;
    private float topNMemoryUsage = -1.0f;
    private boolean mapGroupBy;

    public ReduceSinkDesc() {
    }

    public ReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, int numDistributionKeys, ArrayList<ExprNodeDesc> valueCols, ArrayList<String> outputKeyColumnNames, List<List<Integer>> distinctColumnIndices, ArrayList<String> outputValueColumnNames, int tag, ArrayList<ExprNodeDesc> partitionCols, int numReducers, TableDesc keySerializeInfo, TableDesc valueSerializeInfo) {
        this.keyCols = keyCols;
        this.numDistributionKeys = numDistributionKeys;
        this.valueCols = valueCols;
        this.outputKeyColumnNames = outputKeyColumnNames;
        this.outputValueColumnNames = outputValueColumnNames;
        this.tag = tag;
        this.numReducers = numReducers;
        this.partitionCols = partitionCols;
        this.keySerializeInfo = keySerializeInfo;
        this.valueSerializeInfo = valueSerializeInfo;
        this.distinctColumnIndices = distinctColumnIndices;
        this.setNumBuckets(-1);
        this.setBucketCols(null);
    }

    @Override
    public Object clone() {
        ReduceSinkDesc desc = new ReduceSinkDesc();
        desc.setKeyCols((ArrayList)this.getKeyCols().clone());
        desc.setValueCols((ArrayList)this.getValueCols().clone());
        desc.setOutputKeyColumnNames((ArrayList)this.getOutputKeyColumnNames().clone());
        ArrayList<List<Integer>> distinctColumnIndicesClone = new ArrayList<List<Integer>>();
        for (List<Integer> distinctColumnIndex : this.getDistinctColumnIndices()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            tmp.addAll(distinctColumnIndex);
            distinctColumnIndicesClone.add(tmp);
        }
        desc.setDistinctColumnIndices(distinctColumnIndicesClone);
        desc.setOutputValueColumnNames((ArrayList)this.getOutputValueColumnNames().clone());
        desc.setNumDistributionKeys(this.getNumDistributionKeys());
        desc.setTag(this.getTag());
        desc.setNumReducers(this.getNumReducers());
        desc.setPartitionCols((ArrayList)this.getPartitionCols().clone());
        desc.setKeySerializeInfo((TableDesc)this.getKeySerializeInfo().clone());
        desc.setValueSerializeInfo((TableDesc)this.getValueSerializeInfo().clone());
        desc.setNumBuckets(this.numBuckets);
        desc.setBucketCols(this.bucketCols);
        desc.setStatistics(this.getStatistics());
        return desc;
    }

    public ArrayList<String> getOutputKeyColumnNames() {
        return this.outputKeyColumnNames;
    }

    public void setOutputKeyColumnNames(ArrayList<String> outputKeyColumnNames) {
        this.outputKeyColumnNames = outputKeyColumnNames;
    }

    public ArrayList<String> getOutputValueColumnNames() {
        return this.outputValueColumnNames;
    }

    public void setOutputValueColumnNames(ArrayList<String> outputValueColumnNames) {
        this.outputValueColumnNames = outputValueColumnNames;
    }

    @Explain(displayName="key expressions")
    public String getKeyColString() {
        return PlanUtils.getExprListString(this.keyCols);
    }

    public ArrayList<ExprNodeDesc> getKeyCols() {
        return this.keyCols;
    }

    public void setKeyCols(ArrayList<ExprNodeDesc> keyCols) {
        this.keyCols = keyCols;
    }

    public int getNumDistributionKeys() {
        return this.numDistributionKeys;
    }

    public void setNumDistributionKeys(int numKeys) {
        this.numDistributionKeys = numKeys;
    }

    @Explain(displayName="value expressions")
    public String getValueColsString() {
        return PlanUtils.getExprListString(this.valueCols);
    }

    public ArrayList<ExprNodeDesc> getValueCols() {
        return this.valueCols;
    }

    public void setValueCols(ArrayList<ExprNodeDesc> valueCols) {
        this.valueCols = valueCols;
    }

    @Explain(displayName="Map-reduce partition columns")
    public String getParitionColsString() {
        return PlanUtils.getExprListString(this.partitionCols);
    }

    public ArrayList<ExprNodeDesc> getPartitionCols() {
        return this.partitionCols;
    }

    public void setPartitionCols(ArrayList<ExprNodeDesc> partitionCols) {
        this.partitionCols = partitionCols;
    }

    @Explain(displayName="tag", normalExplain=false)
    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Explain(displayName="TopN", normalExplain=false)
    public Integer getTopNExplain() {
        return this.topN > 0 ? Integer.valueOf(this.topN) : null;
    }

    public float getTopNMemoryUsage() {
        return this.topNMemoryUsage;
    }

    public void setTopNMemoryUsage(float topNMemoryUsage) {
        this.topNMemoryUsage = topNMemoryUsage;
    }

    @Explain(displayName="TopN Hash Memory Usage")
    public Float getTopNMemoryUsageExplain() {
        return this.topN > 0 && this.topNMemoryUsage > 0.0f ? Float.valueOf(this.topNMemoryUsage) : null;
    }

    public boolean isMapGroupBy() {
        return this.mapGroupBy;
    }

    public void setMapGroupBy(boolean mapGroupBy) {
        this.mapGroupBy = mapGroupBy;
    }

    public int getNumReducers() {
        return this.numReducers;
    }

    public void setNumReducers(int numReducers) {
        this.numReducers = numReducers;
    }

    public TableDesc getKeySerializeInfo() {
        return this.keySerializeInfo;
    }

    public void setKeySerializeInfo(TableDesc keySerializeInfo) {
        this.keySerializeInfo = keySerializeInfo;
    }

    public TableDesc getValueSerializeInfo() {
        return this.valueSerializeInfo;
    }

    public void setValueSerializeInfo(TableDesc valueSerializeInfo) {
        this.valueSerializeInfo = valueSerializeInfo;
    }

    @Explain(displayName="sort order")
    public String getOrder() {
        return this.keySerializeInfo.getProperties().getProperty("serialization.sort.order");
    }

    public void setOrder(String orderStr) {
        this.keySerializeInfo.getProperties().setProperty("serialization.sort.order", orderStr);
    }

    public List<List<Integer>> getDistinctColumnIndices() {
        return this.distinctColumnIndices;
    }

    public void setDistinctColumnIndices(List<List<Integer>> distinctColumnIndices) {
        this.distinctColumnIndices = distinctColumnIndices;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    public List<ExprNodeDesc> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(List<ExprNodeDesc> bucketCols) {
        this.bucketCols = bucketCols;
    }
}

