/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;

public class TableDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends HiveOutputFormat> outputFileFormatClass;
    private Properties properties;
    private Map<String, String> jobProperties;

    public TableDesc() {
    }

    public TableDesc(Class<? extends InputFormat> inputFormatClass, Class<?> outputFormatClass, Properties properties) {
        this.inputFileFormatClass = inputFormatClass;
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFormatClass, false);
        this.properties = properties;
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        try {
            return Class.forName(this.getSerdeClassName(), true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        return this.inputFileFormatClass;
    }

    public Deserializer getDeserializer() throws Exception {
        Deserializer de = this.getDeserializerClass().newInstance();
        de.initialize(null, this.properties);
        return de;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass;
    }

    public Class<? extends HiveOutputFormat> getOutputFileFormatClass() {
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass, false);
    }

    @Explain(displayName="properties", normalExplain=false)
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setJobProperties(Map<String, String> jobProperties) {
        this.jobProperties = jobProperties;
    }

    @Explain(displayName="jobProperties", normalExplain=false)
    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    @Explain(displayName="serde")
    public String getSerdeClassName() {
        return this.properties.getProperty("serialization.lib");
    }

    @Explain(displayName="name")
    public String getTableName() {
        return this.properties.getProperty("name");
    }

    @Explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @Explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        if (this.getOutputFileFormatClass().getName() == "org.apache.hadoop.hive.ql.io.HivePassThroughOutputFormat") {
            return HiveFileFormatUtils.getRealOutputFormatClassName();
        }
        return this.getOutputFileFormatClass().getName();
    }

    public boolean isNonNative() {
        return this.properties.getProperty("storage_handler") != null;
    }

    public Object clone() {
        TableDesc ret = new TableDesc();
        ret.setInputFileFormatClass(this.inputFileFormatClass);
        ret.setOutputFileFormatClass(this.outputFileFormatClass);
        Properties newProp = new Properties();
        Enumeration<Object> keysProp = this.properties.keys();
        while (keysProp.hasMoreElements()) {
            Object key = keysProp.nextElement();
            newProp.put(key, this.properties.get(key));
        }
        ret.setProperties(newProp);
        if (this.jobProperties != null) {
            ret.jobProperties = new LinkedHashMap<String, String>(this.jobProperties);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputFileFormatClass == null ? 0 : this.inputFileFormatClass.hashCode());
        result = 31 * result + (this.outputFileFormatClass == null ? 0 : this.outputFileFormatClass.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.jobProperties == null ? 0 : ((Object)this.jobProperties).hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableDesc)) {
            return false;
        }
        TableDesc target = (TableDesc)o;
        boolean ret = true;
        boolean bl = ret && (this.inputFileFormatClass == null ? target.inputFileFormatClass == null : this.inputFileFormatClass.equals(target.inputFileFormatClass)) ? true : (ret = false);
        boolean bl2 = ret && (this.outputFileFormatClass == null ? target.outputFileFormatClass == null : this.outputFileFormatClass.equals(target.outputFileFormatClass)) ? true : (ret = false);
        boolean bl3 = ret && (this.properties == null ? target.properties == null : this.properties.equals(target.properties)) ? true : (ret = false);
        ret = ret && (this.jobProperties == null ? target.jobProperties == null : ((Object)this.jobProperties).equals(target.jobProperties));
        return ret;
    }
}

