/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerProcFactory;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.JobConf;

public final class OpProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());

    private static ExprWalkerInfo getChildWalkerInfo(Operator<?> current, OpWalkerInfo owi) {
        if (current.getNumChild() == 0) {
            return null;
        }
        if (current.getNumChild() > 1) {
            for (Operator<OperatorDesc> child : current.getChildOperators()) {
                OpProcFactory.removeCandidates(child, owi);
            }
            return null;
        }
        return owi.getPrunedPreds(current.getChildOperators().get(0));
    }

    private static void removeCandidates(Operator<?> operator, OpWalkerInfo owi) {
        if (operator instanceof FilterOperator) {
            owi.getCandidateFilterOps().remove(operator);
        }
        if (operator.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : operator.getChildOperators()) {
                OpProcFactory.removeCandidates(child, owi);
            }
        }
    }

    protected static Object createFilter(Operator op, ExprWalkerInfo pushDownPreds, OpWalkerInfo owi) {
        if (pushDownPreds == null || pushDownPreds.getFinalCandidates() == null || pushDownPreds.getFinalCandidates().size() == 0) {
            return null;
        }
        return OpProcFactory.createFilter(op, pushDownPreds.getFinalCandidates(), owi);
    }

    protected static Object createFilter(Operator op, Map<String, List<ExprNodeDesc>> predicates, OpWalkerInfo owi) {
        HiveConf hiveConf;
        boolean pushFilterToStorage;
        RowResolver inputRR = owi.getRowResolver(op);
        List<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
        Iterator<List<ExprNodeDesc>> iterator = predicates.values().iterator();
        while (iterator.hasNext()) {
            for (ExprNodeDesc pred : iterator.next()) {
                preds = ExprNodeDescUtils.split(pred, preds);
            }
        }
        if (preds.isEmpty()) {
            return null;
        }
        ExprNodeDesc condn = ExprNodeDescUtils.mergePredicates(preds);
        if (!(condn instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        if (op instanceof TableScanOperator && (pushFilterToStorage = (hiveConf = owi.getParseContext().getConf()).getBoolVar(HiveConf.ConfVars.HIVEOPTPPD_STORAGE)) && (condn = OpProcFactory.pushFilterToStorageHandler((TableScanOperator)op, (ExprNodeGenericFuncDesc)condn, owi, hiveConf)) == null) {
            return null;
        }
        List<Operator<? extends OperatorDesc>> originalChilren = op.getChildOperators();
        op.setChildOperators(null);
        Operator<FilterDesc> output = OperatorFactory.getAndMakeChild(new FilterDesc(condn, false), new RowSchema(inputRR.getColumnInfos()), op);
        output.setChildOperators(originalChilren);
        for (Operator<? extends OperatorDesc> ch : originalChilren) {
            List<Operator<OperatorDesc>> parentOperators = ch.getParentOperators();
            int pos = parentOperators.indexOf(op);
            assert (pos != -1);
            parentOperators.remove(pos);
            parentOperators.add(pos, output);
        }
        OpParseContext ctx = new OpParseContext(inputRR);
        owi.put(output, ctx);
        if (HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
            for (FilterOperator fop : owi.getCandidateFilterOps()) {
                List<Operator<OperatorDesc>> children = fop.getChildOperators();
                List<Operator<OperatorDesc>> parents = fop.getParentOperators();
                for (Operator<OperatorDesc> parent : parents) {
                    parent.getChildOperators().addAll(children);
                    parent.removeChild(fop);
                }
                for (Operator<OperatorDesc> child : children) {
                    child.getParentOperators().addAll(parents);
                    child.removeParent(fop);
                }
            }
            owi.getCandidateFilterOps().clear();
        }
        return output;
    }

    private static ExprNodeGenericFuncDesc pushFilterToStorageHandler(TableScanOperator tableScanOp, ExprNodeGenericFuncDesc originalPredicate, OpWalkerInfo owi, HiveConf hiveConf) {
        TableScanDesc tableScanDesc = (TableScanDesc)tableScanOp.getConf();
        Table tbl = owi.getParseContext().getTopToTable().get(tableScanOp);
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTINDEXFILTER)) {
            tableScanDesc.setFilterExpr(originalPredicate);
        }
        if (!tbl.isNonNative()) {
            return originalPredicate;
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (!(storageHandler instanceof HiveStoragePredicateHandler)) {
            tableScanDesc.setFilterExpr(originalPredicate);
            return originalPredicate;
        }
        HiveStoragePredicateHandler predicateHandler = (HiveStoragePredicateHandler)((Object)storageHandler);
        JobConf jobConf = new JobConf((Configuration)owi.getParseContext().getConf());
        Utilities.setColumnNameList(jobConf, tableScanOp);
        Utilities.setColumnTypeList(jobConf, tableScanOp);
        Utilities.copyTableJobPropertiesToConf(Utilities.getTableDesc(tbl), jobConf);
        Deserializer deserializer = tbl.getDeserializer();
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = predicateHandler.decomposePredicate(jobConf, deserializer, originalPredicate);
        if (decomposed == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No pushdown possible for predicate:  " + originalPredicate.getExprString()));
            }
            return originalPredicate;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Original predicate:  " + originalPredicate.getExprString()));
            if (decomposed.pushedPredicate != null) {
                LOG.debug((Object)("Pushed predicate:  " + decomposed.pushedPredicate.getExprString()));
            }
            if (decomposed.residualPredicate != null) {
                LOG.debug((Object)("Residual predicate:  " + decomposed.residualPredicate.getExprString()));
            }
        }
        tableScanDesc.setFilterExpr(decomposed.pushedPredicate);
        return decomposed.residualPredicate;
    }

    public static NodeProcessor getFilterProc() {
        return new FilterPPD();
    }

    public static NodeProcessor getJoinProc() {
        return new JoinPPD();
    }

    public static NodeProcessor getTSProc() {
        return new TableScanPPD();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPD();
    }

    public static NodeProcessor getPTFProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getSCRProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getLIMProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getLVFProc() {
        return new LateralViewForwardPPD();
    }

    public static NodeProcessor getUDTFProc() {
        return new UDTFPPD();
    }

    public static NodeProcessor getLVJProc() {
        return new JoinerPPD();
    }

    private OpProcFactory() {
    }

    public static class DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> includes = this.getQualifiedAliases((Operator)nd, owi);
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, null, includes);
            if (hasUnpushedPredicates && HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                if (includes != null || nd instanceof ReduceSinkOperator) {
                    owi.getCandidateFilterOps().clear();
                } else {
                    ExprWalkerInfo pruned = owi.getPrunedPreds((Operator)nd);
                    Map<String, List<ExprNodeDesc>> residual = pruned.getResidualPredicates(true);
                    if (residual != null && !residual.isEmpty()) {
                        OpProcFactory.createFilter((Operator)nd, residual, owi);
                        pruned.getNonFinalCandidates().clear();
                    }
                }
            }
            return null;
        }

        private Set<String> getQualifiedAliases(Operator<?> operator, OpWalkerInfo owi) {
            if (operator.getNumChild() != 1) {
                return null;
            }
            Operator<OperatorDesc> child = operator.getChildOperators().get(0);
            if (!(child instanceof JoinOperator) && !(child instanceof LateralViewJoinOperator)) {
                return null;
            }
            if (operator instanceof ReduceSinkOperator && ((ReduceSinkOperator)operator).getInputAliases() != null) {
                String[] aliases = ((ReduceSinkOperator)operator).getInputAliases();
                return new HashSet<String>(Arrays.asList(aliases));
            }
            Set<String> includes = owi.getRowResolver(operator).getTableNames();
            if (includes.size() == 1 && includes.contains("")) {
                return null;
            }
            return includes;
        }

        protected void logExpr(Node nd, ExprWalkerInfo ewi) {
            for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
                LOG.info((Object)("Pushdown Predicates of " + nd.getName() + " For Alias : " + e.getKey()));
                for (ExprNodeDesc n : e.getValue()) {
                    LOG.info((Object)("\t" + n.getExprString()));
                }
            }
        }

        protected boolean mergeWithChildrenPred(Node nd, OpWalkerInfo owi, ExprWalkerInfo ewi, Set<String> aliases) throws SemanticException {
            Operator op = (Operator)nd;
            ExprWalkerInfo childPreds = OpProcFactory.getChildWalkerInfo(op, owi);
            if (childPreds == null) {
                return false;
            }
            if (ewi == null) {
                ewi = new ExprWalkerInfo();
            }
            boolean hasUnpushedPredicates = false;
            for (Map.Entry<String, List<ExprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                if (aliases != null && e.getKey() != null && !aliases.contains(e.getKey())) continue;
                ExprWalkerInfo extractPushdownPreds = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends OperatorDesc>)op, e.getValue());
                if (!extractPushdownPreds.getNonFinalCandidates().isEmpty()) {
                    hasUnpushedPredicates = true;
                }
                ewi.merge(extractPushdownPreds);
                this.logExpr(nd, extractPushdownPreds);
            }
            owi.putPrunedPreds((Operator)nd, ewi);
            return hasUnpushedPredicates;
        }

        protected ExprWalkerInfo mergeChildrenPred(Node nd, OpWalkerInfo owi, Set<String> excludedAliases, boolean ignoreAliases) throws SemanticException {
            if (nd.getChildren() == null) {
                return null;
            }
            Operator op = (Operator)nd;
            ExprWalkerInfo ewi = new ExprWalkerInfo();
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                ExprWalkerInfo childPreds = owi.getPrunedPreds(child);
                if (childPreds == null) continue;
                for (Map.Entry<String, List<ExprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                    if (!ignoreAliases && excludedAliases != null && excludedAliases.contains(e.getKey()) && e.getKey() != null) continue;
                    ewi.addPushDowns(e.getKey(), e.getValue());
                    this.logExpr(nd, ewi);
                }
            }
            return ewi;
        }
    }

    public static class JoinPPD
    extends JoinerPPD {
        @Override
        protected Set<String> getAliases(Node nd, OpWalkerInfo owi) {
            return this.getQualifiedAliases((JoinOperator)nd, owi.getRowResolver(nd));
        }

        @Override
        protected Object handlePredicates(Node nd, ExprWalkerInfo prunePreds, OpWalkerInfo owi) throws SemanticException {
            if (HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDRECOGNIZETRANSITIVITY)) {
                this.applyFilterTransitivity((JoinOperator)nd, owi);
            }
            return super.handlePredicates(nd, prunePreds, owi);
        }

        private void applyFilterTransitivity(JoinOperator nd, OpWalkerInfo owi) throws SemanticException {
            ExprWalkerInfo prunePreds = owi.getPrunedPreds(nd);
            if (prunePreds != null) {
                HashMap<String, RowResolver> aliasToRR = new HashMap<String, RowResolver>();
                for (Operator<OperatorDesc> o : nd.getParentOperators()) {
                    for (String alias : owi.getRowResolver(o).getTableNames()) {
                        aliasToRR.put(alias, owi.getRowResolver(o));
                    }
                }
                ArrayList<ArrayList<ASTNode>> eqExpressions = owi.getParseContext().getJoinContext().get(nd).getExpressions();
                int numColumns = eqExpressions.size();
                int numEqualities = eqExpressions.get(0).size();
                JoinCondDesc[] joins = ((JoinDesc)nd.getConf()).getConds();
                Map<String, List<ExprNodeDesc>> oldFilters = prunePreds.getFinalCandidates();
                HashMap newFilters = new HashMap();
                for (int i = 0; i < numEqualities; ++i) {
                    int j;
                    ColumnInfo[] equalColumns = new ColumnInfo[numColumns];
                    for (j = 0; j < numColumns; ++j) {
                        equalColumns[j] = this.getColumnInfoFromAST(eqExpressions.get(j).get(i), aliasToRR);
                    }
                    for (j = 0; j < numColumns; ++j) {
                        for (int k = 0; k < numColumns; ++k) {
                            if (j == k || equalColumns[j] == null || equalColumns[k] == null) continue;
                            ColumnInfo left = equalColumns[j];
                            ColumnInfo right = equalColumns[k];
                            if (oldFilters.get(left.getTabAlias()) == null) continue;
                            for (ExprNodeDesc expr : oldFilters.get(left.getTabAlias())) {
                                HashSet<String> colsreferenced = new HashSet<String>(expr.getCols());
                                if (colsreferenced.size() != 1 || !colsreferenced.contains(left.getInternalName())) continue;
                                ExprNodeDesc newexpr = expr.clone();
                                this.replaceColumnReference(newexpr, left.getInternalName(), right.getInternalName());
                                if (newFilters.get(right.getTabAlias()) == null) {
                                    newFilters.put(right.getTabAlias(), new ArrayList());
                                }
                                ((List)newFilters.get(right.getTabAlias())).add(newexpr);
                            }
                        }
                    }
                }
                for (Map.Entry aliasToFilters : newFilters.entrySet()) {
                    owi.getPrunedPreds(nd).addPushDowns((String)aliasToFilters.getKey(), (List)aliasToFilters.getValue());
                }
            }
        }

        private ColumnInfo getColumnInfoFromAST(ASTNode nd, Map<String, RowResolver> aliastoRR) throws SemanticException {
            if (nd.getType() == 17 && nd.getChildCount() == 2 && nd.getChild(0).getType() == 848 && nd.getChild(0).getChildCount() == 1 && nd.getChild(1).getType() == 26) {
                String alias = BaseSemanticAnalyzer.unescapeIdentifier(nd.getChild(0).getChild(0).getText().toLowerCase());
                String column = BaseSemanticAnalyzer.unescapeIdentifier(nd.getChild(1).getText().toLowerCase());
                RowResolver rr = aliastoRR.get(alias);
                if (rr == null) {
                    return null;
                }
                return rr.get(alias, column);
            }
            return null;
        }

        private void replaceColumnReference(ExprNodeDesc expr, String oldColumn, String newColumn) {
            if (expr instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)expr).getColumn().equals(oldColumn)) {
                ((ExprNodeColumnDesc)expr).setColumn(newColumn);
            }
            if (expr.getChildren() != null) {
                for (ExprNodeDesc childexpr : expr.getChildren()) {
                    this.replaceColumnReference(childexpr, oldColumn, newColumn);
                }
            }
        }

        private Set<String> getQualifiedAliases(JoinOperator op, RowResolver rr) {
            int i;
            HashSet<String> aliases = new HashSet<String>();
            JoinCondDesc[] conds = ((JoinDesc)op.getConf()).getConds();
            Map<Integer, Set<String>> posToAliasMap = op.getPosToAliasMap();
            for (i = conds.length - 1; i >= 0; --i) {
                if (conds[i].getType() == 0) {
                    aliases.addAll((Collection<String>)posToAliasMap.get(i + 1));
                    continue;
                }
                if (conds[i].getType() == 3) break;
                if (conds[i].getType() == 2) {
                    aliases.addAll((Collection<String>)posToAliasMap.get(i + 1));
                    break;
                }
                if (conds[i].getType() != 1) continue;
            }
            if (i == -1) {
                aliases.addAll((Collection)posToAliasMap.get(0));
            }
            Set<String> aliases2 = rr.getTableNames();
            aliases.retainAll(aliases2);
            return aliases;
        }
    }

    public static class JoinerPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> aliases = this.getAliases(nd, owi);
            this.mergeWithChildrenPred(nd, owi, null, null);
            ExprWalkerInfo prunePreds = owi.getPrunedPreds((Operator)nd);
            if (prunePreds != null) {
                HashSet<String> toRemove = new HashSet<String>();
                for (String key : prunePreds.getFinalCandidates().keySet()) {
                    if (aliases.contains(key)) continue;
                    toRemove.add(key);
                }
                for (String alias : toRemove) {
                    for (ExprNodeDesc expr : prunePreds.getFinalCandidates().get(alias)) {
                        prunePreds.addAlias(expr, alias);
                        prunePreds.addNonFinalCandidate(expr);
                    }
                    prunePreds.getFinalCandidates().remove(alias);
                }
                return this.handlePredicates(nd, prunePreds, owi);
            }
            return null;
        }

        protected Set<String> getAliases(Node nd, OpWalkerInfo owi) throws SemanticException {
            return owi.getRowResolver(nd).getTableNames();
        }

        protected Object handlePredicates(Node nd, ExprWalkerInfo prunePreds, OpWalkerInfo owi) throws SemanticException {
            if (HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                return OpProcFactory.createFilter((Operator)nd, prunePreds.getResidualPredicates(true), owi);
            }
            return null;
        }
    }

    public static class FilterPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Operator op = (Operator)nd;
            ExprNodeDesc predicate = ((FilterDesc)((FilterOperator)nd).getConf()).getPredicate();
            ExprWalkerInfo ewi = new ExprWalkerInfo();
            if (!((FilterDesc)((FilterOperator)op).getConf()).getIsSamplingPred()) {
                ewi = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends OperatorDesc>)op, predicate);
                if (!ewi.isDeterministic()) {
                    if (op.getChildren() != null && ((ArrayList)op.getChildren()).size() == 1) {
                        OpProcFactory.createFilter(op, owi.getPrunedPreds((Operator)((ArrayList)op.getChildren()).get(0)), owi);
                    }
                    return null;
                }
                if (HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS) && ewi.getNonFinalCandidates().values().isEmpty()) {
                    owi.addCandidateFilterOp((FilterOperator)op);
                }
                this.logExpr(nd, ewi);
                owi.putPrunedPreds((Operator)nd, ewi);
            }
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, ewi, null);
            if (HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS) && hasUnpushedPredicates) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }
    }

    public static class TableScanPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            TableScanOperator tsOp = (TableScanOperator)nd;
            this.mergeWithChildrenPred(tsOp, owi, null, null);
            ExprWalkerInfo pushDownPreds = owi.getPrunedPreds(tsOp);
            return OpProcFactory.createFilter((Operator)tsOp, pushDownPreds, owi);
        }
    }

    public static class LateralViewForwardPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo childPreds = owi.getPrunedPreds((Operator)nd.getChildren().get(0));
            owi.putPrunedPreds((Operator)nd, childPreds);
            return null;
        }
    }

    public static class UDTFPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, procCtx, nodeOutputs);
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo prunedPred = owi.getPrunedPreds((Operator)nd);
            if (prunedPred == null) {
                return null;
            }
            Map<String, List<ExprNodeDesc>> candidates = prunedPred.getFinalCandidates();
            if (candidates != null && !candidates.isEmpty()) {
                OpProcFactory.createFilter((Operator)nd, prunedPred, owi);
                candidates.clear();
            }
            return null;
        }
    }

    public static class ScriptPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo childInfo = OpProcFactory.getChildWalkerInfo((Operator)nd, owi);
            if (childInfo != null && HiveConf.getBoolVar((Configuration)owi.getParseContext().getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }
    }
}

