/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.List;
import java.util.Locale;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={""})
@InterfaceStability.Evolving
public class HivePrivilege {
    private final String name;
    private final List<String> columns;

    public String toString() {
        return "Privilege [name=" + this.name + ", columns=" + this.columns + "]";
    }

    public HivePrivilege(String name, List<String> columns) {
        this.name = name.toUpperCase(Locale.US);
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : ((Object)this.columns).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HivePrivilege other = (HivePrivilege)obj;
        if (this.columns == null ? other.columns != null : !((Object)this.columns).equals(other.columns)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

