/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.util.ReflectionUtils;

public final class StatsFactory {
    private static final Log LOG = LogFactory.getLog((String)StatsFactory.class.getName());
    private Class<? extends Serializable> publisherImplementation;
    private Class<? extends Serializable> aggregatorImplementation;
    private final Configuration jobConf;

    public static int getMaxPrefixLength(Configuration conf) {
        if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.fs.name())) {
            return -1;
        }
        int maxPrefixLength = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX_MAX_LENGTH);
        if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.counter.name())) {
            int groupNameMax = conf.getInt("mapreduce.job.counters.group.name.max", 128);
            int n = maxPrefixLength = maxPrefixLength < 0 ? groupNameMax : Math.min(maxPrefixLength, groupNameMax);
        }
        if (maxPrefixLength > 0) {
            int reserve = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX_RESERVE_LENGTH);
            return reserve < 0 ? maxPrefixLength : maxPrefixLength - reserve;
        }
        return maxPrefixLength;
    }

    public static StatsFactory newFactory(Configuration conf) {
        return StatsFactory.newFactory(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESTATSDBCLASS), conf);
    }

    public static StatsFactory newFactory(String configurationParam, Configuration conf) {
        StatsFactory factory = new StatsFactory(conf);
        if (factory.initialize(configurationParam.toLowerCase())) {
            return factory;
        }
        return null;
    }

    private StatsFactory(Configuration conf) {
        this.jobConf = conf;
    }

    private boolean initialize(String type) {
        ClassLoader classLoader = JavaUtils.getClassLoader();
        try {
            StatsSetupConst.StatDB statDB = type.startsWith("jdbc") ? StatsSetupConst.StatDB.jdbc : StatsSetupConst.StatDB.valueOf((String)type);
            this.publisherImplementation = Class.forName(statDB.getPublisher(this.jobConf), true, classLoader);
            this.aggregatorImplementation = Class.forName(statDB.getAggregator(this.jobConf), true, classLoader);
        }
        catch (Exception e) {
            LOG.error((Object)(type + " Publisher/Aggregator classes cannot be loaded."), (Throwable)e);
            return false;
        }
        return true;
    }

    public StatsPublisher getStatsPublisher() {
        return (StatsPublisher)ReflectionUtils.newInstance(this.publisherImplementation, (Configuration)this.jobConf);
    }

    public StatsAggregator getStatsAggregator() {
        return (StatsAggregator)ReflectionUtils.newInstance(this.aggregatorImplementation, (Configuration)this.jobConf);
    }
}

