/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@Description(name="min", value="_FUNC_(expr) - Returns the minimum value of expr")
public class GenericUDAFMin
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFMin.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)parameters[0]);
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)oi)) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new GenericUDAFMinEvaluator();
    }

    @UDFType(distinctLike=true)
    public static class GenericUDAFMinEvaluator
    extends GenericUDAFEvaluator {
        private transient ObjectInspector inputOI;
        private transient ObjectInspector outputOI;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MinAgg result = new MinAgg();
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            myagg.o = null;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            this.merge(agg, parameters[0]);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                MinAgg myagg = (MinAgg)agg;
                int r = ObjectInspectorUtils.compare((Object)myagg.o, (ObjectInspector)this.outputOI, (Object)partial, (ObjectInspector)this.inputOI);
                if (myagg.o == null || r > 0) {
                    myagg.o = ObjectInspectorUtils.copyToStandardObject((Object)partial, (ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            return myagg.o;
        }

        static class MinAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Object o;

            MinAgg() {
            }
        }
    }
}

