/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="instr", value="_FUNC_(str, substr) - Returns the index of the first occurance of substr in str", extended="Example:\n  > SELECT _FUNC_('Facebook', 'boo') FROM src LIMIT 1;\n  5")
public class GenericUDFInstr
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    IntWritable intWritable = new IntWritable(0);

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function INSTR accepts exactly 2 arguments.");
        }
        for (i = 0; i < arguments.length; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of function INSTR is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        Text text = (Text)this.converters[0].convert(arguments[0].get());
        Text subtext = (Text)this.converters[1].convert(arguments[1].get());
        this.intWritable.set(GenericUDFUtils.findText(text, subtext, 0) + 1);
        return this.intWritable;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return "instr(" + children[0] + children[1] + ")";
    }
}

