/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

public final class GenericUDFUtils {
    public static boolean isUtfStartByte(byte b) {
        return (b & 0xC0) != 128;
    }

    public static String getOrdinal(int i) {
        int unit = i % 10;
        return i <= 0 ? "" : (i != 11 && unit == 1 ? i + "st" : (i != 12 && unit == 2 ? i + "nd" : (i != 13 && unit == 3 ? i + "rd" : i + "th")));
    }

    public static int findText(Text text, Text subtext, int start) {
        int length = text.getLength() - start;
        if (start < 0 || length < 0 || length < subtext.getLength()) {
            return -1;
        }
        if (subtext.getLength() == 0) {
            return 0;
        }
        if (length == 0) {
            return -1;
        }
        ByteBuffer src = ByteBuffer.wrap(text.getBytes(), 0, text.getLength());
        ByteBuffer tgt = ByteBuffer.wrap(subtext.getBytes(), 0, subtext.getLength());
        byte b = tgt.get();
        src.position(start);
        while (src.hasRemaining()) {
            if (b != src.get()) continue;
            src.mark();
            tgt.mark();
            boolean found = true;
            int pos = src.position() - 1;
            while (tgt.hasRemaining()) {
                if (!src.hasRemaining()) {
                    tgt.reset();
                    src.reset();
                    found = false;
                    break;
                }
                if (tgt.get() == src.get()) continue;
                tgt.reset();
                src.reset();
                found = false;
                break;
            }
            if (!found) continue;
            return pos;
        }
        return -1;
    }

    private GenericUDFUtils() {
    }

    public static class StringHelper {
        protected Object returnValue;
        protected PrimitiveObjectInspector.PrimitiveCategory type;

        public StringHelper(PrimitiveObjectInspector.PrimitiveCategory type) throws UDFArgumentException {
            this.type = type;
            switch (type) {
                case STRING: {
                    this.returnValue = new Text();
                    break;
                }
                case CHAR: {
                    this.returnValue = new HiveCharWritable();
                    break;
                }
                case VARCHAR: {
                    this.returnValue = new HiveVarcharWritable();
                    break;
                }
                default: {
                    throw new UDFArgumentException("Unexpected non-string type " + type);
                }
            }
        }

        public Object setReturnValue(String val) throws UDFArgumentException {
            if (val == null) {
                return null;
            }
            switch (this.type) {
                case STRING: {
                    ((Text)this.returnValue).set(val);
                    return this.returnValue;
                }
                case CHAR: {
                    ((HiveCharWritable)this.returnValue).set(val);
                    return this.returnValue;
                }
                case VARCHAR: {
                    ((HiveVarcharWritable)this.returnValue).set(val);
                    return this.returnValue;
                }
            }
            throw new UDFArgumentException("Bad return type " + this.type);
        }

        public static int getFixedStringSizeForType(PrimitiveObjectInspector poi) throws UDFArgumentException {
            switch (poi.getPrimitiveCategory()) {
                case CHAR: 
                case VARCHAR: {
                    BaseCharTypeInfo typeInfo = (BaseCharTypeInfo)poi.getTypeInfo();
                    return typeInfo.getLength();
                }
            }
            throw new UDFArgumentException("No fixed size for type " + poi.getTypeName());
        }
    }

    public static class ConversionHelper {
        private final ObjectInspector[] givenParameterOIs;
        Type[] methodParameterTypes;
        private final boolean isVariableLengthArgument;
        Type lastParaElementType;
        boolean conversionNeeded;
        ObjectInspectorConverters.Converter[] converters;
        Object[] convertedParameters;
        Object[] convertedParametersInArray;

        private static Class<?> getClassFromType(Type t) {
            if (t instanceof Class) {
                return (Class)t;
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                return (Class)pt.getRawType();
            }
            return null;
        }

        public ConversionHelper(Method m, ObjectInspector[] parameterOIs) throws UDFArgumentException {
            this.givenParameterOIs = parameterOIs;
            this.methodParameterTypes = m.getGenericParameterTypes();
            this.lastParaElementType = TypeInfoUtils.getArrayElementType(this.methodParameterTypes.length == 0 ? null : this.methodParameterTypes[this.methodParameterTypes.length - 1]);
            this.isVariableLengthArgument = this.lastParaElementType != null;
            ObjectInspector[] methodParameterOIs = new ObjectInspector[parameterOIs.length];
            if (this.isVariableLengthArgument) {
                int i;
                if (parameterOIs.length < this.methodParameterTypes.length - 1) {
                    throw new UDFArgumentLengthException(m.toString() + " requires at least " + (this.methodParameterTypes.length - 1) + " arguments but only " + parameterOIs.length + " are passed in.");
                }
                for (i = 0; i < this.methodParameterTypes.length - 1; ++i) {
                    methodParameterOIs[i] = this.methodParameterTypes[i] == Object.class ? ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameterOIs[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA) : ObjectInspectorFactory.getReflectionObjectInspector((Type)this.methodParameterTypes[i], (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                }
                if (this.lastParaElementType == Object.class) {
                    for (i = this.methodParameterTypes.length - 1; i < parameterOIs.length; ++i) {
                        methodParameterOIs[i] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameterOIs[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    }
                } else {
                    ObjectInspector oi = ObjectInspectorFactory.getReflectionObjectInspector((Type)this.lastParaElementType, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                    for (int i2 = this.methodParameterTypes.length - 1; i2 < parameterOIs.length; ++i2) {
                        methodParameterOIs[i2] = oi;
                    }
                }
            } else {
                if (this.methodParameterTypes.length != parameterOIs.length) {
                    throw new UDFArgumentLengthException(m.toString() + " requires " + this.methodParameterTypes.length + " arguments but " + parameterOIs.length + " are passed in.");
                }
                for (int i = 0; i < this.methodParameterTypes.length; ++i) {
                    methodParameterOIs[i] = this.methodParameterTypes[i] == Object.class ? ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameterOIs[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA) : ObjectInspectorFactory.getReflectionObjectInspector((Type)this.methodParameterTypes[i], (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                }
            }
            this.conversionNeeded = false;
            this.converters = new ObjectInspectorConverters.Converter[parameterOIs.length];
            for (int i = 0; i < parameterOIs.length; ++i) {
                ObjectInspectorConverters.Converter pc;
                this.converters[i] = pc = ObjectInspectorConverters.getConverter((ObjectInspector)parameterOIs[i], (ObjectInspector)methodParameterOIs[i]);
                this.conversionNeeded = this.conversionNeeded || !(pc instanceof ObjectInspectorConverters.IdentityConverter);
            }
            if (this.isVariableLengthArgument) {
                this.convertedParameters = new Object[this.methodParameterTypes.length];
                this.convertedParameters[this.convertedParameters.length - 1] = this.convertedParametersInArray = (Object[])Array.newInstance(ConversionHelper.getClassFromType(this.lastParaElementType), parameterOIs.length - this.methodParameterTypes.length + 1);
            } else {
                this.convertedParameters = new Object[parameterOIs.length];
            }
        }

        public Object[] convertIfNecessary(Object ... parameters) {
            assert (parameters.length == this.givenParameterOIs.length);
            if (!this.conversionNeeded && !this.isVariableLengthArgument) {
                return parameters;
            }
            if (this.isVariableLengthArgument) {
                int i;
                for (i = 0; i < this.methodParameterTypes.length - 1; ++i) {
                    this.convertedParameters[i] = this.converters[i].convert(parameters[i]);
                }
                for (i = this.methodParameterTypes.length - 1; i < parameters.length; ++i) {
                    this.convertedParametersInArray[i + 1 - this.methodParameterTypes.length] = this.converters[i].convert(parameters[i]);
                }
            } else {
                for (int i = 0; i < this.methodParameterTypes.length; ++i) {
                    this.convertedParameters[i] = this.converters[i].convert(parameters[i]);
                }
            }
            return this.convertedParameters;
        }
    }

    public static class ReturnObjectInspectorResolver {
        boolean allowTypeConversion;
        ObjectInspector returnObjectInspector;
        HashMap<ObjectInspector, ObjectInspectorConverters.Converter> converters;

        public ReturnObjectInspectorResolver() {
            this(false);
        }

        public ReturnObjectInspectorResolver(boolean allowTypeConversion) {
            this.allowTypeConversion = allowTypeConversion;
        }

        public boolean update(ObjectInspector oi) throws UDFArgumentTypeException {
            TypeInfo rTypeInfo;
            if (oi instanceof VoidObjectInspector) {
                return true;
            }
            if (this.returnObjectInspector == null) {
                this.returnObjectInspector = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)oi, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                return true;
            }
            if (this.returnObjectInspector == oi) {
                return true;
            }
            TypeInfo oiTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi);
            if (oiTypeInfo == (rTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.returnObjectInspector))) {
                this.returnObjectInspector = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.returnObjectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                return true;
            }
            if (!this.allowTypeConversion) {
                return false;
            }
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClass(oiTypeInfo, rTypeInfo);
            if (commonTypeInfo == null) {
                return false;
            }
            if (!(!(commonTypeInfo instanceof DecimalTypeInfo) || FunctionRegistry.isExactNumericType((PrimitiveTypeInfo)oiTypeInfo) && FunctionRegistry.isExactNumericType((PrimitiveTypeInfo)rTypeInfo))) {
                commonTypeInfo = TypeInfoFactory.doubleTypeInfo;
            }
            this.returnObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)commonTypeInfo);
            return true;
        }

        public ObjectInspector get() {
            return this.returnObjectInspector;
        }

        public Object convertIfNecessary(Object o, ObjectInspector oi) {
            Object converted = null;
            if (oi == this.returnObjectInspector) {
                converted = o;
            } else {
                ObjectInspectorConverters.Converter converter;
                if (o == null) {
                    return null;
                }
                if (this.converters == null) {
                    this.converters = new HashMap();
                }
                if ((converter = this.converters.get(oi)) == null) {
                    converter = ObjectInspectorConverters.getConverter((ObjectInspector)oi, (ObjectInspector)this.returnObjectInspector);
                    this.converters.put(oi, converter);
                }
                converted = converter.convert(o);
            }
            return converted;
        }
    }
}

