/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class TableFunctionEvaluator {
    protected transient StructObjectInspector OI;
    protected transient StructObjectInspector rawInputOI;
    protected PartitionedTableFunctionDef tableDef;
    protected PTFDesc ptfDesc;
    boolean transformsRawInput;
    protected transient PTFPartition outputPartition;

    public StructObjectInspector getOutputOI() {
        return this.OI;
    }

    protected void setOutputOI(StructObjectInspector outputOI) {
        this.OI = outputOI;
    }

    public PartitionedTableFunctionDef getTableDef() {
        return this.tableDef;
    }

    public void setTableDef(PartitionedTableFunctionDef tDef) {
        this.tableDef = tDef;
    }

    protected PTFDesc getQueryDef() {
        return this.ptfDesc;
    }

    protected void setQueryDef(PTFDesc ptfDesc) {
        this.ptfDesc = ptfDesc;
    }

    public StructObjectInspector getRawInputOI() {
        return this.rawInputOI;
    }

    protected void setRawInputOI(StructObjectInspector rawInputOI) {
        this.rawInputOI = rawInputOI;
    }

    public boolean isTransformsRawInput() {
        return this.transformsRawInput;
    }

    public void setTransformsRawInput(boolean transformsRawInput) {
        this.transformsRawInput = transformsRawInput;
    }

    public PTFPartition execute(PTFPartition iPart) throws HiveException {
        PTFPartition.PTFPartitionIterator<Object> pItr = iPart.iterator();
        PTFOperator.connectLeadLagFunctionsToPartition(this.ptfDesc, pItr);
        if (this.outputPartition == null) {
            this.outputPartition = PTFPartition.create(this.ptfDesc.getCfg(), this.tableDef.getOutputShape().getSerde(), this.OI, this.tableDef.getOutputShape().getOI());
        } else {
            this.outputPartition.reset();
        }
        this.execute(pItr, this.outputPartition);
        return this.outputPartition;
    }

    protected abstract void execute(PTFPartition.PTFPartitionIterator<Object> var1, PTFPartition var2) throws HiveException;

    public PTFPartition transformRawInput(PTFPartition iPart) throws HiveException {
        if (!this.isTransformsRawInput()) {
            throw new HiveException(String.format("Internal Error: mapExecute called on function (%s)that has no Map Phase", this.tableDef.getName()));
        }
        return this._transformRawInput(iPart);
    }

    protected PTFPartition _transformRawInput(PTFPartition iPart) throws HiveException {
        return null;
    }

    public void close() {
        if (this.outputPartition != null) {
            this.outputPartition.close();
        }
        this.outputPartition = null;
    }

    static {
        PTFUtils.makeTransient(TableFunctionEvaluator.class, "outputOI", "rawInputOI");
    }
}

