/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;

public final class ExprWalkerProcFactory {
    private static final Log LOG = LogFactory.getLog((String)ExprWalkerProcFactory.class.getName());

    public static NodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static NodeProcessor getGenericFuncProcessor() {
        return new GenericFuncExprProcessor();
    }

    public static NodeProcessor getColumnProcessor() {
        return new ColumnExprProcessor();
    }

    private static NodeProcessor getFieldProcessor() {
        return new FieldExprProcessor();
    }

    public static ExprWalkerInfo extractPushdownPreds(OpWalkerInfo opContext, Operator<? extends OperatorDesc> op, ExprNodeDesc pred) throws SemanticException {
        ArrayList<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
        preds.add(pred);
        return ExprWalkerProcFactory.extractPushdownPreds(opContext, op, preds);
    }

    public static ExprWalkerInfo extractPushdownPreds(OpWalkerInfo opContext, Operator<? extends OperatorDesc> op, List<ExprNodeDesc> preds) throws SemanticException {
        ExprWalkerInfo exprContext = new ExprWalkerInfo(op);
        LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeColumnDesc.class.getName() + "%"), ExprWalkerProcFactory.getColumnProcessor());
        exprRules.put(new RuleRegExp("R2", ExprNodeFieldDesc.class.getName() + "%"), ExprWalkerProcFactory.getFieldProcessor());
        exprRules.put(new RuleRegExp("R3", ExprNodeGenericFuncDesc.class.getName() + "%"), ExprWalkerProcFactory.getGenericFuncProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ExprWalkerProcFactory.getDefaultExprProcessor(), exprRules, exprContext);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        ArrayList<ExprNodeDesc> clonedPreds = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc node : preds) {
            ExprNodeDesc clone = node.clone();
            clonedPreds.add(clone);
            exprContext.getNewToOldExprMap().put(clone, node);
        }
        startNodes.addAll(clonedPreds);
        egw.startWalking(startNodes, null);
        HiveConf conf = opContext.getParseContext().getConf();
        for (ExprNodeDesc pred : clonedPreds) {
            ExprWalkerProcFactory.extractFinalCandidates(pred, exprContext, conf);
        }
        return exprContext;
    }

    private static void extractFinalCandidates(ExprNodeDesc expr, ExprWalkerInfo ctx, HiveConf conf) {
        if (FunctionRegistry.isOpAnd(expr)) {
            assert (ctx.getNewToOldExprMap().containsKey(expr));
            for (int i = 0; i < expr.getChildren().size(); ++i) {
                ctx.getNewToOldExprMap().put(expr.getChildren().get(i), ctx.getNewToOldExprMap().get(expr).getChildren().get(i));
                ExprWalkerProcFactory.extractFinalCandidates(expr.getChildren().get(i), ctx, conf);
            }
            return;
        }
        if (ctx.isCandidate(expr)) {
            ctx.addFinalCandidate(expr);
            return;
        }
        if (!FunctionRegistry.isOpAnd(expr) && HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
            ctx.addNonFinalCandidate(expr);
        }
    }

    private ExprWalkerProcFactory() {
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            ctx.setIsCandidate((ExprNodeDesc)nd, true);
            return true;
        }
    }

    public static class GenericFuncExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            String alias = null;
            ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)nd;
            if (!FunctionRegistry.isDeterministic(expr.getGenericUDF())) {
                ctx.setIsCandidate(expr, false);
                ctx.setDeterministic(false);
                return false;
            }
            boolean isCandidate = true;
            for (int i = 0; i < nd.getChildren().size(); ++i) {
                ExprNodeDesc ch = (ExprNodeDesc)nd.getChildren().get(i);
                ExprNodeDesc newCh = ctx.getConvertedNode(ch);
                if (newCh != null) {
                    expr.getChildren().set(i, newCh);
                    ch = newCh;
                }
                String chAlias = ctx.getAlias(ch);
                boolean bl = isCandidate = isCandidate && ctx.isCandidate(ch);
                if (isCandidate && chAlias != null) {
                    if (alias == null) {
                        alias = chAlias;
                    } else if (!chAlias.equalsIgnoreCase(alias)) {
                        isCandidate = false;
                    }
                }
                if (!isCandidate) break;
            }
            ctx.addAlias(expr, alias);
            ctx.setIsCandidate(expr, isCandidate);
            return isCandidate;
        }
    }

    public static class FieldExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            String alias = null;
            ExprNodeFieldDesc expr = (ExprNodeFieldDesc)nd;
            boolean isCandidate = true;
            assert (nd.getChildren().size() == 1);
            ExprNodeDesc ch = (ExprNodeDesc)nd.getChildren().get(0);
            ExprNodeDesc newCh = ctx.getConvertedNode(ch);
            if (newCh != null) {
                expr.setDesc(newCh);
                ch = newCh;
            }
            String chAlias = ctx.getAlias(ch);
            boolean bl = isCandidate = isCandidate && ctx.isCandidate(ch);
            if (isCandidate && chAlias != null) {
                if (alias == null) {
                    alias = chAlias;
                } else if (!chAlias.equalsIgnoreCase(alias)) {
                    isCandidate = false;
                }
            }
            ctx.addAlias(expr, alias);
            ctx.setIsCandidate(expr, isCandidate);
            return isCandidate;
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            ExprNodeColumnDesc colref = (ExprNodeColumnDesc)nd;
            RowSchema toRS = ctx.getOp().getSchema();
            Operator<? extends OperatorDesc> op = ctx.getOp();
            ColumnInfo ci = toRS.getColumnInfo(colref.getColumn());
            String tabAlias = null;
            if (ci != null) {
                tabAlias = ci.getTabAlias();
            }
            boolean isCandidate = true;
            if (op.getColumnExprMap() != null) {
                ExprNodeDesc exp = op.getColumnExprMap().get(colref.getColumn());
                if (exp == null) {
                    ctx.setIsCandidate(colref, false);
                    return false;
                }
                if (exp instanceof ExprNodeGenericFuncDesc) {
                    isCandidate = false;
                }
                if (exp instanceof ExprNodeColumnDesc && ci == null) {
                    ExprNodeColumnDesc column = (ExprNodeColumnDesc)exp;
                    tabAlias = column.getTabAlias();
                }
                ctx.addConvertedNode(colref, exp);
                ctx.setIsCandidate(exp, isCandidate);
                ctx.addAlias(exp, tabAlias);
            } else {
                if (ci == null) {
                    return false;
                }
                ctx.addAlias(colref, tabAlias);
            }
            ctx.setIsCandidate(colref, isCandidate);
            return isCandidate;
        }
    }
}

