/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastTableContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class VectorMapJoinFastHashTableLoader
implements HashTableLoader {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinFastHashTableLoader.class.getName());
    private Configuration hconf;
    protected MapJoinDesc desc;
    private TezContext tezContext;

    @Override
    public void init(ExecMapperContext context, MapredContext mrContext, Configuration hconf, MapJoinOperator joinOp) {
        this.tezContext = (TezContext)mrContext;
        this.hconf = hconf;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        Map<Integer, String> parentToInput = this.desc.getParentToInput();
        Map<Integer, Long> parentKeyCounts = this.desc.getParentKeyCounts();
        for (int pos = 0; pos < mapJoinTables.length; ++pos) {
            if (pos == this.desc.getPosBigTable()) continue;
            String inputName = parentToInput.get(pos);
            LogicalInput input = this.tezContext.getInput(inputName);
            try {
                input.start();
                this.tezContext.getTezProcessorContext().waitForAnyInputReady(Collections.singletonList(input));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            try {
                KeyValueReader kvReader = (KeyValueReader)input.getReader();
                Long keyCountObj = parentKeyCounts.get(pos);
                long keyCount = keyCountObj == null ? -1L : keyCountObj;
                VectorMapJoinFastTableContainer vectorMapJoinFastTableContainer = new VectorMapJoinFastTableContainer(this.desc, this.hconf, keyCount);
                while (kvReader.next()) {
                    vectorMapJoinFastTableContainer.putRow(null, (Writable)((BytesWritable)kvReader.getCurrentKey()), null, (Writable)((BytesWritable)kvReader.getCurrentValue()));
                }
                vectorMapJoinFastTableContainer.seal();
                mapJoinTables[pos] = vectorMapJoinFastTableContainer;
                continue;
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }
}

