/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.rpc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KryoMessageCodec
extends ByteToMessageCodec<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(KryoMessageCodec.class);
    private static final int REG_ID_BASE = 16;
    private final int maxMessageSize;
    private final List<Class<?>> messages;
    private final ThreadLocal<Kryo> kryos = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            int count = 0;
            for (Class klass : KryoMessageCodec.this.messages) {
                kryo.register(klass, 16 + count);
                ++count;
            }
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            return kryo;
        }
    };
    private volatile EncryptionHandler encryptionHandler;

    public KryoMessageCodec(int maxMessageSize, Class<?> ... messages) {
        this.maxMessageSize = maxMessageSize;
        this.messages = Arrays.asList(messages);
        this.encryptionHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int msgSize = in.readInt();
        this.checkSize(msgSize);
        if (in.readableBytes() < msgSize) {
            in.resetReaderIndex();
            return;
        }
        try {
            ByteBuffer nioBuffer = this.maybeDecrypt(in.nioBuffer(in.readerIndex(), msgSize));
            Input kryoIn = new Input((InputStream)new ByteBufferInputStream(nioBuffer));
            Object msg = this.kryos.get().readClassAndObject(kryoIn);
            LOG.debug("Decoded message of type {} ({} bytes)", msg != null ? msg.getClass().getName() : msg, (Object)msgSize);
            out.add(msg);
        }
        finally {
            in.skipBytes(msgSize);
        }
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf buf) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Output kryoOut = new Output((OutputStream)bytes);
        this.kryos.get().writeClassAndObject(kryoOut, msg);
        kryoOut.flush();
        byte[] msgData = this.maybeEncrypt(bytes.toByteArray());
        LOG.debug("Encoded message of type {} ({} bytes)", (Object)msg.getClass().getName(), (Object)msgData.length);
        this.checkSize(msgData.length);
        buf.ensureWritable(msgData.length + 4);
        buf.writeInt(msgData.length);
        buf.writeBytes(msgData);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.encryptionHandler != null) {
            this.encryptionHandler.dispose();
        }
        super.channelInactive(ctx);
    }

    private void checkSize(int msgSize) {
        Preconditions.checkArgument((msgSize > 0 ? 1 : 0) != 0, (String)"Message size (%s bytes) must be positive.", (Object[])new Object[]{msgSize});
        Preconditions.checkArgument((this.maxMessageSize <= 0 || msgSize <= this.maxMessageSize ? 1 : 0) != 0, (String)"Message (%s bytes) exceeds maximum allowed size (%s bytes).", (Object[])new Object[]{msgSize, this.maxMessageSize});
    }

    private byte[] maybeEncrypt(byte[] data) throws Exception {
        return this.encryptionHandler != null ? this.encryptionHandler.wrap(data, 0, data.length) : data;
    }

    private ByteBuffer maybeDecrypt(ByteBuffer data) throws Exception {
        if (this.encryptionHandler != null) {
            int offset;
            byte[] encrypted;
            int len = data.limit() - data.position();
            if (data.hasArray()) {
                encrypted = data.array();
                offset = data.position() + data.arrayOffset();
                data.position(data.limit());
            } else {
                encrypted = new byte[len];
                offset = 0;
                data.get(encrypted);
            }
            return ByteBuffer.wrap(this.encryptionHandler.unwrap(encrypted, offset, len));
        }
        return data;
    }

    void setEncryptionHandler(EncryptionHandler handler) {
        this.encryptionHandler = handler;
    }

    static interface EncryptionHandler {
        public byte[] wrap(byte[] var1, int var2, int var3) throws IOException;

        public byte[] unwrap(byte[] var1, int var2, int var3) throws IOException;

        public void dispose() throws IOException;
    }
}

