/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.core;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationService;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.data.rest.core.ControllerType;
import org.springdoc.data.rest.core.DataRestRepository;
import org.springdoc.data.rest.core.DataRestRequestService;
import org.springdoc.data.rest.core.DataRestResponseService;
import org.springdoc.data.rest.core.DataRestTagsService;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ParametersMetadata;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class DataRestOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRestOperationService.class);
    private static final String STRING_SEPARATOR = "-";
    private DataRestRequestService dataRestRequestService;
    private DataRestTagsService tagsBuilder;
    private DataRestResponseService dataRestResponseService;
    private OperationService operationService;

    public DataRestOperationService(DataRestRequestService dataRestRequestService, DataRestTagsService tagsBuilder, DataRestResponseService dataRestResponseService, OperationService operationService) {
        this.dataRestRequestService = dataRestRequestService;
        this.tagsBuilder = tagsBuilder;
        this.dataRestResponseService = dataRestResponseService;
        this.operationService = operationService;
    }

    public Operation buildOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata, MethodResourceMapping methodResourceMapping, ControllerType controllerType) {
        Operation operation = null;
        if (ControllerType.ENTITY.equals((Object)controllerType) || ControllerType.PROPERTY.equals((Object)controllerType) || ControllerType.SCHEMA.equals((Object)controllerType)) {
            operation = this.buildEntityOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, operationPath, methodAttributes, resourceMetadata);
        } else if (ControllerType.SEARCH.equals((Object)controllerType)) {
            operation = this.buildSearchOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, methodAttributes, methodResourceMapping);
        }
        return operation;
    }

    private Operation buildEntityOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata) {
        Class<?> domainType = null;
        if (dataRestRepository != null) {
            domainType = dataRestRepository.getDomainType();
        }
        Operation operation = this.initOperation(handlerMethod, domainType, requestMethod);
        this.dataRestRequestService.buildParameters(domainType, openAPI, handlerMethod, requestMethod, methodAttributes, operation, resourceMetadata);
        this.dataRestResponseService.buildEntityResponse(operation, handlerMethod, openAPI, requestMethod, operationPath, domainType, methodAttributes);
        this.tagsBuilder.buildEntityTags(operation, handlerMethod, dataRestRepository);
        if (domainType != null) {
            this.addOperationDescription(operation, requestMethod, domainType.getSimpleName().toLowerCase());
        }
        return operation;
    }

    private Operation buildSearchOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, MethodAttributes methodAttributes, MethodResourceMapping methodResourceMapping) {
        Class<?> domainType = dataRestRepository.getDomainType();
        Operation operation = this.initOperation(handlerMethod, domainType, requestMethod);
        io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)methodResourceMapping.getMethod(), io.swagger.v3.oas.annotations.Operation.class);
        if (apiOperation != null) {
            this.operationService.parse(apiOperation, operation, openAPI, methodAttributes);
        }
        ParametersMetadata parameterMetadata = methodResourceMapping.getParametersMetadata();
        Method method = methodResourceMapping.getMethod();
        if (!CollectionUtils.isEmpty((Collection)parameterMetadata.getParameterNames())) {
            MethodParameter[] parameters;
            Iterator repositoryHandlerMethod = new HandlerMethod(methodResourceMapping.getMethod().getDeclaringClass(), methodResourceMapping.getMethod());
            for (MethodParameter methodParameter2 : parameters = repositoryHandlerMethod.getMethodParameters()) {
                this.dataRestRequestService.buildCommonParameters(domainType, openAPI, requestMethod, methodAttributes, operation, new String[]{methodParameter2.getParameterName()}, new MethodParameter[]{methodParameter2});
            }
        }
        for (ParameterMetadata parameterMetadatum : parameterMetadata) {
            Class<String> type;
            String pName = parameterMetadatum.getName();
            ResourceDescription description = parameterMetadatum.getDescription();
            if (!(description instanceof TypedResourceDescription)) continue;
            TypedResourceDescription typedResourceDescription = (TypedResourceDescription)description;
            Field fieldType = FieldUtils.getField(TypedResourceDescription.class, (String)"type", (boolean)true);
            try {
                type = (Class<String>)fieldType.get(typedResourceDescription);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
                type = String.class;
            }
            Schema schema = SpringDocAnnotationsUtils.resolveSchemaFromType(type, (Components)openAPI.getComponents(), null, null);
            io.swagger.v3.oas.models.parameters.Parameter parameter = this.getParameterFromAnnotations(openAPI, methodAttributes, method, pName);
            if (parameter == null) {
                parameter = new io.swagger.v3.oas.models.parameters.Parameter().name(pName).in(ParameterIn.QUERY.toString()).schema(schema);
            }
            operation.addParametersItem(parameter);
        }
        if (methodResourceMapping.isPagingResource()) {
            MethodParameter[] parameters = handlerMethod.getMethodParameters();
            Arrays.stream(parameters).filter(methodParameter -> DefaultedPageable.class.equals((Object)methodParameter.getParameterType())).findAny().ifPresent(methodParameterPage -> this.dataRestRequestService.buildCommonParameters(domainType, openAPI, requestMethod, methodAttributes, operation, new String[]{methodParameterPage.getParameterName()}, new MethodParameter[]{methodParameterPage}));
        }
        this.dataRestResponseService.buildSearchResponse(operation, handlerMethod, openAPI, methodResourceMapping, domainType, methodAttributes);
        this.tagsBuilder.buildSearchTags(operation, handlerMethod, dataRestRepository);
        return operation;
    }

    private io.swagger.v3.oas.models.parameters.Parameter getParameterFromAnnotations(OpenAPI openAPI, MethodAttributes methodAttributes, Method method, String pName) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        for (java.lang.reflect.Parameter reflectParameter : method.getParameters()) {
            Parameter parameterDoc;
            Param paramAnnotation = reflectParameter.getAnnotation(Param.class);
            if (paramAnnotation == null || !paramAnnotation.value().equals(pName) || (parameterDoc = (Parameter)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])reflectParameter.getAnnotations()), Parameter.class)) == null || parameterDoc.hidden() && !parameterDoc.schema().hidden()) continue;
            parameter = this.dataRestRequestService.buildParameterFromDoc(parameterDoc, openAPI.getComponents(), methodAttributes.getJsonViewAnnotation());
            parameter.setName(pName);
        }
        return parameter;
    }

    private Operation initOperation(HandlerMethod handlerMethod, Class<?> domainType, RequestMethod requestMethod) {
        Operation operation = new Operation();
        StringBuilder operationIdBuilder = new StringBuilder();
        operationIdBuilder.append(handlerMethod.getMethod().getName());
        if (domainType != null) {
            operationIdBuilder.append(STRING_SEPARATOR).append(domainType.getSimpleName().toLowerCase()).append(STRING_SEPARATOR).append(requestMethod.toString().toLowerCase());
        }
        operation.setOperationId(operationIdBuilder.toString());
        return operation;
    }

    private void addOperationDescription(Operation operation, RequestMethod requestMethod, String entity) {
        switch (requestMethod) {
            case GET: {
                operation.setDescription("get-" + entity);
                break;
            }
            case POST: {
                operation.setDescription("create-" + entity);
                break;
            }
            case DELETE: {
                operation.setDescription("delete-" + entity);
                break;
            }
            case PUT: {
                operation.setDescription("update-" + entity);
                break;
            }
            case PATCH: {
                operation.setDescription("patch-" + entity);
                break;
            }
            default: {
                throw new IllegalArgumentException(requestMethod.name());
            }
        }
    }
}

