/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.core;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.ReturnTypeParser;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class DataRestResponseService {
    private GenericResponseService genericResponseService;

    public DataRestResponseService(GenericResponseService genericResponseService) {
        this.genericResponseService = genericResponseService;
    }

    public void buildSearchResponse(Operation operation, HandlerMethod handlerMethod, OpenAPI openAPI, MethodResourceMapping methodResourceMapping, Class<?> domainType, MethodAttributes methodAttributes) {
        ApiResponses apiResponses;
        MethodParameter methodParameterReturn = handlerMethod.getReturnType();
        Set responsesArray = this.genericResponseService.getApiResponses(methodResourceMapping.getMethod());
        if (!responsesArray.isEmpty() || !CollectionUtils.isEmpty((Map)operation.getResponses())) {
            apiResponses = this.genericResponseService.build(openAPI.getComponents(), new HandlerMethod(methodResourceMapping.getMethod().getDeclaringClass(), methodResourceMapping.getMethod()), operation, methodAttributes);
        } else {
            apiResponses = new ApiResponses();
            ApiResponse apiResponse = new ApiResponse();
            Type returnType = this.findSearchReturnType(methodResourceMapping, domainType);
            Content content = this.genericResponseService.buildContent(openAPI.getComponents(), methodParameterReturn.getParameterAnnotations(), methodAttributes.getMethodProduces(), null, returnType);
            apiResponse.setContent(content);
            this.addResponse200(apiResponses, apiResponse);
            this.addResponse404(apiResponses);
        }
        operation.setResponses(apiResponses);
    }

    public void buildEntityResponse(Operation operation, HandlerMethod handlerMethod, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, Class<?> domainType, MethodAttributes methodAttributes) {
        MethodParameter methodParameterReturn = handlerMethod.getReturnType();
        Type returnType = ReturnTypeParser.resolveType((Type)methodParameterReturn.getGenericParameterType(), (Class)methodParameterReturn.getContainingClass());
        returnType = this.getType(returnType, domainType);
        ApiResponses apiResponses = new ApiResponses();
        ApiResponse apiResponse = new ApiResponse();
        Content content = this.genericResponseService.buildContent(openAPI.getComponents(), methodParameterReturn.getParameterAnnotations(), methodAttributes.getMethodProduces(), null, returnType);
        apiResponse.setContent(content);
        this.addResponse(requestMethod, operationPath, apiResponses, apiResponse);
        operation.setResponses(apiResponses);
    }

    private void addResponse(RequestMethod requestMethod, String operationPath, ApiResponses apiResponses, ApiResponse apiResponse) {
        switch (requestMethod) {
            case GET: {
                this.addResponse200(apiResponses, apiResponse);
                if (!operationPath.contains("/{id}")) break;
                this.addResponse404(apiResponses);
                break;
            }
            case POST: {
                apiResponses.put((Object)String.valueOf(HttpStatus.CREATED.value()), (Object)apiResponse.description(HttpStatus.CREATED.getReasonPhrase()));
                break;
            }
            case DELETE: {
                this.addResponse204(apiResponses);
                this.addResponse404(apiResponses);
                break;
            }
            case PUT: {
                this.addResponse200(apiResponses, apiResponse);
                apiResponses.put((Object)String.valueOf(HttpStatus.CREATED.value()), (Object)new ApiResponse().content(apiResponse.getContent()).description(HttpStatus.CREATED.getReasonPhrase()));
                this.addResponse204(apiResponses);
                break;
            }
            case PATCH: {
                this.addResponse200(apiResponses, apiResponse);
                this.addResponse204(apiResponses);
                break;
            }
            default: {
                throw new IllegalArgumentException(requestMethod.name());
            }
        }
    }

    private Type findSearchReturnType(MethodResourceMapping methodResourceMapping, Class<?> domainType) {
        Type returnRepoType = ReturnTypeParser.resolveType((Type)methodResourceMapping.getMethod().getGenericReturnType(), methodResourceMapping.getMethod().getDeclaringClass());
        Type returnType = methodResourceMapping.isPagingResource() ? ResolvableType.forClassWithGenerics(PagedModel.class, (Class[])new Class[]{domainType}).getType() : (ResolvableType.forType((Type)returnRepoType).getRawClass() != null && Iterable.class.isAssignableFrom(Objects.requireNonNull(ResolvableType.forType((Type)returnRepoType).getRawClass())) ? ResolvableType.forClassWithGenerics(CollectionModel.class, (Class[])new Class[]{domainType}).getType() : (ClassUtils.isPrimitiveOrWrapper((Class)methodResourceMapping.getReturnedDomainType()) ? methodResourceMapping.getReturnedDomainType() : ResolvableType.forClassWithGenerics(EntityModel.class, (Class[])new Class[]{domainType}).getType()));
        return returnType;
    }

    private Type getType(Type returnType, Class<?> domainType) {
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (ResponseEntity.class.equals((Object)parameterizedType.getRawType())) {
                ParameterizedType wildcardTypeUpperBound;
                WildcardType wildcardType;
                if (Object.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
                    return ResolvableType.forClassWithGenerics(ResponseEntity.class, (Class[])new Class[]{domainType}).getType();
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
                    ParameterizedType parameterizedType1 = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
                    Class rawType = ResolvableType.forType((Type)parameterizedType1.getRawType()).getRawClass();
                    if (rawType != null && rawType.isAssignableFrom(RepresentationModel.class)) {
                        return this.resolveGenericType(ResponseEntity.class, RepresentationModel.class, domainType);
                    }
                    if (EntityModel.class.equals((Object)parameterizedType1.getRawType())) {
                        return this.resolveGenericType(ResponseEntity.class, EntityModel.class, domainType);
                    }
                } else if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType && (wildcardType = (WildcardType)parameterizedType.getActualTypeArguments()[0]).getUpperBounds()[0] instanceof ParameterizedType && RepresentationModel.class.equals((Object)(wildcardTypeUpperBound = (ParameterizedType)wildcardType.getUpperBounds()[0]).getRawType())) {
                    return this.resolveGenericType(ResponseEntity.class, RepresentationModel.class, domainType);
                }
            } else if (HttpEntity.class.equals((Object)parameterizedType.getRawType()) && parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
                ParameterizedType wildcardTypeUpperBound = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
                if (RepresentationModel.class.equals((Object)wildcardTypeUpperBound.getRawType())) {
                    return this.resolveGenericType(HttpEntity.class, RepresentationModel.class, domainType);
                }
            } else if (CollectionModel.class.equals((Object)parameterizedType.getRawType()) && Object.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
                return ResolvableType.forClassWithGenerics(CollectionModel.class, (Class[])new Class[]{domainType}).getType();
            }
        }
        return returnType;
    }

    private Type resolveGenericType(Class<?> container, Class<?> generic, Class<?> domainType) {
        Type type = ResolvableType.forClassWithGenerics(generic, (Class[])new Class[]{domainType}).getType();
        return ResolvableType.forClassWithGenerics(container, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)type)}).getType();
    }

    private void addResponse200(ApiResponses apiResponses, ApiResponse apiResponse) {
        apiResponses.put((Object)String.valueOf(HttpStatus.OK.value()), (Object)apiResponse.description(HttpStatus.OK.getReasonPhrase()));
    }

    private void addResponse204(ApiResponses apiResponses) {
        apiResponses.put((Object)String.valueOf(HttpStatus.NO_CONTENT.value()), (Object)new ApiResponse().description(HttpStatus.NO_CONTENT.getReasonPhrase()));
    }

    private void addResponse404(ApiResponses apiResponses) {
        apiResponses.put((Object)String.valueOf(HttpStatus.NOT_FOUND.value()), (Object)new ApiResponse().description(HttpStatus.NOT_FOUND.getReasonPhrase()));
    }
}

