/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.openapi.javadoc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.converter.ModelConverterContextImpl;
import io.swagger.v3.oas.models.media.Schema;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.util.CollectionUtils;

public class JavadocPropertyCustomizer
implements ModelConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavadocPropertyCustomizer.class);
    private final JavadocProvider javadocProvider;
    private final ObjectMapperProvider objectMapperProvider;

    public JavadocPropertyCustomizer(JavadocProvider javadocProvider, ObjectMapperProvider objectMapperProvider) {
        this.javadocProvider = javadocProvider;
        this.objectMapperProvider = objectMapperProvider;
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType;
        if (chain.hasNext() && (javaType = this.objectMapperProvider.jsonMapper().constructType(type.getType())) != null) {
            Class cls = javaType.getRawClass();
            Schema resolvedSchema = chain.next().resolve(type, context, chain);
            List fields = FieldUtils.getAllFieldsList((Class)cls);
            ArrayList<PropertyDescriptor> clsProperties = new ArrayList();
            try {
                clsProperties = Arrays.asList(Introspector.getBeanInfo(cls).getPropertyDescriptors());
            }
            catch (IntrospectionException ignored) {
                LOGGER.warn(ignored.getMessage());
            }
            if (!CollectionUtils.isEmpty((Collection)fields) || !CollectionUtils.isEmpty(clsProperties)) {
                if (!type.isSchemaProperty()) {
                    Schema existingSchema = context.resolve(type);
                    this.setJavadocDescription(cls, fields, clsProperties, existingSchema, false);
                } else if (resolvedSchema != null && resolvedSchema.get$ref() != null && resolvedSchema.get$ref().contains("#/components/schemas/")) {
                    String schemaName = resolvedSchema.get$ref().substring(21);
                    Schema existingSchema = (Schema)context.getDefinedModels().get(schemaName);
                    this.setJavadocDescription(cls, fields, clsProperties, existingSchema, false);
                } else {
                    try {
                        Field processedTypesField = FieldUtils.getDeclaredField(ModelConverterContextImpl.class, (String)"processedTypes", (boolean)true);
                        Set processedType = (Set)processedTypesField.get(context);
                        if (processedType.contains(type)) {
                            this.setJavadocDescription(cls, fields, clsProperties, resolvedSchema, true);
                        }
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.warn(e.getMessage());
                    }
                }
            }
            return resolvedSchema;
        }
        return null;
    }

    public void setJavadocDescription(Class<?> cls, List<Field> fields, List<PropertyDescriptor> clsProperties, Schema existingSchema, boolean isProcessedType) {
        if (existingSchema != null) {
            Map properties;
            String classJavadoc;
            if (StringUtils.isBlank((CharSequence)existingSchema.getDescription()) && !isProcessedType && StringUtils.isNotBlank((CharSequence)(classJavadoc = this.javadocProvider.getClassJavadoc(cls)))) {
                existingSchema.setDescription(classJavadoc);
            }
            if (!CollectionUtils.isEmpty((Map)(properties = existingSchema.getProperties()))) {
                if (cls.getSuperclass() != null && "java.lang.Record".equals(cls.getSuperclass().getName())) {
                    Map recordParamMap = this.javadocProvider.getRecordClassParamJavadoc(cls);
                    properties.entrySet().stream().filter(stringSchemaEntry -> StringUtils.isBlank((CharSequence)((Schema)stringSchemaEntry.getValue()).getDescription())).forEach(stringSchemaEntry -> {
                        if (recordParamMap.containsKey(stringSchemaEntry.getKey())) {
                            ((Schema)stringSchemaEntry.getValue()).setDescription((String)recordParamMap.get(stringSchemaEntry.getKey()));
                        }
                    });
                }
                properties.entrySet().stream().filter(stringSchemaEntry -> StringUtils.isBlank((CharSequence)((Schema)stringSchemaEntry.getValue()).getDescription())).forEach(stringSchemaEntry -> {
                    Optional<Field> optionalField = fields.stream().filter(field1 -> this.findFields((Map.Entry<String, Schema>)stringSchemaEntry, (Field)field1)).findAny();
                    optionalField.ifPresent(field -> {
                        String fieldJavadoc = this.javadocProvider.getFieldJavadoc(field);
                        if (StringUtils.isNotBlank((CharSequence)fieldJavadoc)) {
                            ((Schema)stringSchemaEntry.getValue()).setDescription(fieldJavadoc);
                        }
                    });
                    if (StringUtils.isBlank((CharSequence)((Schema)stringSchemaEntry.getValue()).getDescription())) {
                        Optional<PropertyDescriptor> optionalPd = clsProperties.stream().filter(pd -> pd.getName().equals(stringSchemaEntry.getKey())).findAny();
                        optionalPd.ifPresent(pd1 -> {
                            String fieldJavadoc;
                            if (pd1.getReadMethod() != null && StringUtils.isNotBlank((CharSequence)(fieldJavadoc = this.javadocProvider.getMethodJavadocDescription(pd1.getReadMethod())))) {
                                ((Schema)stringSchemaEntry.getValue()).setDescription(fieldJavadoc);
                            }
                        });
                    }
                });
            }
        }
    }

    private boolean findFields(Map.Entry<String, Schema> stringSchemaEntry, Field field) {
        String jsonPropertyName;
        if (field.getName().equals(stringSchemaEntry.getKey())) {
            return true;
        }
        JsonProperty jsonPropertyAnnotation = field.getAnnotation(JsonProperty.class);
        return jsonPropertyAnnotation != null ? (jsonPropertyName = jsonPropertyAnnotation.value()).equals(stringSchemaEntry.getKey()) : field.getName().equalsIgnoreCase(stringSchemaEntry.getKey().replaceAll("_", ""));
    }
}

