/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.models;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.parameters.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.service.GenericParameterService;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterInfo {
    private final MethodParameter methodParameter;
    private String pName;
    private Parameter parameterModel;
    private boolean required;
    private Object defaultValue;
    private String paramType;
    private boolean requestPart;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterInfo.class);

    public ParameterInfo(String pName, MethodParameter methodParameter, GenericParameterService genericParameterService) {
        RequestHeader requestHeader = (RequestHeader)methodParameter.getParameterAnnotation(RequestHeader.class);
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        PathVariable pathVar = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
        CookieValue cookieValue = (CookieValue)methodParameter.getParameterAnnotation(CookieValue.class);
        boolean isFile = genericParameterService.isFile(methodParameter);
        this.methodParameter = methodParameter;
        this.pName = pName;
        if (requestHeader != null) {
            this.calculateParams(requestHeader);
        } else if (requestParam != null) {
            this.calculateParams(requestParam, isFile);
        } else if (pathVar != null) {
            this.calculateParams(pathVar);
        } else if (cookieValue != null) {
            this.calculateParams(cookieValue);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pName)) {
            this.pName = genericParameterService.resolveEmbeddedValuesAndExpressions(this.pName).toString();
        }
        if (this.defaultValue != null && !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(this.defaultValue.toString())) {
            this.defaultValue = genericParameterService.resolveEmbeddedValuesAndExpressions(this.defaultValue.toString());
            genericParameterService.getOptionalWebConversionServiceProvider().ifPresent(conversionService -> {
                try {
                    this.defaultValue = conversionService.convert(this.defaultValue, new TypeDescriptor(methodParameter));
                }
                catch (Exception e) {
                    LOGGER.warn("Using the following default value : {}, without spring conversionService", this.defaultValue);
                }
            });
        }
        this.required = this.required && !methodParameter.isOptional();
    }

    public String getpName() {
        return this.pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Parameter getParameterModel() {
        return this.parameterModel;
    }

    public void setParameterModel(Parameter parameterModel) {
        this.parameterModel = parameterModel;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void calculateParams(CookieValue cookieValue) {
        if (StringUtils.isNotEmpty((CharSequence)cookieValue.value())) {
            this.pName = cookieValue.value();
        }
        this.required = cookieValue.required();
        this.defaultValue = cookieValue.defaultValue();
        this.paramType = ParameterIn.COOKIE.toString();
    }

    private void calculateParams(PathVariable pathVar) {
        if (StringUtils.isNotEmpty((CharSequence)pathVar.value())) {
            this.pName = pathVar.value();
        }
        this.required = pathVar.required();
        this.paramType = ParameterIn.PATH.toString();
    }

    private void calculateParams(RequestParam requestParam, boolean isFile) {
        if (StringUtils.isNotEmpty((CharSequence)requestParam.value())) {
            this.pName = requestParam.value();
        }
        this.required = requestParam.required();
        this.defaultValue = requestParam.defaultValue();
        if (!isFile) {
            this.paramType = ParameterIn.QUERY.toString();
        }
    }

    private void calculateParams(RequestHeader requestHeader) {
        if (StringUtils.isNotEmpty((CharSequence)requestHeader.value())) {
            this.pName = requestHeader.value();
        }
        this.required = requestHeader.required();
        this.defaultValue = requestHeader.defaultValue();
        this.paramType = ParameterIn.HEADER.toString();
    }

    public boolean isRequestPart() {
        return this.requestPart;
    }

    public void setRequestPart(boolean requestPart) {
        this.requestPart = requestPart;
    }
}

